/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.integrations.mail;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.integrations.mail.MailChannelConfiguration;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMailSender {
    public abstract Session newSession();

    public abstract void send(Session var1, Message var2, InfoMessage.InfoMessages var3) throws Exception;

    public abstract Future<InfoMessage.InfoMessages> startSending(Session var1, Message var2) throws Exception;

    public abstract MailChannelConfiguration getConfiguration();

    @VisibleForTesting
    static Address[] filterRecipients(@Nullable Address[] recipients, List<String> authorizedDomainList, InfoMessage.InfoMessages messages, boolean requiresAtLeastOneValidAddress) throws UnauthorizedException {
        if (recipients == null) {
            recipients = new Address[]{};
        }
        if (authorizedDomainList.isEmpty()) {
            return recipients;
        }
        String regex = "@((?:[a-zA-Z0-9-]+\\.)+\\w+)$";
        Pattern pattern = Pattern.compile(regex);
        ArrayList<Address> acceptedAddresses = new ArrayList<Address>();
        for (Address address : recipients) {
            Matcher matcher = pattern.matcher(address.toString());
            if (matcher.find()) {
                String domain = matcher.group(1);
                if (authorizedDomainList.stream().anyMatch(domain::endsWith)) {
                    acceptedAddresses.add(address);
                    continue;
                }
                messages.addMessage(InfoMessage.warning((String)"Unauthorized email address", (String)("Mail has not been sent to \"" + String.valueOf(address) + "\" because its domain is not authorized.")));
                continue;
            }
            messages.addMessage(InfoMessage.warning((String)"Invalid email address", (String)("Mail has not been sent to \"" + String.valueOf(address) + "\" because it is an invalid email address.")));
        }
        if (requiresAtLeastOneValidAddress && acceptedAddresses.isEmpty()) {
            String errorMsg = recipients.length == 1 ? "Mail cannot be sent because the domain of \"" + String.valueOf(recipients[0]) + "\" is not authorized." : "Mail cannot be sent because the domains of all recipients are not authorized: " + Arrays.stream(recipients).map(Address::toString).collect(Collectors.joining(", "));
            throw new UnauthorizedException(errorMsg, "send-mail-unauthorized-recipients");
        }
        return acceptedAddresses.toArray(new Address[0]);
    }

    protected static void filterMailRecipients(@Nullable String authorizedDomains, Message mail, InfoMessage.InfoMessages messages) throws MessagingException, UnauthorizedException {
        if (StringUtils.isNotBlank((String)authorizedDomains)) {
            List<String> authorizedDomainList = Arrays.asList(authorizedDomains.trim().split("\\s*,\\s*"));
            mail.setRecipients(Message.RecipientType.TO, AbstractMailSender.filterRecipients(mail.getRecipients(Message.RecipientType.TO), authorizedDomainList, messages, true));
            mail.setRecipients(Message.RecipientType.CC, AbstractMailSender.filterRecipients(mail.getRecipients(Message.RecipientType.CC), authorizedDomainList, messages, false));
            mail.setRecipients(Message.RecipientType.BCC, AbstractMailSender.filterRecipients(mail.getRecipients(Message.RecipientType.BCC), authorizedDomainList, messages, false));
        }
    }
}

