/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.kernel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.kernel.KernelPoolThreadFactory;
import com.dataiku.dip.kernel.KernelScalingStrategy;
import com.dataiku.dip.kernel.KernelScalingStrategyBuilder;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.com.google.common.cache.Cache;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.collect.LinkedHashMultimap;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class KernelPool<KernelType, KernelGroupType, KernelDescType extends KernelGroupType> {
    private final ScheduledExecutorService maintenanceThreadPool;
    private final ExecutorService dispatcherThreadPool;
    private final ExecutorService requestCompletionHandlerThreadPool;
    private final KernelController<KernelType, KernelGroupType, KernelDescType> controller;
    private final LinkedHashMultimap<String, String> groupHashToDescHash = LinkedHashMultimap.create();
    private final LinkedHashMultimap<String, KernelHandle> kernels = LinkedHashMultimap.create();
    private final LinkedHashMultimap<String, Request<?>> requests = LinkedHashMultimap.create();
    private final HashMap<String, Instant> lastStartupFailure = new HashMap();
    private final LinkedList<KernelHandle> graveyard = new LinkedList();
    private final Map<String, KernelScalingStrategy> scalingStrategies = new HashMap<String, KernelScalingStrategy>();
    private final KernelScalingStrategyBuilder<KernelGroupType, KernelDescType> scalingStrategyBuilder;
    private boolean closed = false;
    private final long schedulingPeriodInMs;
    private final DKULogger logger;
    private static final long DEFAULT_SCHEDULING_PERIOD_IN_MS = 1000L;
    private static final int MAX_JSON_SAMPLE_LOG_LENGTH = 120;
    private static final int DEFAULT_RETRY_START_IN_SEC = 30;
    private long requestCounter;
    private static final int MAX_AUTOSCALE_TIME_WINDOW = (int)ChronoUnit.DAYS.getDuration().getSeconds();
    private final Cache<String, Boolean> logCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofSeconds(60L)).build();
    private long recordedLastTick = -1L;

    KernelPool(KernelController<KernelType, KernelGroupType, KernelDescType> controller, KernelScalingStrategyBuilder<KernelGroupType, KernelDescType> scalingStrategyBuilder, KernelPoolThreadFactory kernelPoolThreadFactory, DKULogger logger, long schedulingPeriodInMs) {
        this.logger = logger;
        this.controller = controller;
        this.scalingStrategyBuilder = scalingStrategyBuilder;
        this.maintenanceThreadPool = kernelPoolThreadFactory.buildMaintenanceThreadPool();
        this.dispatcherThreadPool = kernelPoolThreadFactory.buildDispatcherThreadPool();
        this.requestCompletionHandlerThreadPool = kernelPoolThreadFactory.buildRequestCompletionHandlerThreadPool();
        this.dispatcherThreadPool.submit(this::dispatchForever);
        this.schedulingPeriodInMs = schedulingPeriodInMs;
        this.maintenanceThreadPool.scheduleWithFixedDelay(this::maintainKernels, 0L, schedulingPeriodInMs, TimeUnit.MILLISECONDS);
    }

    public KernelPool(KernelController<KernelType, KernelGroupType, KernelDescType> controller, String kernelPoolName, DKULogger logger) {
        this(controller, new KernelScalingStrategyBuilder(), new KernelPoolThreadFactory(kernelPoolName), logger, 1000L);
    }

    public synchronized PoolDump dump(boolean full) {
        DescStateDump descState;
        TreeMap<String, DescStateDump> descStatesMap = new TreeMap<String, DescStateDump>();
        Instant nowInstant = Instant.now();
        long nowLong = System.nanoTime();
        ArrayList<KernelHandle> allKernels = new ArrayList<KernelHandle>(this.kernels.values());
        allKernels.addAll(this.graveyard);
        for (KernelHandle kernelHandle : allKernels) {
            descState = descStatesMap.computeIfAbsent(kernelHandle.kernelSpec.kernelDescHash, DescStateDump::new);
            if (kernelHandle.state == KernelState.STARTING) {
                ++descState.nbStartingKernels;
            } else if (kernelHandle.state == KernelState.READY || kernelHandle.state == KernelState.SENTENCED) {
                ++descState.nbActiveKernels;
            }
            PoolDump.KernelDump kernelDump = new PoolDump.KernelDump();
            kernelDump.kernelDescHash = kernelHandle.kernelSpec.kernelDescHash;
            kernelDump.deathError = kernelHandle.deathError;
            kernelDump.modelId = this.controller.getModelId(kernelHandle.kernel);
            kernelDump.state = kernelHandle.state;
            Instant endOfSentenced = Optional.ofNullable(kernelHandle.diedAtTime).orElse(nowInstant);
            Instant endOfReady = Optional.ofNullable(kernelHandle.sentencedAtTime).orElse(endOfSentenced);
            Instant endOfStarting = Optional.ofNullable(kernelHandle.readyAtTime).orElse(endOfReady);
            if (kernelHandle.startingAtTime != null) {
                kernelDump.startingAtTime = kernelHandle.startingAtTime.toString();
                kernelDump.startupTimeMs = ChronoUnit.MILLIS.between(kernelHandle.startingAtTime, endOfStarting);
            }
            if (kernelHandle.readyAtTime != null) {
                kernelDump.readyAtTime = kernelHandle.readyAtTime.toString();
                kernelDump.runningTimeMs = ChronoUnit.MILLIS.between(kernelHandle.readyAtTime, endOfSentenced);
            }
            if (kernelHandle.sentencedAtTime != null) {
                kernelDump.sentencedAtTime = kernelHandle.sentencedAtTime.toString();
                kernelDump.sentencedTimeMs = ChronoUnit.MILLIS.between(kernelHandle.sentencedAtTime, endOfSentenced);
            }
            if (kernelHandle.diedAtTime != null) {
                kernelDump.diedAtTime = kernelHandle.diedAtTime.toString();
                kernelDump.deadSinceTimeMs = ChronoUnit.MILLIS.between(kernelHandle.diedAtTime, nowInstant);
            }
            kernelDump.deathReason = kernelHandle.deathReason;
            kernelDump.id = this.controller.getKernelId(kernelHandle.kernel);
            kernelDump.podName = this.controller.getPodName(kernelHandle.kernel);
            kernelDump.nbActiveRequests = kernelHandle.requests.size();
            kernelDump.nbSuccessfulRequests = kernelHandle.nbSuccessfulRequests;
            kernelDump.nbFailedRequests = kernelHandle.nbFailedRequests;
            kernelDump.nbCancelledRequests = kernelHandle.nbCancelledRequests;
            if (full) {
                kernelDump.kernelDesc = this.controller.dumpKernelDescForDebug(kernelHandle.kernelSpec.kernelDesc);
            }
            descState.kernels.add(kernelDump);
        }
        for (Request request : this.requests.values()) {
            descState = descStatesMap.computeIfAbsent(request.kernelSpec.kernelDescHash, DescStateDump::new);
            if (request.state == RequestState.QUEUED) {
                ++descState.nbPendingRequests;
            } else if (request.state == RequestState.DISPATCHED) {
                ++descState.nbActiveRequests;
            }
            PoolDump.RequestDump requestDump = new PoolDump.RequestDump();
            requestDump.id = request.id;
            requestDump.state = request.state;
            long endOfProcessing = request.completedAtTime > 0L ? request.completedAtTime : nowLong;
            long endOfQueued = request.dispatchedAtTime > 0L ? request.dispatchedAtTime : endOfProcessing;
            requestDump.totalTimeMs = TimeUnit.NANOSECONDS.toMillis(endOfProcessing - request.arrivedAtTime);
            requestDump.pendingTimeMs = TimeUnit.NANOSECONDS.toMillis(endOfQueued - request.arrivedAtTime);
            if (request.dispatchedAtTime > 0L) {
                requestDump.processingTimeMs = TimeUnit.NANOSECONDS.toMillis(endOfProcessing - request.dispatchedAtTime);
            }
            if (request.completedAtTime > 0L) {
                requestDump.completedSinceTimeMs = TimeUnit.NANOSECONDS.toMillis(nowLong - request.completedAtTime);
            }
            requestDump.kernelDescHash = request.kernelSpec.kernelDescHash;
            String string = requestDump.kernelId = request.kernelHandle != null ? this.controller.getKernelId(request.kernelHandle.kernel) : "N/A";
            if (full) {
                requestDump.requestKernelDesc = this.controller.dumpKernelDescForDebug(request.kernelSpec.kernelDesc);
                requestDump.requestPayload = request.requestPayload;
            }
            descState.requests.add(requestDump);
        }
        return new PoolDump(descStatesMap.values());
    }

    @VisibleForTesting
    synchronized void maintainKernels() {
        try {
            this.autoscaleKernelPool();
            this.updateKernelAndRequestStates();
        }
        catch (Throwable e) {
            this.logger.error((Object)"KernelManager maintenance task failed", e);
        }
    }

    private void autoscaleKernelPool() {
        List<Request> queuedRequestsWithoutLiveKernel;
        long availableRoom;
        long neededRoomForReservedCapacity;
        long extraNeededRoomForReservedCapacity;
        Collection<ReservedCapacityRequest<KernelGroupType, KernelDescType>> kernelsWithMinCountRaw;
        int tempMaxKernelCount;
        try {
            tempMaxKernelCount = this.controller.getGlobalMaxKernelCount();
        }
        catch (Throwable e) {
            tempMaxKernelCount = this.kernels.size();
            this.errorDedup("Failed to retrieve global instance max kernel capacity, falling back to using the current kernels count as limit (" + tempMaxKernelCount + ")", e);
        }
        int maxKernelCount = tempMaxKernelCount;
        KernelPoolCache<Object, Boolean> kernelDescIsOutdated = new KernelPoolCache<Object, Boolean>((desc, descHash) -> {
            try {
                return this.controller.isOutdated(desc);
            }
            catch (Throwable e) {
                this.errorDedup("[" + descHash + "] Failed to assess outdatedness, kernel desc will be considered up-to-date", e);
                return false;
            }
        });
        KernelPoolCache<Object, Integer> kernelGroupToMaxKernelCount = new KernelPoolCache<Object, Integer>((group, groupHash) -> {
            try {
                return this.controller.getMaxKernelCount(group);
            }
            catch (Throwable e) {
                int groupSize = this.groupHashToDescHash.get(groupHash).stream().mapToInt(descHash -> this.kernels.get(descHash).size()).sum();
                this.errorDedup("Failed to retrieve max capacity for kernels of group [" + groupHash + "], falling back to using current group kernels count as limit (" + groupSize + ")", e);
                return groupSize;
            }
        });
        try {
            kernelsWithMinCountRaw = this.controller.getKernelsWithMinCount();
            if (kernelsWithMinCountRaw == null) {
                throw new NullPointerException("Expected getKernelsWithMinCount() to return a non-null Collection");
            }
            kernelsWithMinCountRaw.forEach(rcRequest -> {
                if (rcRequest == null) {
                    throw new NullPointerException("Expected getKernelsWithMinCount() returned collection to only contain non-null items");
                }
                if (rcRequest.kernelDesc == null || rcRequest.kernelDescHash == null || rcRequest.kernelGroup == null || rcRequest.kernelGroupHash == null) {
                    throw new NullPointerException("Expected getKernelsWithMinCount() returned collection items to only have non-null fields");
                }
            });
        }
        catch (Throwable e) {
            this.errorDedup("Failed to retrieve reserved capacities, proceeding without them", e);
            kernelsWithMinCountRaw = Collections.emptyList();
        }
        HashMap kernelsWithMinCount = new HashMap();
        kernelsWithMinCountRaw.forEach(rcRequest -> {
            Integer max = (Integer)kernelGroupToMaxKernelCount.get(rcRequest.kernelGroup, rcRequest.kernelGroupHash);
            int min = rcRequest.minKernelCount;
            if (max != null && max < min) {
                ReservedCapacityRequest fixedRcRequest = new ReservedCapacityRequest(max, rcRequest);
                kernelsWithMinCount.put(rcRequest.kernelDescHash, fixedRcRequest);
            } else {
                kernelsWithMinCount.put(rcRequest.kernelDescHash, (ReservedCapacityRequest)rcRequest);
            }
        });
        ScalingResult scalingResult = this.updateAndExecuteAutoscalingStrategies();
        this.kernels.keySet().forEach(hash -> {
            List<KernelHandle> liveKernels = this.streamLive(this.kernels.get(hash)).toList();
            long activeKernelsCountForHash = liveKernels.size();
            if (activeKernelsCountForHash > 0L) {
                long excessKernelsCountForHash;
                Integer maxKernelsForHash;
                KernelHandle kh = liveKernels.get(0);
                DeathReason reason = DeathReason.PER_KERNEL_MAX_LIMIT;
                if (Boolean.TRUE.equals(kernelDescIsOutdated.get(kh.kernelSpec.kernelDesc, kh.kernelSpec.kernelDescHash)) && this.requests.get(hash).stream().noneMatch(request -> request.state == RequestState.QUEUED)) {
                    maxKernelsForHash = 0;
                    reason = DeathReason.OUTDATED;
                } else {
                    maxKernelsForHash = (Integer)kernelGroupToMaxKernelCount.get(kh.kernelSpec.kernelGroup, kh.kernelSpec.kernelGroupHash);
                }
                if (Boolean.TRUE.equals(kernelDescIsOutdated.get(kh.kernelSpec.kernelDesc, kh.kernelSpec.kernelDescHash)) && (maxKernelsForHash == null || maxKernelsForHash > 0)) {
                    kernelsWithMinCount.put((String)hash, new ReservedCapacityRequest(1, kh.kernelSpec));
                }
                if (maxKernelsForHash != null && (excessKernelsCountForHash = activeKernelsCountForHash - (long)maxKernelsForHash.intValue()) > 0L) {
                    this.logger.infoV("[%s] Scaling down %s kernels to comply with max kernels limit %s", new Object[]{hash, excessKernelsCountForHash, maxKernelsForHash});
                    this.scaleDown((String)hash, excessKernelsCountForHash, reason, (Map<String, ReservedCapacityRequest<KernelGroupType, KernelDescType>>)kernelsWithMinCount);
                }
            }
        });
        scalingResult.down().removeIf(hash -> this.kernels.get(hash).stream().anyMatch(k -> k.state == KernelState.SENTENCED || k.state == KernelState.DYING));
        scalingResult.down().removeIf(hash -> kernelsWithMinCount.get(hash) != null && (long)((ReservedCapacityRequest)kernelsWithMinCount.get((Object)hash)).minKernelCount >= this.streamLive(this.kernels.get(hash)).count());
        for (String hash2 : scalingResult.down()) {
            this.logger.debugV("[%s] Scaling down 1 kernel to comply with strategy", new Object[]{hash2});
            this.scaleDown(hash2, 1L, DeathReason.STRATEGY, kernelsWithMinCount);
        }
        long activeKernelsCount = this.streamLive(this.kernels.values()).count();
        long roomToMake = activeKernelsCount - (long)maxKernelCount;
        if (roomToMake > 0L) {
            this.logger.infoV("Scaling down %s kernels to comply with global max kernels limit %s", new Object[]{roomToMake, maxKernelCount});
            this.scaleDown(roomToMake, DeathReason.GLOBAL_MAX_LIMIT, kernelsWithMinCount);
        }
        activeKernelsCount = this.streamLive(this.kernels.values()).count();
        long reservedCapacityRequested = kernelsWithMinCount.values().stream().mapToLong(rcRequest -> rcRequest.minKernelCount).sum();
        long reservedCapacityFulfilled = kernelsWithMinCount.keySet().stream().mapToLong(hash -> Math.min(this.streamLive(this.kernels.get(hash)).count(), (long)((ReservedCapacityRequest)kernelsWithMinCount.get((Object)hash)).minKernelCount)).sum();
        long reclaimableRoom = activeKernelsCount - reservedCapacityFulfilled;
        long roomToMake2 = Math.min(reclaimableRoom, extraNeededRoomForReservedCapacity = (neededRoomForReservedCapacity = reservedCapacityRequested - reservedCapacityFulfilled) - (availableRoom = (long)maxKernelCount - activeKernelsCount));
        if (roomToMake2 > 0L) {
            this.logger.infoV("Scaling down additional %s kernels to make room for reserved capacity", new Object[]{roomToMake2});
            this.scaleDown(roomToMake2, DeathReason.ROOM_FOR_RESERVED_CAPACITY, kernelsWithMinCount);
        }
        kernelsWithMinCount.forEach((hash, rcRequest) -> {
            int reservedCapacityForHash = rcRequest.minKernelCount;
            long kernelsCountForHash = this.kernels.get(hash).size();
            if ((long)reservedCapacityForHash > kernelsCountForHash) {
                this.debugDedup("[" + hash + "] Kernel has not reached reserved capacity (" + kernelsCountForHash + "/" + reservedCapacityForHash + ")");
                int i = 0;
                while ((long)i < (long)reservedCapacityForHash - kernelsCountForHash) {
                    this.tryScaleUp((KernelSpec<KernelGroupType, KernelDescType>)rcRequest, (KernelPoolCache<KernelGroupType, Integer>)kernelGroupToMaxKernelCount, maxKernelCount, (KernelPoolCache<KernelDescType, Boolean>)kernelDescIsOutdated);
                    ++i;
                }
            }
        });
        scalingResult.up().removeIf(hash -> this.kernels.get(hash).stream().anyMatch(k -> k.state == KernelState.STARTING));
        scalingResult.up().stream().sorted(this.scalingUpComparator()).forEach(hash -> {
            Request request = this.requests.get(hash).stream().filter(req -> req.state == RequestState.QUEUED || req.state == RequestState.DISPATCHED).findFirst().orElse(null);
            if (request == null) {
                return;
            }
            this.tryScaleUp(request.kernelSpec, kernelGroupToMaxKernelCount, maxKernelCount, kernelDescIsOutdated);
        });
        List<Request> queuedRequestsWithoutLiveKernelTargetingExtinct = this.requests.values().stream().filter(request -> request.state == RequestState.QUEUED && ((Boolean)kernelDescIsOutdated.get(request.kernelSpec.kernelDesc, request.kernelSpec.kernelDescHash) != false || Integer.valueOf(0).equals(kernelGroupToMaxKernelCount.get(request.kernelSpec.kernelGroup, request.kernelSpec.kernelGroupHash))) && this.streamLive(this.kernels.get((Object)request.kernelSpec.kernelDescHash)).findAny().isEmpty()).toList();
        queuedRequestsWithoutLiveKernelTargetingExtinct.forEach(request -> this.handleResponse((Request)request, null, new RuntimeException("Can't start a new kernel for this request because the kernel settings are outdated or explicitly set max kernel limit to 0")));
        if (this.streamLive(this.kernels.values()).count() >= (long)maxKernelCount && !(queuedRequestsWithoutLiveKernel = this.requests.values().stream().filter(request -> request.state == RequestState.QUEUED && this.streamLive(this.kernels.get((Object)request.kernelSpec.kernelDescHash)).findAny().isEmpty()).toList()).isEmpty()) {
            Set aboveReservedCapacityKernelHashes = this.kernels.keySet().stream().filter(hash -> kernelsWithMinCount.get(hash) == null || this.streamLive(this.kernels.get(hash)).count() > (long)((ReservedCapacityRequest)kernelsWithMinCount.get((Object)hash)).minKernelCount).collect(Collectors.toSet());
            boolean noLiveOutdated = kernelsWithMinCount.values().stream().noneMatch(rcRequest -> {
                String hash = rcRequest.kernelDescHash;
                Object desc = rcRequest.kernelDesc;
                return this.streamLive(this.kernels.get((Object)hash)).findAny().isPresent() && (Boolean)kernelDescIsOutdated.get(desc, hash) != false;
            });
            if (aboveReservedCapacityKernelHashes.isEmpty() && noLiveOutdated) {
                queuedRequestsWithoutLiveKernel.forEach(request -> this.handleResponse((Request)request, null, new RuntimeException("Can't find space to start a new kernel for this request")));
            } else {
                this.kernels.values().stream().filter(k -> k.state == KernelState.READY).filter(k -> k.requests.isEmpty()).filter(k -> aboveReservedCapacityKernelHashes.contains(k.kernelSpec.kernelDescHash)).findFirst().ifPresent(kernel -> {
                    this.logger.infoV("[%s] Scaling down kernel to free space for other required kernels", new Object[]{kernel.kernelSpec.kernelDescHash});
                    this.scaleDown((KernelHandle)kernel, DeathReason.ROOM_FOR_REQUEST);
                });
            }
        }
    }

    @Nonnull
    private ScalingResult updateAndExecuteAutoscalingStrategies() {
        Iterator<Object> iterator;
        long currentTick;
        long lastTick = this.recordedLastTick == -1L ? System.nanoTime() - this.schedulingPeriodInMs * 1000000L : this.recordedLastTick;
        this.recordedLastTick = currentTick = System.nanoTime();
        HashMap allKernelSpecs = new HashMap();
        for (String kernelDescHash2 : this.requests.keySet()) {
            iterator = this.requests.get((Object)kernelDescHash2).iterator();
            if (!iterator.hasNext()) continue;
            Request request = (Request)iterator.next();
            allKernelSpecs.put(request.kernelSpec.kernelDescHash, request.kernelSpec);
        }
        for (String kernelDescHash2 : this.kernels.keySet()) {
            iterator = this.kernels.get((Object)kernelDescHash2).iterator();
            if (!iterator.hasNext()) continue;
            KernelHandle kernelHandle = (KernelHandle)iterator.next();
            allKernelSpecs.put(kernelHandle.kernelSpec.kernelDescHash, kernelHandle.kernelSpec);
        }
        HashSet<String> kernelDescHashesToScaleUp = new HashSet<String>();
        HashSet<String> kernelDescHashesToScaleDown = new HashSet<String>();
        for (KernelSpec kernelSpec : allKernelSpecs.values()) {
            int ret;
            String kernelDescHash3 = kernelSpec.kernelDescHash;
            KernelScalingStrategy strategy = this.getOrCreateScalingStrategy(kernelSpec);
            List<RequestSnapshot> requestSnapshots = this.requests.get((Object)kernelDescHash3).stream().map(r -> new RequestSnapshot(r.state, r.arrivedAtTime, r.completedAtTime)).toList();
            List<KernelSnapshot> kernelSnapshots = this.kernels.get((Object)kernelDescHash3).stream().map(k -> new KernelSnapshot(k.state, this.controller.getSoftMaxParallelRequests(k.kernelSpec.kernelDesc), k.requests.size())).toList();
            int requestedWindowSize = this.controller.getAutoscaleTimeWindowSeconds(kernelSpec.kernelDesc);
            int usedWindowSize = requestedWindowSize;
            if (usedWindowSize <= 0) {
                usedWindowSize = 1;
                this.debugDedup("[" + kernelDescHash3 + "] Autoscale time window is too small (" + requestedWindowSize + "s), falling back to " + usedWindowSize + "s");
            }
            if (usedWindowSize > MAX_AUTOSCALE_TIME_WINDOW) {
                usedWindowSize = MAX_AUTOSCALE_TIME_WINDOW;
                this.debugDedup("[" + kernelDescHash3 + "] Autoscale time window is too large (" + requestedWindowSize + "s), falling back to " + usedWindowSize + "s");
            }
            if ((ret = strategy.execute(requestSnapshots, kernelSnapshots, usedWindowSize, lastTick, currentTick)) > 0) {
                kernelDescHashesToScaleUp.add(kernelDescHash3);
                continue;
            }
            if (ret >= 0) continue;
            kernelDescHashesToScaleDown.add(kernelDescHash3);
        }
        this.scalingStrategies.keySet().removeIf(kernelDescHash -> {
            if (!allKernelSpecs.containsKey(kernelDescHash)) {
                this.logger.infoV("[%s] Clearing scaling strategy", new Object[]{kernelDescHash});
                return true;
            }
            return false;
        });
        return new ScalingResult(kernelDescHashesToScaleUp, kernelDescHashesToScaleDown);
    }

    private Comparator<String> scalingUpComparator() {
        return Comparator.comparing(this::getNbKernels).thenComparing(this::getNbPendingRequests, Comparator.reverseOrder());
    }

    private Comparator<KernelHandle> scalingDownComparator(Map<String, ReservedCapacityRequest<KernelGroupType, KernelDescType>> kernelsWithMinCount) {
        return Comparator.comparing(k -> kernelsWithMinCount.get(k.kernelSpec.kernelDescHash) != null && this.streamLive(this.kernels.get((Object)k.kernelSpec.kernelDescHash)).count() <= (long)((ReservedCapacityRequest)kernelsWithMinCount.get((Object)k.kernelSpec.kernelDescHash)).minKernelCount ? 1 : 0).thenComparing(k -> k.state == KernelState.STARTING ? 0 : 1).thenComparing(k -> (double)k.requests.size() * 1.0 / (double)k.maxRequests);
    }

    private void updateKernelAndRequestStates() {
        int graveyardTimeout = KernelPool.getGraveyardTimeout();
        int graveyardSizeLimit = KernelPool.getGraveyardMaxSize();
        while (!this.graveyard.isEmpty() && this.graveyard.get((int)0).diedAtTime.plus((long)graveyardTimeout, ChronoUnit.SECONDS).isBefore(Instant.now())) {
            this.graveyard.removeFirst();
        }
        while (this.graveyard.size() > graveyardSizeLimit) {
            this.graveyard.removeFirst();
        }
        this.requests.values().removeIf(request -> request.state == RequestState.COMPLETED);
        for (KernelHandle kernelHandle : this.kernels.values()) {
            boolean isAlive;
            if (kernelHandle.state != KernelState.READY && kernelHandle.state != KernelState.SENTENCED) continue;
            try {
                isAlive = this.controller.isAlive(kernelHandle.kernel);
            }
            catch (Throwable e) {
                this.logger.error((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Failed to assess if kernel " + this.controller.getKernelId(kernelHandle.kernel) + " is alive: kernel will be considered dead"), e);
                isAlive = false;
            }
            if (isAlive) continue;
            if (kernelHandle.deathReason == null) {
                this.logger.error((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Kernel " + this.controller.getKernelId(kernelHandle.kernel) + " seems to have died"));
                kernelHandle.deathReason = DeathReason.FAIL_RUNNING;
            }
            kernelHandle.sentence();
            new ArrayList(kernelHandle.requests).forEach((Consumer<Request<?>>)((Consumer<Request>)r -> this.handleResponse((Request)r, null, new RuntimeException("Kernel died"))));
        }
        for (KernelHandle kernelHandle : this.kernels.values()) {
            if (kernelHandle.state != KernelState.STARTING || !kernelHandle.startingFuture.isDone()) continue;
            try {
                DKUCompletableFuture.collectResponse(kernelHandle.startingFuture);
                this.lastStartupFailure.remove(kernelHandle.kernelSpec.kernelDescHash);
                kernelHandle.readyAtTime = Instant.now();
                kernelHandle.state = KernelState.READY;
                this.logger.info((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Kernel started with id: " + this.controller.getKernelId(kernelHandle.kernel)));
                this.notifyAll();
            }
            catch (Throwable e) {
                if (kernelHandle.deathReason == null) {
                    kernelHandle.deathReason = DeathReason.FAIL_START;
                }
                this.logger.error((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Failed to start kernel " + this.controller.getKernelId(kernelHandle.kernel) + ", aborting queued request(s)"), e);
                kernelHandle.sentence();
                this.lastStartupFailure.put(kernelHandle.kernelSpec.kernelDescHash, Instant.now());
                this.abortQueuedRequestsIfNeeded(kernelHandle.kernelSpec.kernelDescHash, e);
            }
        }
        for (KernelHandle kernelHandle : this.kernels.values()) {
            if (kernelHandle.state != KernelState.SENTENCED || !kernelHandle.requests.isEmpty()) continue;
            this.logger.info((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Killing kernel " + this.controller.getKernelId(kernelHandle.kernel)));
            this.initiateKillKernel(kernelHandle);
        }
        Long queuedTimeout = this.controller.getQueuedRequestTimeoutInNs();
        if (queuedTimeout != null) {
            for (Request request2 : this.requests.values()) {
                if (request2.state != RequestState.QUEUED) continue;
                if (System.nanoTime() - request2.arrivedAtTime < queuedTimeout) break;
                this.logger.warn((Object)("[" + request2.kernelSpec.kernelDescHash + "] Request " + request2.id + " timed out, cancelling"));
                this.handleResponse(request2, null, new TimeoutException("Request timed out in queue"));
            }
        }
    }

    private void abortQueuedRequestsIfNeeded(String hash, Throwable e) {
        if (this.kernels.get((Object)hash).stream().filter(k -> k.state == KernelState.READY).findFirst().isEmpty()) {
            List<Request> queuedRequestsForHash = this.requests.get((Object)hash).stream().filter(r -> r.state == RequestState.QUEUED).toList();
            queuedRequestsForHash.forEach(r -> this.handleResponse((Request)r, null, e));
        }
    }

    private synchronized void initiateKillKernel(KernelHandle kernelHandle) {
        kernelHandle.state = KernelState.DYING;
        if (!kernelHandle.startingFuture.isDone()) {
            this.logger.warn((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Kernel " + this.controller.getKernelId(kernelHandle.kernel) + " is being killed before it started"));
        }
        this.killKernelSafely(kernelHandle);
    }

    private synchronized void killKernelSafely(KernelHandle kernelHandle) {
        CompletableFuture<Object> killFuture;
        try {
            killFuture = this.controller.killKernel(kernelHandle.kernel);
            if (killFuture == null) {
                throw new NullPointerException("Expected killKernel() to return a CompletableFuture but got null");
            }
        }
        catch (Throwable e) {
            killFuture = CompletableFuture.failedFuture(e);
        }
        killFuture.whenCompleteAsync((r, ex) -> this.handleKilledKernel(kernelHandle, (Throwable)ex), (Executor)this.maintenanceThreadPool);
    }

    private synchronized KernelScalingStrategy getOrCreateScalingStrategy(KernelSpec<KernelGroupType, KernelDescType> kernelSpec) {
        return this.scalingStrategies.computeIfAbsent(kernelSpec.kernelDescHash, h -> {
            KernelScalingStrategy newStrategy = this.scalingStrategyBuilder.buildKernelStrategy(kernelSpec, this.logger);
            this.logger.infoV("[%s] Creating a new scaling strategy", new Object[]{kernelSpec.kernelDescHash});
            return newStrategy;
        });
    }

    private synchronized void handleKilledKernel(KernelHandle kernelHandle, Throwable ex) {
        if (!this.kernels.remove((Object)kernelHandle.kernelSpec.kernelDescHash, (Object)kernelHandle)) {
            return;
        }
        if (this.kernels.get((Object)kernelHandle.kernelSpec.kernelDescHash).isEmpty()) {
            this.groupHashToDescHash.remove((Object)kernelHandle.kernelSpec.kernelGroupHash, (Object)kernelHandle.kernelSpec.kernelDescHash);
        }
        if (ex != null) {
            this.logger.error((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Error while killing kernel " + this.controller.getKernelId(kernelHandle.kernel) + ". Resources may leak as a result."), ex);
            kernelHandle.deathError = ExceptionUtils.formatMessage((Throwable)ex);
        }
        kernelHandle.state = KernelState.DEAD;
        kernelHandle.diedAtTime = Instant.now();
        int graveyardSizeLimit = KernelPool.getGraveyardMaxSize();
        while (this.graveyard.size() >= graveyardSizeLimit) {
            this.graveyard.removeFirst();
        }
        this.graveyard.add(kernelHandle);
        this.notifyAll();
    }

    private <ResponseType> void dispatchRequest(KernelHandle kernelHandle, Request<ResponseType> req) {
        CompletableFuture<Object> execFuture;
        this.logger.debug((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Dispatching request " + req.id + " to kernel " + this.controller.getKernelId(kernelHandle.kernel)));
        req.kernelHandle = kernelHandle;
        kernelHandle.requests.add(req);
        req.state = RequestState.DISPATCHED;
        req.dispatchedAtTime = System.nanoTime();
        try {
            execFuture = req.run.execute(kernelHandle.kernel);
            if (execFuture == null) {
                throw new NullPointerException("Expected execute() to return a CompletableFuture but got null");
            }
        }
        catch (Throwable e) {
            execFuture = CompletableFuture.failedFuture(e);
        }
        CompletableFuture<Object> finalExecFuture = execFuture;
        req.resultFuture.whenCompleteAsync((responseType, throwable) -> {
            if (!finalExecFuture.isDone()) {
                finalExecFuture.cancel(true);
            }
        }, (Executor)this.requestCompletionHandlerThreadPool);
        execFuture.whenCompleteAsync((responseType, throwable) -> this.handleResponse(req, (Object)responseType, (Throwable)throwable), (Executor)this.requestCompletionHandlerThreadPool);
    }

    private synchronized void dispatchForever() {
        while (true) {
            try {
                this.dispatch();
            }
            catch (Throwable e) {
                this.logger.error((Object)"KernelPool dispatcher loop failed", e);
            }
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"KernelPool dispatcher thread interrupted", (Throwable)e);
                return;
            }
        }
    }

    @VisibleForTesting
    synchronized void dispatch() {
        block0: for (String hash : this.requests.keySet()) {
            List<KernelHandle> availableKernels = this.kernels.get((Object)hash).stream().filter(k -> k.state == KernelState.READY).toList();
            for (Request request : this.requests.get((Object)hash)) {
                if (request.state != RequestState.QUEUED) continue;
                KernelHandle leastBusyKernel = availableKernels.stream().filter(k -> k.requests.size() < k.maxRequests && this.controller.isAlive(k.kernel)).min(Comparator.comparingInt(k -> k.requests.size())).orElse(null);
                if (leastBusyKernel == null) continue block0;
                this.dispatchRequest(leastBusyKernel, request);
            }
        }
    }

    public synchronized void shutdown() {
        this.logger.info((Object)"Shutting down kernel pool");
        if (this.closed) {
            this.logger.info((Object)"KernelPool is already closed");
            return;
        }
        this.closed = true;
        this.maintenanceThreadPool.shutdownNow();
        this.dispatcherThreadPool.shutdownNow();
        this.requestCompletionHandlerThreadPool.shutdownNow();
        for (KernelHandle kernelHandle : this.kernels.values()) {
            for (Request request : kernelHandle.requests) {
                request.resultFuture.completeExceptionally(new RuntimeException("Kernel pool shutdown"));
            }
            kernelHandle.requests.clear();
            this.logger.info((Object)("[" + kernelHandle.kernelSpec.kernelDescHash + "] Killing kernel " + this.controller.getKernelId(kernelHandle.kernel)));
            kernelHandle.state = KernelState.DYING;
            this.killKernelSafely(kernelHandle);
        }
        this.requests.clear();
        this.kernels.clear();
        this.groupHashToDescHash.clear();
        this.logger.info((Object)"Shutdown completed");
    }

    private Integer getNbKernels(String hash) {
        return this.kernels.get((Object)hash).size();
    }

    private Stream<KernelHandle> streamLive(Collection<KernelHandle> kernels) {
        return kernels.stream().filter(k -> k.state != KernelState.DYING && k.state != KernelState.SENTENCED);
    }

    private Long getNbPendingRequests(String hash) {
        return this.requests.get((Object)hash).stream().filter(r -> r.state == RequestState.QUEUED).count();
    }

    public synchronized void clearKernels(Predicate<KernelDescType> kernelDescPredicate, DeathReason reason) {
        this.kernels.values().stream().filter(kernelHandle -> kernelDescPredicate.test(kernelHandle.kernelSpec.kernelDesc)).forEach(k -> this.scaleDown((KernelHandle)k, reason));
    }

    public synchronized void killAllKernels(DeathReason reason) {
        this.clearKernels(kernelDesc -> true, reason);
    }

    public synchronized void killAllRequests() {
        for (Request req : new ArrayList(this.requests.values())) {
            this.handleResponse(req, null, new CancellationException("Cancelled"));
        }
    }

    public synchronized void killKernel(String kernelId, DeathReason reason) {
        this.kernels.values().stream().filter(kernelHandle -> this.controller.getKernelId(kernelHandle.kernel).equals(kernelId)).filter(k -> k.state == KernelState.STARTING || k.state == KernelState.READY).findAny().ifPresent(k -> this.scaleDown((KernelHandle)k, reason));
    }

    public synchronized boolean forceStopKernel(String kernelId, DeathReason reason) {
        Optional<KernelHandle> optKernel = this.kernels.values().stream().filter(kernelHandle -> this.controller.getKernelId(kernelHandle.kernel).equals(kernelId)).filter(k -> k.state == KernelState.STARTING || k.state == KernelState.READY || k.state == KernelState.SENTENCED).findFirst();
        if (optKernel.isEmpty()) {
            return false;
        }
        KernelHandle kernel = optKernel.get();
        for (Request request : kernel.requests) {
            request.resultFuture.completeExceptionally(new InterruptedException("Kernel force stopped"));
        }
        kernel.requests.clear();
        this.logger.info((Object)("[" + kernel.kernelSpec.kernelDescHash + "] Force stopping kernel " + this.controller.getKernelId(kernel.kernel)));
        kernel.state = KernelState.DYING;
        kernel.deathReason = reason;
        this.killKernelSafely(kernel);
        return true;
    }

    public Optional<SmartLogTail> getKernelLogs(String id) {
        ArrayList<KernelHandle> allKernels = new ArrayList<KernelHandle>(this.kernels.values());
        allKernels.addAll(this.graveyard);
        return allKernels.stream().filter(kernelHandle -> this.controller.getKernelId(kernelHandle.kernel).equals(id)).map(handle -> this.controller.getKernelLog(handle.kernel)).filter(Objects::nonNull).findFirst();
    }

    public Optional<String> getKernelIdFiltered(Predicate<KernelDescType> kernelDescPredicate) {
        ArrayList<KernelHandle> allKernels = new ArrayList<KernelHandle>(this.kernels.values());
        allKernels.addAll(this.graveyard);
        return allKernels.stream().filter(kernelHandle -> kernelDescPredicate.test(kernelHandle.kernelSpec.kernelDesc)).map(handle -> this.controller.getKernelId(handle.kernel)).filter(Objects::nonNull).findFirst();
    }

    public static int getGraveyardTimeout() {
        return DKUApp.getParams().getIntParam("dku.kernelpool.graveyardTimeoutInS", Integer.valueOf(7200));
    }

    public static int getGraveyardMaxSize() {
        return DKUApp.getParams().getIntParam("dku.kernelpool.graveyardSizeLimit", Integer.valueOf(100));
    }

    public synchronized <ResponseType> CompletableFuture<ResponseType> handle(Run<ResponseType, KernelType> payload, KernelDescType kernelDesc, String kernelDescHash, KernelGroupType kernelGroup, String kernelGroupHash, Object requestPayload) {
        try {
            if (this.closed) {
                throw new RuntimeException("KernelPool is already closed");
            }
            Request r = new Request();
            r.id = "R" + this.requestCounter++;
            r.run = payload;
            r.kernelSpec = new KernelSpec<KernelGroupType, KernelDescType>(kernelDesc, kernelDescHash, kernelGroup, kernelGroupHash);
            r.arrivedAtTime = System.nanoTime();
            r.requestPayload = requestPayload;
            r.state = RequestState.QUEUED;
            r.resultFuture = new CompletableFuture();
            r.resultFuture.whenCompleteAsync((response, throwable) -> {
                KernelPool kernelPool = this;
                synchronized (kernelPool) {
                    if (throwable != null && r.kernelHandle != null && r.kernelHandle.state == KernelState.STARTING) {
                        this.handleResponse(r, null, (Throwable)throwable);
                    }
                }
            }, (Executor)this.requestCompletionHandlerThreadPool);
            this.logger.debug((Object)("[" + kernelDescHash + "] Enqueuing request " + r.id + ": " + JSON.sampleJson((Object)requestPayload, (int)120)));
            this.requests.put((Object)kernelDescHash, r);
            this.notifyAll();
            return r.resultFuture;
        }
        catch (Throwable e) {
            this.logger.error((Object)("[" + kernelDescHash + "] Error occurred while handling request"), e);
            return CompletableFuture.failedFuture(e);
        }
    }

    public synchronized <ResponseType> CompletableFuture<ResponseType> handle(Run<ResponseType, KernelType> payload, KernelDescType kernelDesc, String kernelDescHash, Object requestPayload) {
        return this.handle(payload, kernelDesc, kernelDescHash, kernelDesc, kernelDescHash, requestPayload);
    }

    private synchronized <ResponseType> void handleResponse(Request<ResponseType> request, ResponseType response, Throwable throwable) {
        KernelHandle kernelHandle;
        String status;
        if (request.kernelHandle != null) {
            request.kernelHandle.requests.remove(request);
        }
        if (request.state == RequestState.COMPLETED) {
            return;
        }
        request.state = RequestState.COMPLETED;
        request.completedAtTime = System.nanoTime();
        String string = throwable instanceof CancellationException ? "cancelled" : (status = throwable == null ? "successful" : "failed");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("[" + request.kernelSpec.kernelDescHash + "] Handling response for request " + request.id + " (" + status + "): " + JSON.sampleJson(response, (int)120)));
        }
        if ((kernelHandle = request.kernelHandle) != null) {
            switch (status) {
                case "cancelled": {
                    ++kernelHandle.nbCancelledRequests;
                    break;
                }
                case "failed": {
                    ++kernelHandle.nbFailedRequests;
                    break;
                }
                case "successful": {
                    ++kernelHandle.nbSuccessfulRequests;
                }
            }
        }
        if (kernelHandle != null && throwable != null && kernelHandle.state == KernelState.READY && this.controller.killKernelOnRequestFailure()) {
            this.logger.info((Object)("[" + request.kernelSpec.kernelDescHash + "] Killing kernel " + this.controller.getKernelId(kernelHandle.kernel) + " as request " + request.id + " is in status " + status));
            kernelHandle.deathReason = DeathReason.FAIL_RUNNING;
            kernelHandle.sentence();
            new ArrayList(kernelHandle.requests).forEach((Consumer<Request<?>>)((Consumer<Request>)r -> this.handleResponse((Request)r, null, new CancellationException("Kernel is being stopped following another request failure"))));
        }
        this.notifyAll();
        CompletableFuture.runAsync(() -> {
            if (throwable == null) {
                request.resultFuture.complete(response);
            } else {
                request.resultFuture.completeExceptionally(throwable);
            }
        }, this.requestCompletionHandlerThreadPool);
    }

    private synchronized void scaleDown(KernelHandle k, DeathReason reason) {
        this.logger.info((Object)("[" + k.kernelSpec.kernelDescHash + "] Scale down kernel " + this.controller.getKernelId(k.kernel)));
        k.deathReason = reason;
        k.sentence();
    }

    private void scaleDown(String hash, long limit, DeathReason deathReason, Map<String, ReservedCapacityRequest<KernelGroupType, KernelDescType>> kernelsWithMinCount) {
        AtomicBoolean empty = new AtomicBoolean(true);
        int i = 0;
        while ((long)i < limit) {
            this.streamLive(this.kernels.get((Object)hash)).min(this.scalingDownComparator(kernelsWithMinCount)).ifPresent(k -> {
                empty.set(false);
                this.scaleDown((KernelHandle)k, deathReason);
            });
            ++i;
        }
        if (empty.get()) {
            this.logger.debugV("[%s] No eligible kernel to scale down", new Object[]{hash});
        }
    }

    private void scaleDown(long limit, DeathReason deathReason, Map<String, ReservedCapacityRequest<KernelGroupType, KernelDescType>> kernelsWithMinCount) {
        AtomicBoolean empty = new AtomicBoolean(true);
        int i = 0;
        while ((long)i < limit) {
            this.streamLive(this.kernels.values()).min(this.scalingDownComparator(kernelsWithMinCount)).ifPresent(k -> {
                empty.set(false);
                this.scaleDown((KernelHandle)k, deathReason);
            });
            ++i;
        }
        if (empty.get()) {
            this.logger.debugV("No eligible kernel to scale down", new Object[0]);
        }
    }

    private void tryScaleUp(KernelSpec<KernelGroupType, KernelDescType> kernelSpec, KernelPoolCache<KernelGroupType, Integer> kernelGroupToMaxKernelCount, int globalMaxKernelCount, KernelPoolCache<KernelDescType, Boolean> kernelDescIsOutdated) {
        CompletableFuture<Object> kernelStartingFuture;
        Instant lastStartFailInstant;
        int retryDelay = DKUApp.getParams().getIntParam("dku.kernelpool.retryStartSeconds", Integer.valueOf(30));
        if (this.lastStartupFailure.containsKey(kernelSpec.kernelDescHash) && (lastStartFailInstant = this.lastStartupFailure.get(kernelSpec.kernelDescHash)).plusSeconds(retryDelay).isAfter(Instant.now())) {
            this.debugDedup("[" + kernelSpec.kernelDescHash + "] Skipping scale up: this kernel has recently failed to start. We'll retry " + retryDelay + " seconds later.");
            return;
        }
        if (this.kernels.size() >= globalMaxKernelCount) {
            this.debugDedup("[" + kernelSpec.kernelDescHash + "] Skipping scale up: global kernel count limit reached.");
            return;
        }
        if (Boolean.TRUE.equals(kernelDescIsOutdated.get(kernelSpec.kernelDesc, kernelSpec.kernelDescHash))) {
            this.debugDedup("[" + kernelSpec.kernelDescHash + "] Skipping scale up: kernel desc is outdated.");
            return;
        }
        Integer maxKernelsForHash = kernelGroupToMaxKernelCount.get(kernelSpec.kernelGroup, kernelSpec.kernelGroupHash);
        int totalGroupSize = this.groupHashToDescHash.get((Object)kernelSpec.kernelGroupHash).stream().mapToInt(descHash -> this.kernels.get(descHash).size()).sum();
        if (maxKernelsForHash != null && totalGroupSize >= maxKernelsForHash) {
            this.debugDedup("[" + kernelSpec.kernelDescHash + "] Skipping scale up: max number of kernels reached for this group.");
            return;
        }
        this.logger.debug((Object)("[" + kernelSpec.kernelDescHash + "] Kernel candidate able to scale up"));
        KernelHandle kernelHandle = new KernelHandle();
        try {
            kernelHandle.kernel = this.controller.createKernel(kernelSpec.kernelDesc);
            if (kernelHandle.kernel == null) {
                throw new NullPointerException("Expected createKernel() to return a CompletableFuture but got null");
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("[" + kernelSpec.kernelDescHash + "] Failed to create kernel, aborting queued request(s)"), e);
            this.abortQueuedRequestsIfNeeded(kernelSpec.kernelDescHash, e);
            return;
        }
        kernelHandle.kernelSpec = kernelSpec;
        kernelHandle.state = KernelState.STARTING;
        kernelHandle.maxRequests = this.controller.getHardMaxParallelRequests(kernelSpec.kernelDesc);
        this.logger.info((Object)("[" + kernelSpec.kernelDescHash + "] Start new kernel " + this.controller.getKernelId(kernelHandle.kernel)));
        try {
            kernelStartingFuture = this.controller.startKernel(kernelHandle.kernel, kernelSpec.kernelDesc);
            if (kernelStartingFuture == null) {
                throw new NullPointerException("Expected startKernel() to return a CompletableFuture but got null");
            }
        }
        catch (Throwable e) {
            kernelStartingFuture = CompletableFuture.failedFuture(e);
        }
        kernelHandle.startingFuture = kernelStartingFuture;
        kernelHandle.startingFuture.whenCompleteAsync((r, ex) -> {
            if (kernelHandle.state == KernelState.DYING) {
                this.logger.info((Object)("[" + kernelSpec.kernelDescHash + "] Kernel was possibly killed while starting, re-killing it just in case"));
                this.killKernelSafely(kernelHandle);
            }
        }, (Executor)this.maintenanceThreadPool);
        kernelHandle.startingAtTime = Instant.now();
        this.kernels.put((Object)kernelSpec.kernelDescHash, (Object)kernelHandle);
        this.groupHashToDescHash.put((Object)kernelSpec.kernelGroupHash, (Object)kernelSpec.kernelDescHash);
    }

    private void debugDedup(String message) {
        try {
            this.logCache.get((Object)message, () -> {
                this.logger.debug((Object)message);
                return true;
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void errorDedup(String message, Throwable e) {
        try {
            this.logCache.get((Object)(message + e.getMessage() + e.getClass().getName()), () -> {
                this.logger.error((Object)message, e);
                return true;
            });
        }
        catch (ExecutionException x) {
            throw new RuntimeException(x);
        }
    }

    public synchronized void checkInvariants() {
        for (Map.Entry entry : this.groupHashToDescHash.entries()) {
            String kernelDescHash = (String)entry.getValue();
            assert (!this.kernels.get((Object)kernelDescHash).isEmpty());
        }
        for (Request request : this.requests.values()) {
            assert ((request.state == RequestState.QUEUED && request.kernelHandle == null) ^ (request.state == RequestState.DISPATCHED && request.kernelHandle != null && this.kernels.values().contains(request.kernelHandle) && request.kernelHandle.requests.contains(request)) ^ (request.state == RequestState.COMPLETED && (request.kernelHandle == null || !request.kernelHandle.requests.contains(request))));
            assert (request.kernelSpec != null);
            assert (request.id != null);
            assert (request.state != null);
            assert (request.resultFuture != null);
            assert (request.run != null);
        }
        ArrayList<KernelHandle> allKernels = new ArrayList<KernelHandle>();
        allKernels.addAll(this.kernels.values());
        allKernels.addAll(this.graveyard);
        for (KernelHandle kernelHandle : allKernels) {
            assert (kernelHandle.state != null);
            assert (kernelHandle.startingAtTime != null);
            assert (kernelHandle.kernelSpec != null);
            assert (kernelHandle.kernelSpec.kernelDescHash != null);
            assert (kernelHandle.kernelSpec.kernelDesc != null);
            assert (kernelHandle.kernelSpec.kernelGroup != null);
            assert (kernelHandle.kernel != null);
            assert (kernelHandle.startingFuture != null);
            assert (kernelHandle.state != KernelState.DYING && kernelHandle.state != KernelState.STARTING || kernelHandle.requests.isEmpty());
            assert (kernelHandle.deathReason != null ^ (kernelHandle.state == KernelState.READY || kernelHandle.state == KernelState.STARTING));
            assert (kernelHandle.state != KernelState.DEAD ^ kernelHandle.diedAtTime != null);
            assert (kernelHandle.state == KernelState.DEAD || this.groupHashToDescHash.containsKey((Object)kernelHandle.kernelSpec.kernelGroupHash));
            assert (kernelHandle.state != KernelState.READY || kernelHandle.readyAtTime != null);
            assert (kernelHandle.state != KernelState.SENTENCED || kernelHandle.sentencedAtTime != null);
            for (Request request : kernelHandle.requests) {
                assert (this.requests.values().contains(request));
                assert (request.kernelHandle == kernelHandle);
                assert (request.state == RequestState.DISPATCHED);
            }
        }
    }

    public static interface KernelController<KernelType, KernelGroupType, KernelDescType extends KernelGroupType> {
        @Nonnull
        public KernelType createKernel(KernelDescType var1);

        @Nonnull
        public CompletableFuture<Void> startKernel(KernelType var1, KernelDescType var2);

        public int getGlobalMaxKernelCount();

        public int getAutoscaleTimeWindowSeconds(KernelDescType var1);

        public int getHardMaxParallelRequests(KernelDescType var1);

        public int getSoftMaxParallelRequests(KernelDescType var1);

        @Nonnull
        public CompletableFuture<Void> killKernel(KernelType var1);

        public boolean isAlive(KernelType var1);

        public String getKernelId(KernelType var1);

        @Nullable
        default public Long getQueuedRequestTimeoutInNs() {
            return null;
        }

        @Nonnull
        default public Collection<ReservedCapacityRequest<KernelGroupType, KernelDescType>> getKernelsWithMinCount() {
            return Collections.emptyList();
        }

        @Nullable
        default public Integer getMaxKernelCount(KernelGroupType kernelGroup) {
            return null;
        }

        default public boolean isOutdated(KernelDescType kernelDesc) {
            return false;
        }

        @Nullable
        default public Object dumpKernelDescForDebug(KernelDescType kernelDesc) {
            return kernelDesc;
        }

        default public boolean killKernelOnRequestFailure() {
            return false;
        }

        @Nullable
        default public SmartLogTail getKernelLog(KernelType kernel) {
            return null;
        }

        @Nullable
        default public String getPodName(KernelType kernel) {
            return null;
        }

        @Nullable
        default public String getModelId(KernelType kernel) {
            return null;
        }
    }

    class KernelHandle {
        CompletableFuture<Void> startingFuture;
        KernelType kernel;
        KernelSpec<KernelGroupType, KernelDescType> kernelSpec;
        KernelState state;
        int maxRequests;
        LinkedHashSet<Request<?>> requests = new LinkedHashSet();
        Instant startingAtTime = null;
        Instant readyAtTime = null;
        Instant sentencedAtTime = null;
        Instant diedAtTime = null;
        DeathReason deathReason = null;
        String deathError = null;
        int nbSuccessfulRequests;
        int nbCancelledRequests;
        int nbFailedRequests;

        KernelHandle() {
        }

        void sentence() {
            this.state = KernelState.SENTENCED;
            this.sentencedAtTime = Instant.now();
        }
    }

    public static class KernelSpec<KernelGroupType, KernelDescType extends KernelGroupType> {
        @Nonnull
        final KernelDescType kernelDesc;
        @Nonnull
        final String kernelDescHash;
        @Nonnull
        final KernelGroupType kernelGroup;
        @Nonnull
        final String kernelGroupHash;

        public KernelSpec(@Nonnull KernelDescType kernelDesc, @Nonnull String kernelDescHash, @Nonnull KernelGroupType kernelGroup, @Nonnull String kernelGroupHash) {
            this.kernelDesc = kernelDesc;
            this.kernelDescHash = kernelDescHash;
            this.kernelGroup = kernelGroup;
            this.kernelGroupHash = kernelGroupHash;
        }
    }

    public static class DescStateDump {
        public String kernelDescHash;
        public long nbActiveRequests;
        public long nbPendingRequests;
        public long nbActiveKernels;
        public long nbStartingKernels;
        public List<PoolDump.KernelDump> kernels = new ArrayList<PoolDump.KernelDump>();
        public List<PoolDump.RequestDump> requests = new ArrayList<PoolDump.RequestDump>();

        public DescStateDump(String kernelDescHash) {
            this.kernelDescHash = kernelDescHash;
        }
    }

    public static enum KernelState {
        STARTING,
        READY,
        SENTENCED,
        DYING,
        DEAD;

    }

    public static class PoolDump
    extends ArrayList<DescStateDump> {
        public PoolDump(Collection<DescStateDump> descStates) {
            this.addAll(descStates);
        }

        public DescStateDump get(String descHash) {
            return this.stream().filter(dsd -> dsd.kernelDescHash.equals(descHash)).findFirst().orElse(new DescStateDump(descHash));
        }

        public Stream<KernelDump> streamKernels() {
            return this.stream().flatMap(dsd -> dsd.kernels.stream());
        }

        public Stream<RequestDump> streamRequests() {
            return this.stream().flatMap(dsd -> dsd.requests.stream());
        }

        public static class RequestDump {
            public String id;
            public RequestState state;
            public long pendingTimeMs;
            public Long processingTimeMs;
            public Long completedSinceTimeMs;
            public long totalTimeMs;
            public String kernelDescHash;
            public String kernelId;
            public Object requestKernelDesc;
            public Object requestPayload;
        }

        public static class KernelDump {
            public String id;
            public String podName;
            public String modelId;
            public String kernelDescHash;
            public KernelState state;
            public Long startupTimeMs;
            public Long runningTimeMs;
            public Long sentencedTimeMs;
            public Long deadSinceTimeMs;
            public String startingAtTime;
            public String readyAtTime;
            public String sentencedAtTime;
            public String diedAtTime;
            public DeathReason deathReason;
            public Object kernelDesc;
            public long nbActiveRequests;
            public int nbCancelledRequests;
            public int nbFailedRequests;
            public int nbSuccessfulRequests;
            public String deathError;
        }
    }

    public static enum DeathReason {
        STRATEGY,
        PER_KERNEL_MAX_LIMIT,
        GLOBAL_MAX_LIMIT,
        ROOM_FOR_RESERVED_CAPACITY,
        ROOM_FOR_REQUEST,
        OUTDATED,
        USER_REQUEST,
        FAIL_START,
        FAIL_RUNNING,
        DEBUG,
        UNKNOWN;

    }

    class Request<ResponseType> {
        CompletableFuture<ResponseType> resultFuture;
        Run<ResponseType, KernelType> run;
        KernelSpec<KernelGroupType, KernelDescType> kernelSpec;
        RequestState state;
        KernelHandle kernelHandle;
        Object requestPayload;
        long arrivedAtTime;
        long dispatchedAtTime;
        long completedAtTime;
        String id;

        Request() {
        }
    }

    public static enum RequestState {
        QUEUED,
        DISPATCHED,
        COMPLETED;

    }

    static class KernelPoolCache<K, V> {
        private final Map<String, V> hashToValue = new HashMap<String, V>();
        BiFunction<K, String, V> producer;

        KernelPoolCache(BiFunction<K, String, V> producer) {
            this.producer = producer;
        }

        public V get(K key, String keyHash) {
            if (!this.hashToValue.containsKey(keyHash)) {
                this.hashToValue.put(keyHash, this.producer.apply(key, keyHash));
            }
            return this.hashToValue.get(keyHash);
        }
    }

    private record ScalingResult(Set<String> up, Set<String> down) {
    }

    public static interface Run<ResponseType, KernelType> {
        @Nonnull
        public CompletableFuture<ResponseType> execute(KernelType var1);
    }

    public static class ReservedCapacityRequest<KernelGroupType, KernelDescType extends KernelGroupType>
    extends KernelSpec<KernelGroupType, KernelDescType> {
        int minKernelCount;

        public ReservedCapacityRequest(int minKernelCount, @Nonnull KernelDescType kernelDesc, @Nonnull String kernelDescHash, @Nonnull KernelGroupType kernelGroup, @Nonnull String kernelGroupHash) {
            super(kernelDesc, kernelDescHash, kernelGroup, kernelGroupHash);
            this.minKernelCount = minKernelCount;
        }

        public ReservedCapacityRequest(int minKernelCount, KernelSpec<KernelGroupType, KernelDescType> kernelSpec) {
            this(minKernelCount, kernelSpec.kernelDesc, kernelSpec.kernelDescHash, kernelSpec.kernelGroup, kernelSpec.kernelGroupHash);
        }
    }

    public static class KernelSnapshot {
        KernelState state;
        int maxRequests;
        int nbProcessingRequests;

        public KernelSnapshot(KernelState state, int maxRequests, int nbProcessingRequests) {
            this.state = state;
            this.maxRequests = maxRequests;
            this.nbProcessingRequests = nbProcessingRequests;
        }
    }

    public static class RequestSnapshot {
        RequestState state;
        long arrivedAtTime;
        long completedAtTime;

        public RequestSnapshot(RequestState state, long arrivedAtTime, long completedAtTime) {
            this.state = state;
            this.arrivedAtTime = arrivedAtTime;
            this.completedAtTime = completedAtTime;
        }
    }
}

