/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.custom;

import com.dataiku.dip.security.auth.CustomAuthSettings;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSupplier;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.dip.security.custom.CustomUserSupplier;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.StringUtils;
import java.util.Set;

public class CustomUserSupplierDelegator
implements UserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    protected CustomAuthSettings customAuthSettings;
    private CustomUserSupplier customUserSupplier;

    @Override
    public UserSupplierSettings getUserSupplierSettings() {
        return this.customAuthSettings;
    }

    @Override
    public UserAttributes getUserAttributes(UserIdentity userIdentity) throws ServerAuthenticationFailure, UserNotFoundException {
        try {
            return this.getCustomUserSupplier().getUserAttributes(userIdentity);
        }
        catch (ServerAuthenticationFailure | UserNotFoundException e) {
            logger.info((Object)("Custom user supplier could not get user attributes for identity '" + String.valueOf(userIdentity) + "'"), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new ServerAuthenticationFailure("An expected error happened in the custom user supplier '" + this.customAuthSettings.customUserSupplierClassName + "'", e);
        }
    }

    @Override
    public Set<UserAttributes> fetchUsers(UserQueryFilter filter) throws ServerAuthenticationFailure {
        return this.getCustomUserSupplier().fetchUsers(filter);
    }

    @Override
    public Set<String> fetchGroups() throws ServerAuthenticationFailure {
        return this.getCustomUserSupplier().fetchGroups();
    }

    @Override
    public String getDefaultProfile() {
        return this.customAuthSettings.defaultUserProfile;
    }

    @Override
    public boolean canSyncOnDemand() {
        try {
            return this.getCustomUserSupplier().canSyncOnDemand();
        }
        catch (ServerAuthenticationFailure e) {
            return false;
        }
    }

    @Override
    public boolean canFetchUsers() {
        try {
            return this.getCustomUserSupplier().canFetchUsers();
        }
        catch (ServerAuthenticationFailure e) {
            return false;
        }
    }

    @Override
    public boolean canFetchGroups() {
        try {
            return this.getCustomUserSupplier().canFetchGroups();
        }
        catch (ServerAuthenticationFailure e) {
            return false;
        }
    }

    private CustomUserSupplier getCustomUserSupplier() throws ServerAuthenticationFailure {
        if (StringUtils.nullIfBlank((String)this.customAuthSettings.customUserSupplierClassName) != null) {
            if (this.customUserSupplier == null || !this.customAuthSettings.customUserSupplierClassName.equals(this.customUserSupplier.getClass().getName())) {
                try {
                    Class<?> customUserAuthenticatorClass = CustomUserSupplier.class.getClassLoader().loadClass(this.customAuthSettings.customUserSupplierClassName);
                    if (SpringUtils.getInstance().hasBeanNames(customUserAuthenticatorClass)) {
                        logger.info((Object)("Found a spring bean matching the class: " + this.customAuthSettings.customUserSupplierClassName));
                        this.customUserSupplier = (CustomUserSupplier)SpringUtils.getBean(customUserAuthenticatorClass);
                    } else {
                        logger.info((Object)("Loading CustomUserSupplier class: " + this.customAuthSettings.customUserSupplierClassName));
                        this.customUserSupplier = (CustomUserSupplier)customUserAuthenticatorClass.newInstance();
                        SpringUtils.getInstance().registerSingletonBeanIfNotPresent(this.customUserSupplier.getClass(), this.customUserSupplier);
                        logger.info((Object)("CustomUserSupplier found in classpath: " + this.customUserSupplier.getClass().getName()));
                    }
                }
                catch (ClassCastException e) {
                    logger.errorV("Class '%s' doesn't implement interface '%s'.", new Object[]{this.customAuthSettings.customUserSupplierClassName, CustomUserSupplier.class.getName()});
                    throw new ServerAuthenticationFailure("Class '" + this.customAuthSettings.customUserSupplierClassName + "' doesn't implement interface '" + CustomUserSupplier.class.getName() + "'.", e);
                }
                catch (ClassNotFoundException e) {
                    logger.errorV("No CustomUserSupplier '%s' found in classpath.", new Object[]{this.customAuthSettings.customUserSupplierClassName});
                    throw new ServerAuthenticationFailure("No CustomUserSupplier '" + this.customAuthSettings.customUserSupplierClassName + "' found in classpath.", e);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    logger.errorV((Throwable)e, "Could not load CustomUserSupplier '%s' found in classpath.", new Object[]{this.customAuthSettings.customUserSupplierClassName});
                    throw new ServerAuthenticationFailure("No CustomUserSupplier '" + this.customAuthSettings.customUserSupplierClassName + "' found in classpath.", e);
                }
            }
            return this.customUserSupplier;
        }
        logger.info((Object)"No CustomUserSupplier defined");
        throw new ServerAuthenticationFailure("The CustomUserSupplier class '" + this.customAuthSettings.customUserSupplierClassName + "' could not be loaded.");
    }
}

