/*
 * Decompiled with CFR 0.152.
 */
package com.lastpass.saml;

import com.lastpass.saml.SAMLException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IdPConfig {
    private String entityId;
    private String loginUrl;
    private ArrayList<Certificate> certs = new ArrayList();

    public IdPConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdPConfig(File metadataFile) throws SAMLException {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(metadataFile);
        }
        catch (IOException e) {
            throw new SAMLException(e);
        }
        try {
            this.init(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IdPConfig(InputStream inputStream) throws SAMLException {
        this.init(inputStream);
    }

    private void init(InputStream inputStream) throws SAMLException {
        EntityDescriptor edesc;
        BasicParserPool parsers = new BasicParserPool();
        try {
            parsers.setNamespaceAware(true);
            parsers.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException(e);
        }
        try {
            Document doc = parsers.parse(inputStream);
            Element root = doc.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            edesc = (EntityDescriptor)unmarshallerFactory.getUnmarshaller(root).unmarshall(root);
        }
        catch (XMLParserException | UnmarshallingException e) {
            throw new SAMLException(e);
        }
        IDPSSODescriptor idpDesc = edesc.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpDesc == null) {
            throw new SAMLException("No IDP SSO descriptor found");
        }
        String loginUrl = null;
        for (SingleSignOnService svc : idpDesc.getSingleSignOnServices()) {
            if (!svc.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) continue;
            loginUrl = svc.getLocation();
            break;
        }
        if (loginUrl == null) {
            throw new SAMLException("No acceptable Single Sign-on Service found");
        }
        for (KeyDescriptor kdesc : idpDesc.getKeyDescriptors()) {
            KeyInfo ki;
            if (kdesc.getUse() != UsageType.SIGNING || (ki = kdesc.getKeyInfo()) == null) continue;
            for (X509Data x509data : ki.getX509Datas()) {
                for (X509Certificate xcert : x509data.getX509Certificates()) {
                    try {
                        this.addCert(this.certFromString(xcert.getValue()));
                    }
                    catch (CertificateException certificateException) {}
                }
            }
        }
        if (this.certs.isEmpty()) {
            throw new SAMLException("No valid signing cert found in IdP SSO descriptor");
        }
        this.setEntityId(edesc.getEntityID());
        this.setLoginUrl(loginUrl);
    }

    private Certificate certFromString(String b64data) throws CertificateException {
        byte[] decoded = Base64.decodeBase64((String)b64data);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(new ByteArrayInputStream(decoded));
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void addCert(Certificate cert) {
        this.certs.add(cert);
    }

    public List<Certificate> getCerts() {
        return this.certs;
    }
}

