/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.dip.util.SecureKeyGenerator;
import com.dataiku.fm.cli.ApiKeyFileWriter;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;

public class CreateNamedPersonalKeyCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "USER_ID", "KEY_NAME", "[OUTPUT_FILENAME]"};

    @Override
    public String getUsageCommandName() {
        return "create-named-personal-api-key";
    }

    @Override
    public String description() {
        return "Create a named personal API key for a user.\nIf OUTPUT_FILENAME is provided, the details of the API key are written as JSON into this file.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String login = args.get("USER_ID");
        String keyName = args.get("KEY_NAME");
        String outputFileName = args.get("OUTPUT_FILENAME");
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            if (this.isKeyNameAlreadyUsed(t, keyName)) {
                throw new IllegalStateException(String.format("Key name '%s' already exists. Key names must be unique", login));
            }
            FMUser user = Optional.ofNullable(dbService.getSingleResult(FMUser.class, "SELECT u from fmuser u where u.tenant.id=?1 AND u.emailAddress = ?2", tenantId, login)).orElseThrow(() -> new IllegalStateException(String.format("Unknown user '%s' on tenant.", login)));
            String secret = SecureKeyGenerator.generate((int)32);
            FMPersonalAPIKey pak = new FMPersonalAPIKey();
            pak.setUser(user);
            pak.setKeyId(keyName);
            pak.setSecretHash(PasswordUtils.encryptPassword((String)secret));
            pak.setCreationDate(new Date());
            t.getThreadEM().persist((Object)pak);
            t.commit();
            System.out.println("Key name: " + keyName);
            System.out.println("Key secret: " + secret);
            boolean success = outputFileName == null || ApiKeyFileWriter.writeOutputFile(outputFileName, keyName, secret);
            int n = success ? 0 : 1;
            return n;
        }
    }

    private boolean isKeyNameAlreadyUsed(DatabaseAccessService.ReadWriteTransaction transaction, String keyName) {
        return transaction.getThreadEM().find(FMPersonalAPIKey.class, (Object)keyName) != null;
    }
}

