/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class RegisterAWSVPC
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "AWS_VPC_ID", "AWS_SUBNET_ID", "AWS_AZ", "PCNX_ID"};

    @Override
    public String getUsageCommandName() {
        return "register-aws-vpc";
    }

    @Override
    public String description() {
        return "[DEV COMMAND] Manually register an already-existing and already-peered AWS VPC.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String vpcId = args.get("AWS_VPC_ID");
        String subnetId = args.get("AWS_SUBNET_ID");
        String secondSubnetId = args.get("AWS_SECOND_SUBNET_ID");
        String az = args.get("AWS_AZ");
        String pcnx = args.get("PCNX_ID");
        try (DatabaseAccessService.ReadWriteTransaction t = ((DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class)).rwTransaction();){
            Tenant tenant = (Tenant)t.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            VirtualNetwork vn = new VirtualNetwork();
            vn.setLabel("Virtual network " + vpcId);
            vn.setId("vn-" + SecretKeyGenerator.generate((int)12));
            vn.setTenant(tenant);
            vn.setMode(VirtualNetwork.VirtualNetworkMode.EXISTING_MONOTENANT);
            vn.setAwsVpcId(vpcId);
            vn.setAwsSubnetId(subnetId);
            vn.setAwsSecondSubnetId(secondSubnetId);
            vn.setAwsAvailabilityZone(az);
            vn.setAwsPeeringConnectionId(pcnx);
            t.getThreadEM().persist((Object)vn);
            t.commit();
            System.out.println("New virtual network: " + vn.getId());
            int n = 0;
            return n;
        }
    }
}

