/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cli.FMInternalCLICommand;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.Map;
import org.apache.commons.cli.CommandLine;

public class SetUserPasswordCommand
extends FMInternalCLICommand {
    private static final String[] ARG_NAMES = new String[]{"TENANT_ID", "USER_ID", "PASSWORD"};

    @Override
    public String getUsageCommandName() {
        return "set-user-password";
    }

    @Override
    public String description() {
        return "Sets password for a user.";
    }

    @Override
    public String[] getUsageCommandArgs() {
        return ARG_NAMES;
    }

    @Override
    public int executeCommand(CommandLine commandLine) {
        Map<String, String> args = this.parseCmdArgs(commandLine, ARG_NAMES);
        String tenantId = args.get("TENANT_ID");
        String emailAddress = args.get("USER_ID");
        String password = args.get("PASSWORD");
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        try (DatabaseAccessService.ReadWriteTransaction t = dbService.rwTransaction();){
            FMUser user = dbService.getSingleResult(FMUser.class, "SELECT u from fmuser u where u.tenant.id=?1 AND u.emailAddress=?2", tenantId, emailAddress);
            if (user == null) {
                throw new IllegalStateException(String.format("Unknown user '%s' on tenant.", emailAddress));
            }
            user.setSecurePassword(password);
            t.getThreadEM().persist((Object)user);
            t.commit();
            System.out.println("Password updated for user " + emailAddress);
            int n = 0;
            return n;
        }
    }
}

