/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.VirtualNetwork;
import java.util.Map;
import java.util.Optional;

public interface DNSservice {
    public Map<ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork var1, String var2, String var3, String var4, RecordType var5, Map<String, String> var6);

    public void removeDNSRecords(VirtualNetwork var1, String var2, RecordType var3, boolean var4);

    public Map<ZoneType, String> getFQDNs(VirtualNetwork var1, String var2);

    public String getPublicDNSZoneDomain(VirtualNetwork var1);

    default public Optional<String> computeFQDNs(VirtualNetwork virtualNetwork, String subdomain, boolean isPublicZoneType) {
        Map<ZoneType, String> domains = this.getFQDNs(virtualNetwork, subdomain);
        return Optional.ofNullable(domains.get((Object)(isPublicZoneType ? ZoneType.PUBLIC : ZoneType.PRIVATE)));
    }

    public String getPrivateDNSZoneDomain(VirtualNetwork var1);

    public void checkIfZoneExist(VirtualNetwork var1, String var2);

    public static enum ZoneType {
        PRIVATE,
        PUBLIC;

    }

    public static enum RecordType {
        A,
        CNAME;

    }
}

