/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.SdkBytes;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.DecryptRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.DecryptResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.EncryptRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.EncryptResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.InvalidCiphertextException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.model.NotFoundException;
import com.dataiku.fm.cloud.CloudCryptoServiceInterface;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AWSCloudCryptoService
implements CloudCryptoServiceInterface {
    @Autowired
    private DatabaseAccessService dbService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.crypto");

    @Override
    public boolean isAbleToEncryptUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        return this.isAbleToEncrypt(fmTenant);
    }

    @Override
    public void checkEncryptionUsingTenantMasterKey() {
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", "main");
        this.checkEncryption(fmTenant);
    }

    @Override
    public boolean isAbleToEncrypt(Tenant tenant) {
        return StringUtils.isNotBlank((String)tenant.getAwsCMKId());
    }

    @Override
    public void checkEncryption(Tenant tenant) {
        String test = "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7";
        String encryptTest = this.encrypt(tenant, "\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7");
        String decryptTest = this.decrypt(tenant, encryptTest);
        if (!"\"This is a test\" @\u00e7\u00a3\u00b0\u00e9\u00e0\u00a7".equals(decryptTest)) {
            throw new IllegalStateException("Your key does not encrypt/decrypt correctly");
        }
    }

    @Override
    public String encrypt(Tenant tenant, String cleartext) {
        if (StringUtils.isBlank((String)tenant.getAwsCMKId())) {
            throw new IllegalArgumentException("Can't encrypt, master key in cloud setup is not configured");
        }
        if (tenant.getAwsCMKId() == null) {
            throw new IllegalArgumentException("Can't encrypt, CMK id is not configured");
        }
        try {
            AWSClientService clientService = (AWSClientService)SpringUtils.getBean(AWSClientService.class);
            EncryptResponse ers = clientService.getKMSClient(AWSUtils.buildAWSAuthenticationInfo(tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()), this)).encrypt((EncryptRequest)EncryptRequest.builder().keyId(tenant.getAwsCMKId()).plaintext(SdkBytes.fromByteArray((byte[])cleartext.getBytes(StandardCharsets.UTF_8))).build());
            return Base64.encodeBase64String((byte[])ers.ciphertextBlob().asByteArray());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Can't encrypt, the 'AWS CMK Id'='" + tenant.getAwsCMKId() + "' in cloud setup is not a valid Key ID", e);
        }
    }

    @Override
    public String decrypt(Tenant tenant, String possiblyEncryptedText) {
        if (StringUtils.isBlank((String)tenant.getAwsCMKId())) {
            throw new IllegalArgumentException("Can't decrypt, master key in cloud setup is not configured");
        }
        DecryptRequest.Builder drq = DecryptRequest.builder();
        try {
            drq.ciphertextBlob(SdkBytes.fromByteArray((byte[])Base64.decodeBase64((String)possiblyEncryptedText)));
        }
        catch (Exception e) {
            logger.info((Object)"Could not deserialize value as cipher. Value may not be encrypted yet.");
            return possiblyEncryptedText;
        }
        try {
            AWSClientService clientService = (AWSClientService)SpringUtils.getBean(AWSClientService.class);
            DecryptResponse drs = clientService.getKMSClient(AWSUtils.buildAWSAuthenticationInfo(tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()), this)).decrypt((DecryptRequest)drq.build());
            return new String(drs.plaintext().asByteArray(), StandardCharsets.UTF_8);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Can't decrypt, AWS couldn't find the key that encrypted the secrets.", e);
        }
        catch (InvalidCiphertextException e) {
            logger.info((Object)"Invalid cipher text. Value may not be encrypted yet.");
            return possiblyEncryptedText;
        }
    }
}

