/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Address;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeAddressesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Instance;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.model.Reservation;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.Change;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ChangeAction;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ChangeBatch;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.RRType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ResourceRecord;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.aws.AWSClientService;
import com.dataiku.fm.cloud.aws.AWSUtils;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.utils.DnsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AWSDNSService
implements DNSservice {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.aws.dns");
    private final AWSClientService awsClientService;
    private final DatabaseAccessService dbService;
    private final CloudCryptoService cloudCryptoService;
    private final FMApp fmApp;

    @Autowired
    public AWSDNSService(AWSClientService awsClientService, DatabaseAccessService dbService, CloudCryptoService cryptoService, FMApp fmApp) {
        this.awsClientService = awsClientService;
        this.dbService = dbService;
        this.cloudCryptoService = cryptoService;
        this.fmApp = fmApp;
    }

    @Override
    public synchronized Map<DNSservice.ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork virtualNetwork, String recordName, String targetPublicIP, String targetPrivateIp, DNSservice.RecordType recordType, Map<String, String> tags) {
        HashMap<DNSservice.ZoneType, PhysicalDNSRecord> result = new HashMap<DNSservice.ZoneType, PhysicalDNSRecord>();
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, this.fmApp.getFMSettings()));
                if (targetPrivateIp != null && StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) {
                    logger.infoV("Update DNS record for private IP for record '%s'", new Object[]{recordName});
                    zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                    zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                    String privateDnsName = DnsUtils.relativeSafeDnsName(recordName, zoneName);
                    result.put(DNSservice.ZoneType.PRIVATE, this.addRoute53Record(r53Client, zoneId, privateDnsName, DNSservice.RecordType.A, DNSservice.ZoneType.PRIVATE, targetPrivateIp));
                }
                if (targetPublicIP == null || !StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) break;
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                String publicDnsName = DnsUtils.relativeSafeDnsName(recordName, zoneName);
                result.put(DNSservice.ZoneType.PUBLIC, this.addRoute53Record(r53Client, zoneId, publicDnsName, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC, targetPublicIP));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                FMSettings settings = this.fmApp.getFMSettings();
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork.getTenant().getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                String zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = DnsUtils.relativeSafeDnsName(recordName, subzone, zoneName);
                result.put(DNSservice.ZoneType.PUBLIC, this.addRoute53Record(r53Client, zoneId, publicDnsName, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC, targetPublicIP));
                break;
            }
        }
        return result;
    }

    @Override
    public synchronized void removeDNSRecords(VirtualNetwork virtualNetwork, String recordName, DNSservice.RecordType recordType, boolean computeDNSNameWithZone) {
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, FMApp.getFMSettingsUnsafe()));
                if (StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) {
                    logger.infoV("Delete DNS record for private IP for record '%s'", new Object[]{recordName});
                    zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                    zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                    String privateDnsName = computeDNSNameWithZone ? DnsUtils.relativeSafeDnsName(recordName, zoneName) : recordName;
                    this.deleteRoute53Record(r53Client, zoneId, privateDnsName, recordType);
                }
                if (!StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) break;
                logger.infoV("Delete DNS record for public IP for record '%s'", new Object[]{recordName});
                zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                String publicDnsName = computeDNSNameWithZone ? DnsUtils.relativeSafeDnsName(recordName, zoneName) : recordName;
                this.deleteRoute53Record(r53Client, zoneId, publicDnsName, recordType);
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Delete DNS record for public IP for record '%s'", new Object[]{recordName});
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork.getTenant().getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()), FMApp.getFMSettingsUnsafe().awsSettings.regionId, this.cloudCryptoService));
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                String zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = computeDNSNameWithZone ? DnsUtils.relativeSafeDnsName(recordName, subzone, zoneName) : recordName;
                this.deleteRoute53Record(r53Client, zoneId, publicDnsName, recordType);
                break;
            }
        }
    }

    @Override
    public Map<DNSservice.ZoneType, String> getFQDNs(VirtualNetwork virtualNetwork, String recordName) {
        HashMap<DNSservice.ZoneType, String> hostnames = new HashMap<DNSservice.ZoneType, String>();
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                if (StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) {
                    zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                    zoneName = this.getZoneNameFromZoneId(virtualNetwork, zoneId);
                    hostnames.put(DNSservice.ZoneType.PUBLIC, DnsUtils.relativeSafeDnsName(recordName, zoneName));
                }
                if (!StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) break;
                zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                zoneName = this.getZoneNameFromZoneId(virtualNetwork, zoneId);
                hostnames.put(DNSservice.ZoneType.PRIVATE, DnsUtils.relativeSafeDnsName(recordName, zoneName));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                String zoneName = this.getZoneNameFromZoneId(virtualNetwork, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                hostnames.put(DNSservice.ZoneType.PRIVATE, DnsUtils.relativeSafeDnsName(recordName, subzone, zoneName));
                break;
            }
        }
        return hostnames;
    }

    @Override
    public String getPublicDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.getDNSZoneDomain(virtualNetwork, DNSservice.ZoneType.PUBLIC);
    }

    @Override
    public String getPrivateDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.getDNSZoneDomain(virtualNetwork, DNSservice.ZoneType.PRIVATE);
    }

    private String getDNSZoneDomain(VirtualNetwork virtualNetwork, DNSservice.ZoneType zoneType) {
        Object dnsName = "";
        switch (virtualNetwork.getDnsStrategy()) {
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneId;
                if (zoneType == DNSservice.ZoneType.PUBLIC && StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) {
                    zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                    dnsName = this.getZoneNameFromZoneId(virtualNetwork, zoneId);
                }
                if (zoneType != DNSservice.ZoneType.PRIVATE || !StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) break;
                zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                dnsName = this.getZoneNameFromZoneId(virtualNetwork, zoneId);
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                dnsName = subzone + "." + this.getZoneNameFromZoneId(virtualNetwork, zoneId);
            }
        }
        if (((String)dnsName).endsWith(".")) {
            return ((String)dnsName).substring(0, ((String)dnsName).length() - 1);
        }
        return dnsName;
    }

    public synchronized Optional<String> getDNSRecordValueForSubdomain(VirtualNetwork virtualNetwork, String subdomain, DNSservice.ZoneType zoneType, DNSservice.RecordType recordType) {
        List records = switch (virtualNetwork.getDnsStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case VirtualNetwork.DNSStrategy.NONE -> List.of();
            case VirtualNetwork.DNSStrategy.VN_SPECIFIC_CLOUD_DNS_SERVICE -> {
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, this.fmApp.getFMSettings()));
                String v1 = switch (zoneType) {
                    default -> throw new IncompatibleClassChangeError();
                    case DNSservice.ZoneType.PRIVATE -> virtualNetwork.getAwsRoute53PrivateIPZoneId();
                    case DNSservice.ZoneType.PUBLIC -> virtualNetwork.getAwsRoute53PublicIPZoneId();
                };
                yield Optional.ofNullable(v1).filter(StringUtils::isNotBlank).map(zoneId -> {
                    String zoneName = this.getZoneNameFromZoneId(r53Client, (String)zoneId);
                    String recordName = DnsUtils.relativeSafeDnsName(subdomain, zoneName);
                    return this.getRoute53Record(r53Client, (String)zoneId, recordName, recordType);
                }).orElse(List.of());
            }
            case VirtualNetwork.DNSStrategy.FM_MANAGED_CLOUD_DNS_SERVICE -> {
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork.getTenant().getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                String zoneName = this.getZoneNameFromZoneId(r53Client, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = DnsUtils.relativeSafeDnsName(subdomain, subzone, zoneName);
                yield this.getRoute53Record(r53Client, zoneId, publicDnsName, recordType);
            }
        };
        return records.stream().findFirst().flatMap(r -> r.resourceRecords().stream().map(ResourceRecord::value).findFirst());
    }

    public synchronized Optional<String> getDNSRecordValue(VirtualNetwork virtualNetwork, String recordName, DNSservice.ZoneType zoneType, DNSservice.RecordType recordType) {
        List<Object> records = new ArrayList();
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneId;
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, this.fmApp.getFMSettings()));
                if (zoneType == DNSservice.ZoneType.PRIVATE && StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) {
                    logger.infoV("Update DNS record for private IP for record '%s'", new Object[]{recordName});
                    zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                    records = this.getRoute53Record(r53Client, zoneId, recordName, recordType);
                }
                if (zoneType != DNSservice.ZoneType.PUBLIC || !StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) break;
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                records = this.getRoute53Record(r53Client, zoneId, recordName, recordType);
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork.getTenant().getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                records = this.getRoute53Record(r53Client, zoneId, recordName, recordType);
                break;
            }
        }
        return records.stream().findFirst().flatMap(r -> r.resourceRecords().stream().map(ResourceRecord::value).findFirst());
    }

    public synchronized void removeDNSRecord(VirtualNetwork virtualNetwork, PhysicalDNSRecord physicalDNSRecord) {
        if (physicalDNSRecord != null) {
            Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, FMApp.getFMSettingsUnsafe()));
            this.deleteRoute53Record(r53Client, physicalDNSRecord.getZoneId(), physicalDNSRecord.getName(), physicalDNSRecord.getRecordType());
        }
    }

    @Override
    public synchronized void checkIfZoneExist(VirtualNetwork virtualNetwork, String zoneId) {
        Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, FMApp.getFMSettingsUnsafe()));
        GetHostedZoneResponse result = r53Client.getHostedZone((GetHostedZoneRequest)GetHostedZoneRequest.builder().id(zoneId).build());
        if (result.hostedZone() == null) {
            throw new ApplicativeException("Invalid DNS Zone Identifier", "The DNS zone '" + zoneId + "' cannot be retrieved from account '" + virtualNetwork.getCloudAccountOrVirtualCloudAccount().getLabel() + "' and region '" + virtualNetwork.getAwsRegionOrSettingsDefault(FMApp.getFMSettingsUnsafe()) + "'.");
        }
    }

    public Optional<PhysicalDNSRecord> updateDNSCNAMERecords(VirtualNetwork virtualNetwork, DNSservice.ZoneType zoneType, PhysicalDNSRecord physicalDNSRecord, String recordName, String cname) {
        if (physicalDNSRecord != null && !physicalDNSRecord.getName().equals(recordName)) {
            this.removeDNSRecord(virtualNetwork, physicalDNSRecord);
        }
        return this.addDNSCNAMERecords(virtualNetwork, zoneType, recordName, cname);
    }

    public synchronized Optional<PhysicalDNSRecord> addDNSCNAMERecords(VirtualNetwork virtualNetwork, DNSservice.ZoneType zoneType, String recordName, String cname) {
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, FMApp.getFMSettingsUnsafe()));
                if (zoneType == DNSservice.ZoneType.PUBLIC && StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PublicIPZoneId())) {
                    logger.infoV("Update DNS record '%s' for CNAME for record '%s'", new Object[]{recordName, cname});
                    String zoneId = virtualNetwork.getAwsRoute53PublicIPZoneId();
                    return Optional.of(this.addRoute53Record(r53Client, zoneId, recordName, DNSservice.RecordType.CNAME, DNSservice.ZoneType.PUBLIC, cname));
                }
                if (zoneType != DNSservice.ZoneType.PRIVATE || !StringUtils.isNotBlank((CharSequence)virtualNetwork.getAwsRoute53PrivateIPZoneId())) break;
                logger.infoV("Update DNS record '%s' for CNAME for record '%s'", new Object[]{recordName, cname});
                String zoneId = virtualNetwork.getAwsRoute53PrivateIPZoneId();
                return Optional.of(this.addRoute53Record(r53Client, zoneId, recordName, DNSservice.RecordType.CNAME, DNSservice.ZoneType.PRIVATE, cname));
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Update DNS record '%s' for CNAME for record '%s'", new Object[]{recordName, cname});
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork.getTenant().getVirtualCloudAccount(settings), settings.awsSettings.regionId, this.cloudCryptoService));
                String zoneId = virtualNetwork.getTenant().getAwsRoute53ManagedZoneId();
                return Optional.of(this.addRoute53Record(r53Client, zoneId, recordName, DNSservice.RecordType.CNAME, DNSservice.ZoneType.PUBLIC, cname));
            }
        }
        return Optional.empty();
    }

    public synchronized String getZoneNameFromZoneId(VirtualNetwork virtualNetwork, String zoneId) {
        Route53Client r53Client = this.awsClientService.getRoute53Client(AWSUtils.buildAWSAccount(virtualNetwork, this.cloudCryptoService, this.fmApp.getFMSettings()));
        return this.getZoneNameFromZoneId(r53Client, zoneId);
    }

    public String getZoneNameFromZoneId(Route53Client r53Client, String zoneId) {
        GetHostedZoneResponse response = r53Client.getHostedZone((GetHostedZoneRequest)GetHostedZoneRequest.builder().id(zoneId).build());
        if (response.hostedZone() != null) {
            return response.hostedZone().name();
        }
        throw new IllegalArgumentException("Invalid route53 zone id");
    }

    public void updateDnsRecords(Ec2Client ec2, String awsEC2InstanceId, PhysicalInstance pi, DNSservice.RecordType recordType, Map<String, String> tags) {
        LogicalInstance li = pi.getLogicalInstance();
        DescribeInstancesResponse described = ec2.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(new String[]{awsEC2InstanceId}).build());
        Instance instance = (Instance)((Reservation)described.reservations().get(0)).instances().get(0);
        VirtualNetwork virtualNetwork = li.getVirtualNetwork();
        this.addDNSRecords(virtualNetwork, li.getLabel(), this.getPublicIPToAssignDNSTo(li, ec2, instance), instance.privateIpAddress(), recordType, tags);
        Map<DNSservice.ZoneType, String> domains = this.getFQDNs(virtualNetwork, li.getLabel());
        if (domains != null) {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                if (domains.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                    pi.setPrivateDnsName(domains.get((Object)DNSservice.ZoneType.PRIVATE));
                }
                if (domains.containsKey((Object)DNSservice.ZoneType.PUBLIC)) {
                    pi.setPublicDnsName(domains.get((Object)DNSservice.ZoneType.PUBLIC));
                }
                rwt.getThreadEM().merge((Object)pi);
                rwt.commit();
            }
        }
    }

    private String getPublicIPToAssignDNSTo(LogicalInstance li, Ec2Client ec2, Instance instance) {
        if (li.isAwsAssignElasticIP()) {
            return ((Address)ec2.describeAddresses((DescribeAddressesRequest)DescribeAddressesRequest.builder().allocationIds(new String[]{li.getAwsElasticIPAllocationId()}).build()).addresses().get(0)).publicIp();
        }
        if (li.getVirtualNetwork().isAwsAssignPublicIP()) {
            return instance.publicIpAddress();
        }
        return null;
    }

    private void deleteRoute53Record(Route53Client r53Client, String zoneId, String recordName, DNSservice.RecordType type) {
        List<ResourceRecordSet> records = this.getRoute53Record(r53Client, zoneId, recordName, type);
        if (!records.isEmpty()) {
            r53Client.changeResourceRecordSets((ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(zoneId).changeBatch((ChangeBatch)ChangeBatch.builder().changes((Collection)records.stream().map(r -> (Change)Change.builder().action(ChangeAction.DELETE).resourceRecordSet(r).build()).collect(Collectors.toList())).build()).build());
        }
    }

    private List<ResourceRecordSet> getRoute53Record(Route53Client r53Client, String zoneId, String recordName, DNSservice.RecordType type) {
        RRType rrType = this.toRRType(type);
        ListResourceRecordSetsResponse listResourceRecordSetsResult = r53Client.listResourceRecordSets((ListResourceRecordSetsRequest)ListResourceRecordSetsRequest.builder().hostedZoneId(zoneId).startRecordName(recordName).startRecordType(rrType).build());
        return listResourceRecordSetsResult.resourceRecordSets().stream().filter(r -> r.name().equals(recordName) || r.name().equals(recordName + ".") || r.name().equals("_" + recordName + ".")).collect(Collectors.toList());
    }

    private PhysicalDNSRecord addRoute53Record(Route53Client r53Client, String zoneId, String recordName, DNSservice.RecordType type, DNSservice.ZoneType zoneType, String value) {
        Change creationChange = (Change)Change.builder().resourceRecordSet((ResourceRecordSet)ResourceRecordSet.builder().name(recordName).type(this.toRRType(type)).ttl(Long.valueOf(60L)).resourceRecords(new ResourceRecord[]{(ResourceRecord)ResourceRecord.builder().value(value).build()}).build()).action(ChangeAction.UPSERT).build();
        logger.infoV("Writing Route53 record zone=%s record=%s type=%s value=%s", new Object[]{zoneId, recordName, type, value});
        ChangeResourceRecordSetsRequest req = (ChangeResourceRecordSetsRequest)ChangeResourceRecordSetsRequest.builder().hostedZoneId(zoneId).changeBatch((ChangeBatch)ChangeBatch.builder().changes(new Change[]{creationChange}).build()).build();
        r53Client.changeResourceRecordSets(req);
        return new PhysicalDNSRecord(recordName, zoneId, type, zoneType);
    }

    private RRType toRRType(DNSservice.RecordType type) {
        switch (type) {
            case A: {
                return RRType.A;
            }
            case CNAME: {
                return RRType.CNAME;
            }
        }
        throw new IllegalArgumentException("Unknown record type '" + String.valueOf((Object)type) + "'");
    }
}

