/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws.sdk;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Action;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.FixedResponseActionConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ForwardActionConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleCondition;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetDescription;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAttribute;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupStickinessConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupTuple;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class LoadBalancingClientWrapper {
    private final ElasticLoadBalancingV2Client loadBalancingClient;

    public LoadBalancingClientWrapper(ElasticLoadBalancingV2Client loadBalancingClient) {
        this.loadBalancingClient = loadBalancingClient;
    }

    public ElasticLoadBalancingV2Client getClient() {
        return this.loadBalancingClient;
    }

    public CreateLoadBalancerResponse createLoadBalancer(String name, LoadBalancerSchemeEnum scheme, List<String> subnetIds, String[] securityGroups, Collection<Tag> tags) {
        return this.loadBalancingClient.createLoadBalancer((CreateLoadBalancerRequest)CreateLoadBalancerRequest.builder().name(name).scheme(scheme).subnets(subnetIds).securityGroups(securityGroups).tags(tags).build());
    }

    public CreateListenerResponse createListener(String loadBalancerArn, Optional<String> certificateArnOptional, ProtocolEnum protocol, int port, Collection<Tag> tags) {
        List<Certificate> certificateList = certificateArnOptional.stream().map(certificateArn -> (Certificate)Certificate.builder().certificateArn(certificateArn).build()).toList();
        return this.loadBalancingClient.createListener((CreateListenerRequest)CreateListenerRequest.builder().loadBalancerArn(loadBalancerArn).certificates(certificateList).defaultActions(new Action[]{LoadBalancingClientWrapper.getDefaultAction()}).protocol(protocol).port(Integer.valueOf(port)).tags(tags).build());
    }

    public DescribeLoadBalancersResponse describeLoadBalancer(String arn) {
        return this.loadBalancingClient.describeLoadBalancers((DescribeLoadBalancersRequest)DescribeLoadBalancersRequest.builder().loadBalancerArns(new String[]{arn}).build());
    }

    public String createTargetGroup(Set<String> instanceIds, int port, ProtocolEnum protocol, String vpcId, Collection<Tag> tags) {
        CreateTargetGroupResponse awsTargetGroup = this.loadBalancingClient.createTargetGroup((CreateTargetGroupRequest)CreateTargetGroupRequest.builder().name("tg-" + SecretKeyGenerator.generate((int)12)).protocol(protocol).port(Integer.valueOf(port)).vpcId(vpcId).ipAddressType(TargetGroupIpAddressTypeEnum.IPV4).tags(tags).build());
        String targetGroupArn = ((TargetGroup)awsTargetGroup.targetGroups().get(0)).targetGroupArn();
        this.loadBalancingClient.modifyTargetGroupAttributes((ModifyTargetGroupAttributesRequest)ModifyTargetGroupAttributesRequest.builder().targetGroupArn(targetGroupArn).attributes(new TargetGroupAttribute[]{(TargetGroupAttribute)TargetGroupAttribute.builder().key("stickiness.enabled").value("true").build(), (TargetGroupAttribute)TargetGroupAttribute.builder().key("stickiness.type").value("lb_cookie").build()}).build());
        Set targets = instanceIds.stream().map(instanceId -> (TargetDescription)TargetDescription.builder().id(instanceId).build()).collect(Collectors.toSet());
        if (!targets.isEmpty()) {
            this.loadBalancingClient.registerTargets((RegisterTargetsRequest)RegisterTargetsRequest.builder().targetGroupArn(targetGroupArn).targets(targets).build());
        }
        return targetGroupArn;
    }

    public void deleteTargetGroup(String arn) {
        this.loadBalancingClient.deleteTargetGroup((DeleteTargetGroupRequest)DeleteTargetGroupRequest.builder().targetGroupArn(arn).build());
    }

    public String createRule(String listenerArn, String hostname, String targetGroupArn, int order, Collection<Tag> tags) {
        Action action = (Action)Action.builder().type(ActionTypeEnum.FORWARD).targetGroupArn(targetGroupArn).order(Integer.valueOf(1)).forwardConfig((ForwardActionConfig)ForwardActionConfig.builder().targetGroups(new TargetGroupTuple[]{(TargetGroupTuple)TargetGroupTuple.builder().targetGroupArn(targetGroupArn).weight(Integer.valueOf(1)).build()}).targetGroupStickinessConfig((TargetGroupStickinessConfig)TargetGroupStickinessConfig.builder().enabled(Boolean.valueOf(false)).build()).build()).build();
        CreateRuleResponse awsRule = this.loadBalancingClient.createRule((CreateRuleRequest)CreateRuleRequest.builder().listenerArn(listenerArn).priority(Integer.valueOf(order)).tags(tags).conditions(new RuleCondition[]{(RuleCondition)RuleCondition.builder().field("host-header").values(new String[]{hostname}).build()}).actions(new Action[]{action}).build());
        return ((Rule)awsRule.rules().get(0)).ruleArn();
    }

    public void deleteRule(String arn) {
        this.loadBalancingClient.deleteRule((DeleteRuleRequest)DeleteRuleRequest.builder().ruleArn(arn).build());
    }

    public DescribeTargetHealthResponse describeTargetHealth(String targetGroupArn) {
        return this.loadBalancingClient.describeTargetHealth((DescribeTargetHealthRequest)DescribeTargetHealthRequest.builder().targetGroupArn(targetGroupArn).build());
    }

    public void deregisterTargets(String targetGroupArn, Collection<String> instanceIds) {
        this.loadBalancingClient.deregisterTargets((DeregisterTargetsRequest)DeregisterTargetsRequest.builder().targetGroupArn(targetGroupArn).targets(instanceIds.stream().map(instanceId -> (TargetDescription)TargetDescription.builder().id(instanceId).build()).toList()).build());
    }

    private static Action getDefaultAction() {
        return (Action)Action.builder().type(ActionTypeEnum.FIXED_RESPONSE).order(Integer.valueOf(1)).fixedResponseConfig((FixedResponseActionConfig)FixedResponseActionConfig.builder().statusCode("400").contentType("text/plain").messageBody("No available instance matching this hostname or instance not running.").build()).build();
    }
}

