/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ARecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayOperationalState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasName;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.azure.AzureUtils;
import com.dataiku.fm.cloud.azure.sdk.AzureResourceManagerWrapper;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.tag.TagService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AzureCloudLoadBalancerService
implements CloudLoadBalancerServiceInterface {
    private static final String LB_RESOURCE_NAME_PREFIX = "FM-managed.for-hostname.";
    private static final Predicate<HasName> isManagedPredicate = lbEntity -> lbEntity.name().startsWith(LB_RESOURCE_NAME_PREFIX);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.loadbalancer");
    private final AzureClientService clientService;
    private final AzureDNSService azureDNSService;
    private final DatabaseAccessService dbService;
    private final TagService defaultKeysTagService;
    private final TagService sanitizedKeysTagService;
    private final FMApp fmApp;

    @Autowired
    public AzureCloudLoadBalancerService(AzureClientService clientService, AzureDNSService azureDNSService, DatabaseAccessService dbService, @Qualifier(value="defaultKeys") TagService defaultKeysTagService, @Qualifier(value="sanitizedKeys") TagService sanitizedKeysTagService, FMApp fmApp) {
        this.clientService = clientService;
        this.azureDNSService = azureDNSService;
        this.dbService = dbService;
        this.defaultKeysTagService = defaultKeysTagService;
        this.sanitizedKeysTagService = sanitizedKeysTagService;
        this.fmApp = fmApp;
    }

    @Override
    public PhysicalLoadBalancer createPhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        if (lb.getLoadBalancerNodeMapping().size() == 0) {
            throw new IllegalStateException("Load balancer should have at least one node mapping");
        }
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            PhysicalLoadBalancer physicalLoadBalancer = new PhysicalLoadBalancer();
            String physicalLoadBalancerId = "plb-" + SecretKeyGenerator.generate((int)12);
            physicalLoadBalancer.setId(physicalLoadBalancerId);
            physicalLoadBalancer.setLogicalLoadBalancer(lb);
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement preparingLBStep = FutureProgress.pushAutoCloseableState((String)"Preparing Azure load balancer", (double)1.0);){
                smartLogTail.appendLine("Initializing Azure gateway setup.", logger, Priority.INFO);
                physicalLoadBalancer.setAzureApplicationGatewayId(this.buildApplicationGatewayResourceId(AzureUtils.getResourceGroupForCreatedResources(lb.getVirtualNetwork()), lb.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount().getAzureSubscription(), physicalLoadBalancerId));
                lb.setCurrentPhysicalLoadBalancer(physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
            }
            try {
                AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGateway;
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createLBStep = FutureProgress.pushAutoCloseableState((String)"Creating Azure load balancer", (double)1.0);){
                    smartLogTail.appendLine("Starting the creation of Azure gateway...", logger, Priority.INFO);
                    applicationGateway = this.createApplicationGateway(lb, physicalLoadBalancer);
                    smartLogTail.replaceLastLine("Azure gateway successfully created with ID: '" + applicationGateway.id() + "'", logger, Priority.INFO);
                }
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dssRecordsStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)lb.getLoadBalancerNodeMapping().size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                    Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
                    for (String hostname : nodeMappingsPerHostName.keySet()) {
                        FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dssRecordStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)1.0);
                        try {
                            smartLogTail.appendLine("Setting up DNS record for '" + hostname + "'...", logger, Priority.INFO);
                            Map<DNSservice.ZoneType, PhysicalDNSRecord> zoneTypePhysicalDNSRecordMap = this.azureDNSService.addDNSRecords(lb.getVirtualNetwork(), hostname, applicationGateway.ipAddress(), null, DNSservice.RecordType.A, AzureUtils.getTagsWithName(LB_RESOURCE_NAME_PREFIX + hostname, this.sanitizedKeysTagService.getCloudApplicableTags(lb)));
                            smartLogTail.replaceLastLine("DNS record for '" + hostname + "' has been successfully created", logger, Priority.INFO);
                            for (LoadBalancerNodeMapping nodeMapping : nodeMappingsPerHostName.get(hostname)) {
                                if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                                    nodeMapping.setPrivatePhysicalDNSRecord(zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PRIVATE));
                                }
                                if (!zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PUBLIC)) continue;
                                nodeMapping.setPublicPhysicalDNSRecord(zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PUBLIC));
                            }
                        }
                        finally {
                            if (dssRecordStep == null) continue;
                            dssRecordStep.close();
                        }
                    }
                }
                PhysicalLoadBalancer physicalLoadBalancer2 = physicalLoadBalancer;
                return physicalLoadBalancer2;
            }
            catch (Throwable e) {
                logger.error((Object)"An error occurred during gateway creation: ", e);
                logger.info((Object)"Cleaning up gateway components");
                smartLogTail.appendLine("Encountered an error during gateway creation, initiating cleanup...");
                this.deletePhysicalLoadBalancer(lb, rwt, smartLogTail);
                lb.setCurrentPhysicalLoadBalancer(null);
                rwt.getThreadEM().persist((Object)lb);
                rwt.getThreadEM().remove((Object)physicalLoadBalancer);
                rwt.commit();
                throw e;
            }
        }
    }

    @Override
    public boolean deletePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        PhysicalLoadBalancer plb = lb.getCurrentPhysicalLoadBalancer();
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Deleting Azure load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            CloudAccount cloudAccount;
            if (plb == null) {
                boolean bl = true;
                return bl;
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement nodeMappingsStep = FutureProgress.pushAutoCloseableState((String)"Deleting node mappings", (double)lb.getLoadBalancerNodeMapping().size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = lb.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
                for (String hostname : nodeMappingsPerHostName.keySet()) {
                    FutureProgress.AutocloseableFutureProgressStateWithAutoincrement nodeMappingStep = FutureProgress.pushAutoCloseableState((String)("Deleting DNS records for node mapping '" + hostname + "'"), (double)1.0);
                    try {
                        Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerHostName.get(hostname);
                        LoadBalancerNodeMapping anyNodeMapping = nodeMappings.iterator().next();
                        Optional.ofNullable(anyNodeMapping.getPublicPhysicalDNSRecord()).map(PhysicalDNSRecord::getName).ifPresent(recordName -> {
                            smartLogTail.appendLine("Removing public DNS record for '" + hostname + "'...", logger, Priority.INFO);
                            this.azureDNSService.removeAzureDNSRecord(lb.getVirtualNetwork(), (String)recordName);
                            smartLogTail.replaceLastLine("Public DNS record for '" + hostname + "' successfully deleted", logger, Priority.INFO);
                        });
                        Optional.ofNullable(anyNodeMapping.getPrivatePhysicalDNSRecord()).map(PhysicalDNSRecord::getName).ifPresent(recordName -> {
                            smartLogTail.appendLine("Removing private DNS record for '" + hostname + "'...", logger, Priority.INFO);
                            this.azureDNSService.removeAzureDNSRecord(lb.getVirtualNetwork(), (String)recordName);
                            smartLogTail.replaceLastLine("Private DNS record for '" + hostname + "' successfully deleted", logger, Priority.INFO);
                        });
                        for (LoadBalancerNodeMapping nodeMapping : nodeMappings) {
                            if (nodeMapping.getPublicPhysicalDNSRecord() != null) {
                                this.dbService.getThreadEM().remove((Object)nodeMapping.getPublicPhysicalDNSRecord());
                            }
                            if (nodeMapping.getPrivatePhysicalDNSRecord() != null) {
                                this.dbService.getThreadEM().remove((Object)nodeMapping.getPrivatePhysicalDNSRecord());
                            }
                            nodeMapping.setPublicPhysicalDNSRecord(null);
                            nodeMapping.setPrivatePhysicalDNSRecord(null);
                        }
                    }
                    finally {
                        if (nodeMappingStep == null) continue;
                        nodeMappingStep.close();
                    }
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement lbStep = FutureProgress.pushAutoCloseableState((String)"Deleting Azure load balancer", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                if (plb.getAzureApplicationGatewayId() != null) {
                    smartLogTail.appendLine("Initiating deletion of load balancer with ID '" + plb.getAzureApplicationGatewayId() + "'...", logger, Priority.INFO);
                    cloudAccount = lb.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                    this.clientService.getAzureClient(cloudAccount).applicationGateways().deleteById(plb.getAzureApplicationGatewayId());
                    smartLogTail.replaceLastLine("Load balancer with ID '" + plb.getAzureApplicationGatewayId() + "' has been deleted", logger, Priority.INFO);
                    plb.setAzureApplicationGatewayId(null);
                } else {
                    smartLogTail.appendLine("No Azure load balancer found to delete", logger, Priority.INFO);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement externalIPStep = FutureProgress.pushAutoCloseableState((String)"Deleting managed external IP", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                if (plb.getAzureFMManagedExternalIpId() != null) {
                    smartLogTail.appendLine("Removing public IP address with ID '" + plb.getAzureFMManagedExternalIpId() + "'...", logger, Priority.INFO);
                    cloudAccount = lb.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                    this.clientService.getAzureClient(cloudAccount).publicIpAddresses().deleteById(plb.getAzureFMManagedExternalIpId());
                    smartLogTail.replaceLastLine("Public IP address with ID '" + plb.getAzureFMManagedExternalIpId() + "' successfully deleted", logger, Priority.INFO);
                    plb.setAzureExternalIpId(null);
                } else {
                    smartLogTail.appendLine("No managed external IP found to delete", logger, Priority.INFO);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void updatePhysicalLoadBalancer(LogicalLoadBalancer loadBalancer, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) throws InterruptedException {
        CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGatewayWrapper = this.clientService.getAzureClientWrapper(cloudAccount).getApplicationGateway(physicalLoadBalancer.getAzureApplicationGatewayId());
        if (applicationGatewayWrapper == null) {
            throw new IllegalStateException("Application gateway not provisioned. Please provision or reprovision instead.");
        }
        try (FutureProgress.AutocloseableFutureProgressState global = FutureProgress.pushAutoCloseableState((String)"Updating load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement step = FutureProgress.pushAutoCloseableState((String)"Preparing load balancer update", (double)1.0);){
                smartLogTail.appendLine("Updating Azure load balancer, this step may take several minutes", logger, Priority.INFO);
                AzureResourceManagerWrapper azureClientWrapper = this.clientService.getAzureClientWrapper(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
                ApplicationGatewayUpdateData updateData = this.buildApplicationGatewayUpdateData(azureClientWrapper, loadBalancer, physicalLoadBalancer);
                azureClientWrapper.updateApplicationGateway(updateData.applicationGatewayId, updateData.resources, updateData.isManagedPredicate, updateData.publicIpId, updateData.areNodesHttps, updateData.certificateConfiguration);
            }
            this.updateDnsRecords(applicationGatewayWrapper.ipAddress(), loadBalancer, smartLogTail);
        }
    }

    private ApplicationGatewayUpdateData buildApplicationGatewayUpdateData(AzureResourceManagerWrapper azureClientWrapper, LogicalLoadBalancer loadBalancer, PhysicalLoadBalancer physicalLoadBalancer) {
        Optional<String> keyVaultSecretIdOptional = loadBalancer.getCertificateMode() == CertificateMode.AZURE_SECRET_ID ? Optional.of(loadBalancer.getAzureCertificateSecretId()) : Optional.empty();
        return new ApplicationGatewayUpdateData(physicalLoadBalancer.getAzureApplicationGatewayId(), this.buildResourceSet(loadBalancer, azureClientWrapper, true), isManagedPredicate, this.getOrCreatePublicIp(loadBalancer, physicalLoadBalancer, azureClientWrapper), loadBalancer.getVirtualNetwork().getHttpsStrategy() != VirtualNetwork.HTTPSStrategy.NONE, new AzureResourceManagerWrapper.CertificateConfiguration(this.getCertificateConfigId(physicalLoadBalancer.getId()), keyVaultSecretIdOptional));
    }

    private static String getResourceIdForHostname(String hostname) {
        return LB_RESOURCE_NAME_PREFIX + hostname;
    }

    @Override
    public boolean isLoadBalancerProvisioning(LogicalLoadBalancer loadBalancer) {
        return Optional.ofNullable(loadBalancer.getCurrentPhysicalLoadBalancer()).map(PhysicalLoadBalancer::getAzureApplicationGatewayId).flatMap(applicationGatewayResourceId -> Optional.ofNullable(this.clientService.getAzureClientWrapper(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).getApplicationGateway((String)applicationGatewayResourceId))).map(AzureResourceManagerWrapper.ApplicationGatewayWrapper::operationalState).map(arg_0 -> ((ApplicationGatewayOperationalState)ApplicationGatewayOperationalState.STARTING).equals(arg_0)).orElse(false);
    }

    @Override
    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        LoadBalancerPhysicalStatus loadBalancerPhysicalStatus = new LoadBalancerPhysicalStatus();
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
        if (currentPhysicalLoadBalancer == null || currentPhysicalLoadBalancer.getAzureApplicationGatewayId() == null) {
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_NOT_PROVISIONED, "");
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
        } else {
            CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
            String applicationGatewayId = currentPhysicalLoadBalancer.getAzureApplicationGatewayId();
            AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGateway = this.clientService.getAzureClientWrapper(cloudAccount).getApplicationGateway(applicationGatewayId);
            if (applicationGateway == null) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_NOT_PROVISIONED, "Couldn't find application gateway with id '" + applicationGatewayId + "'");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
            } else {
                loadBalancerPhysicalStatus.loadBalancerLink = this.getLoadBalancerLink(loadBalancer);
                ApplicationGatewayOperationalState applicationGatewayOperationalState = applicationGateway.operationalState();
                if (ApplicationGatewayOperationalState.STOPPED.equals((Object)applicationGatewayOperationalState) || ApplicationGatewayOperationalState.STOPPING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_UNAVAILABLE, "Application gateway '" + applicationGatewayId + "' is stopped.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                    return loadBalancerPhysicalStatus;
                }
                if (ApplicationGatewayOperationalState.STARTING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_PROVISIONING, "Application gateway '" + applicationGatewayId + "' is starting.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONING);
                    return loadBalancerPhysicalStatus;
                }
                if (ApplicationGatewayOperationalState.RUNNING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_PROVISIONED, "Application gateway '" + applicationGatewayId + "' is running.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
                } else {
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_UNAVAILABLE, "Application gateway '" + applicationGatewayId + "' status unknown: '" + String.valueOf(applicationGatewayOperationalState) + "'");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
                }
                if (!Objects.equals(applicationGateway.networkId(), loadBalancer.getVirtualNetwork().getAzureVnId())) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_WRONG_NETWORK, "Load balancer is in virtual network '" + applicationGateway.networkId() + "' instead of expected virtual network '" + loadBalancer.getVirtualNetwork().getAzureVnId() + "'");
                }
                AzureResourceManagerWrapper azureClientWrapper = this.clientService.getAzureClientWrapper(cloudAccount);
                ApplicationGatewayUpdateData updateData = this.buildApplicationGatewayUpdateData(azureClientWrapper, loadBalancer, currentPhysicalLoadBalancer);
                AzureResourceManagerWrapper.StatusCheckResult statusCheckResult = azureClientWrapper.generateMessagesForStatusCheck(updateData.applicationGatewayId, updateData.resources, updateData.isManagedPredicate, updateData.publicIpId, updateData.areNodesHttps, updateData.certificateConfiguration);
                if (!statusCheckResult.isNoAction()) {
                    loadBalancerPhysicalStatus.setStatus(this.mapFrom(statusCheckResult.reconciliationAction()));
                    statusCheckResult.messages().forEach(arg_0 -> ((InfoMessage.InfoMessages)loadBalancerPhysicalStatus.infoMessages).addMessage(arg_0));
                }
                this.configureAzureExternalIPLink(loadBalancer, loadBalancerPhysicalStatus);
                this.getLoadBalancerDNSStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
            }
        }
        List inactiveNodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).collect(Collectors.toList());
        if (inactiveNodes.size() > 0) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING, "The following node mappings are inactive but still associated to cloud resources: " + inactiveNodes.stream().map(n -> n.getSubdomainOrFQDN() + "->" + n.getLogicalInstance().getLabel()).collect(Collectors.joining(",")));
        }
        return loadBalancerPhysicalStatus;
    }

    @Override
    public void onInstancePhysicalStateChange(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer currentLoadBalancer, LogicalInstance logicalInstance) {
        if (currentLoadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return;
        }
        logger.info((Object)("Instance '" + logicalInstance.getLabel() + "' physical state has changed, updating LB."));
        String gatewayId = currentLoadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId();
        CloudAccount cloudAccount = currentLoadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
        AzureResourceManagerWrapper azureClientWrapper = this.clientService.getAzureClientWrapper(cloudAccount);
        AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGatewayWrapper = azureClientWrapper.getApplicationGateway(gatewayId);
        if (applicationGatewayWrapper == null) {
            throw new IllegalStateException("Couldn't find gateway '" + gatewayId + "'");
        }
        azureClientWrapper.updateApplicationGatewayBackends(gatewayId, this.buildResourceSet(currentLoadBalancer, azureClientWrapper, false), isManagedPredicate);
    }

    @Override
    public boolean isLoadBalancerNodeMappingProvisioned(LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return false;
        }
        return this.clientService.getAzureClientWrapper(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).getBackends(loadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId()).containsKey(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getSubdomainOrFQDN()));
    }

    @Override
    public void onInstanceDeleteEvent(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping, LogicalInstance logicalInstance) {
        Set nodeMappingsForHostname;
        PhysicalLoadBalancer physicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer != null && (nodeMappingsForHostname = (Set)loadBalancer.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN().getOrDefault(nodeMapping.getSubdomainOrFQDN(), new HashSet())).isEmpty()) {
            logger.infoV("Instance '%s' was deleted, removing it from load balancer", new Object[]{logicalInstance.getId()});
            ((ApplicationGateway.Update)((ApplicationGateway)this.clientService.getAzureClient(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).applicationGateways().getById(physicalLoadBalancer.getAzureApplicationGatewayId())).update()).withoutBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getSubdomainOrFQDN())).withoutRequestRoutingRule(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getSubdomainOrFQDN())).withoutListener(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getSubdomainOrFQDN())).withoutBackendHttpConfiguration(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getSubdomainOrFQDN())).apply();
        }
    }

    @Override
    public String getLoadBalancerLink(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return "";
        }
        AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGatewayWrapper = this.clientService.getAzureClientWrapper(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount()).getApplicationGateway(loadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId());
        return "https://app.azure.com/" + loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount().getAzureTenantId() + "/subscriptions/" + loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount().getAzureSubscription() + "/resourceGroups/" + AzureUtils.getResourceGroupForCreatedResources(loadBalancer.getVirtualNetwork()) + "/providers/Microsoft.Network/applicationGateways/" + applicationGatewayWrapper.name();
    }

    private void configureAzureExternalIPLink(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus) {
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        if (loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.DYNAMIC_PUBLIC_IP) {
            Optional.ofNullable(currentPhysicalLoadBalancer.getAzureFMManagedExternalIpId()).flatMap(externalIpId -> {
                CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount();
                return Optional.ofNullable(this.clientService.getAzureClientWrapper(cloudAccount).getPublicIpAddress((String)externalIpId));
            }).ifPresent(externalIp -> {
                loadBalancerPhysicalStatus.azureExternalIPLink = this.buildExternalIpLink(loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount().getAzureTenantId(), loadBalancer.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount().getAzureSubscription(), AzureUtils.getResourceGroupForCreatedResources(loadBalancer.getVirtualNetwork()), externalIp.name());
                loadBalancerPhysicalStatus.azureExternalIPName = externalIp.name();
            });
        }
    }

    private void getLoadBalancerDNSStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, AzureResourceManagerWrapper.ApplicationGatewayWrapper applicationGatewayWrapper) {
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
        if (loadBalancer.getVirtualNetwork().getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE) {
            String publicIPAddress = applicationGatewayWrapper.ipAddress();
            for (String hostname2 : nodeMappingsPerHostName.keySet()) {
                Optional<String> dnsRecord = this.azureDNSService.getDNSRecord(loadBalancer.getVirtualNetwork(), hostname2, DNSservice.RecordType.A);
                if (dnsRecord.isPresent()) {
                    if (dnsRecord.get().equals(publicIPAddress)) continue;
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_WRONG_DNS_RECORD, "DNS record  '" + hostname2 + "' = '" + dnsRecord.get() + "' not matching Load balancing DNS '" + publicIPAddress + "'.");
                    continue;
                }
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_MISSING_DNS_RECORD, "DNS record  '" + hostname2 + "' not found.");
            }
        }
        this.getDNSRecordPerLoadBalancerHostname(loadBalancer.getVirtualNetwork(), loadBalancer.getId()).keySet().stream().filter(hostname -> !nodeMappingsPerHostName.containsKey(hostname)).forEach(hostname -> {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_ORPHAN_DNS_RECORD, "DNS record  '" + hostname + "' should be removed.");
        });
    }

    private Map<String, ARecordSet> getDNSRecordPerLoadBalancerHostname(VirtualNetwork virtualNetwork, String logicalLoadBalancerId) {
        return this.azureDNSService.getDNSRecords(virtualNetwork).stream().flatMap(aRecord -> Optional.ofNullable((String)aRecord.metadata().get("Name")).filter(name -> name.startsWith(LB_RESOURCE_NAME_PREFIX)).map(name -> Map.entry(name.substring(LB_RESOURCE_NAME_PREFIX.length()), aRecord)).stream()).filter(entry -> logicalLoadBalancerId.equals(this.sanitizedKeysTagService.getLoadBalancerId(((ARecordSet)entry.getValue()).metadata()).orElse(null))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private void updateDnsRecords(String publicLbIpAddress, LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Updating DNS records", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
            if (loadBalancer.getVirtualNetwork().getDnsStrategy() == VirtualNetwork.DNSStrategy.NONE) {
                return;
            }
            Map<String, ARecordSet> dnsRecordPerHostname = this.getDNSRecordPerLoadBalancerHostname(loadBalancer.getVirtualNetwork(), loadBalancer.getId());
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerSubdomainOrFQDN();
            Set recordsToDelete = dnsRecordPerHostname.keySet().stream().filter(hostname -> !nodeMappingsPerHostName.containsKey(hostname)).collect(Collectors.toSet());
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deleteRecordsStep = FutureProgress.pushAutoCloseableState((String)"Deleting DNS records", (double)recordsToDelete.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                for (String hostname2 : recordsToDelete) {
                    smartLogTail.appendLine("Deleting orphan DNS record '" + hostname2 + "'", logger, Priority.INFO);
                    ARecordSet record = dnsRecordPerHostname.get(hostname2);
                    this.azureDNSService.removeAzureDNSRecord(loadBalancer.getVirtualNetwork(), record.name());
                    PhysicalDNSRecord physicalDNSRecord = this.dbService.getSingleResult(PhysicalDNSRecord.class, "SELECT pr from physicaldnsrecord pr where pr.name=?1", record.name());
                    if (physicalDNSRecord != null) {
                        this.dbService.getThreadEM().remove((Object)physicalDNSRecord);
                    }
                    FutureProgress.incrementState((double)1.0);
                }
            }
            Set recordsToCreate = nodeMappingsPerHostName.keySet().stream().filter(hostname -> !dnsRecordPerHostname.containsKey(hostname) || !((ARecordSet)dnsRecordPerHostname.get(hostname)).ipv4Addresses().contains(publicLbIpAddress)).collect(Collectors.toSet());
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createRecordsStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)recordsToCreate.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                for (String hostname3 : recordsToCreate) {
                    smartLogTail.appendLine("Setting up DNS record for '" + hostname3 + "' -> '" + publicLbIpAddress + "'", logger, Priority.INFO);
                    Map<DNSservice.ZoneType, PhysicalDNSRecord> zoneTypePhysicalDNSRecordMap = this.azureDNSService.addDNSRecords(loadBalancer.getVirtualNetwork(), hostname3, publicLbIpAddress, null, DNSservice.RecordType.A, AzureUtils.getTagsWithName(LB_RESOURCE_NAME_PREFIX + hostname3, this.sanitizedKeysTagService.getCloudApplicableTags(loadBalancer)));
                    nodeMappingsPerHostName.get(hostname3).forEach(nodeMapping -> {
                        if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                            nodeMapping.setPrivatePhysicalDNSRecord((PhysicalDNSRecord)zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PRIVATE));
                        }
                        if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PUBLIC)) {
                            nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PUBLIC));
                        }
                    });
                    FutureProgress.incrementState((double)1.0);
                }
            }
        }
    }

    private String getCertificateConfigId(String physicalLoadBalancerId) {
        return "lb-cert-" + physicalLoadBalancerId;
    }

    private String buildApplicationGatewayResourceId(String resourceGroupName, String azureSubscriptionId, String physicalLoadBalancerId) {
        return "/subscriptions/" + azureSubscriptionId + "/resourceGroups/" + resourceGroupName + "/providers/Microsoft.Network/applicationGateways/" + physicalLoadBalancerId;
    }

    private String buildExternalIpLink(String tenantId, String subscriptionId, String resourceGroupName, String externalIpName) {
        return "https://app.azure.com/" + tenantId + "/subscriptions/" + subscriptionId + "/resourceGroups/" + resourceGroupName + "/providers/Microsoft.Network/publicIPAddresses/" + externalIpName;
    }

    private AzureResourceManagerWrapper.ApplicationGatewayWrapper createApplicationGateway(LogicalLoadBalancer lb, PhysicalLoadBalancer plb) {
        VirtualNetwork virtualNetwork = lb.getVirtualNetwork();
        CloudAccount cloudAccount = virtualNetwork.getCloudAccountOrVirtualCloudAccount();
        FMSettings settings = this.fmApp.getFMSettings();
        String managedIdentityId = Optional.ofNullable(cloudAccount.getAzureManagedIdentityId()).filter(StringUtils::isNotBlank).orElseGet(() -> settings.azureSettings.managedIdentityId);
        AzureResourceManagerWrapper azureClientWrapper = this.clientService.getAzureClientWrapper(cloudAccount);
        Set<AzureResourceManagerWrapper.Resource> resources = this.buildResourceSet(lb, azureClientWrapper, true);
        String publicIpId = this.getOrCreatePublicIp(lb, plb, azureClientWrapper);
        Optional<String> keyVaultSecretIdOptional = lb.getCertificateMode() == CertificateMode.AZURE_SECRET_ID ? Optional.of(lb.getAzureCertificateSecretId()) : Optional.empty();
        return azureClientWrapper.createApplicationGateway(plb.getId(), virtualNetwork.getAzureRegion(settings), AzureUtils.getResourceGroupForCreatedResources(virtualNetwork), virtualNetwork.getAzureVnId(), virtualNetwork.getAzureSecondSubnet(), managedIdentityId, AzureUtils.getTagsWithName(lb.getName(), this.defaultKeysTagService.getCloudApplicableTags(lb)), lb.getTier(), resources, publicIpId, virtualNetwork.getHttpsStrategy() != VirtualNetwork.HTTPSStrategy.NONE, new AzureResourceManagerWrapper.CertificateConfiguration(this.getCertificateConfigId(plb.getId()), keyVaultSecretIdOptional));
    }

    private String getOrCreatePublicIp(LogicalLoadBalancer lb, PhysicalLoadBalancer plb, AzureResourceManagerWrapper azureClientWrapper) {
        return switch (lb.getPublicIpMode()) {
            case LoadBalancerPublicIPMode.STATIC_PUBLIC_IP -> {
                logger.info((Object)("Public IP address: " + lb.getAzurePublicIPID()));
                yield lb.getAzurePublicIPID();
            }
            case LoadBalancerPublicIPMode.DYNAMIC_PUBLIC_IP -> {
                logger.info((Object)"Creating IP address ");
                AzureResourceManagerWrapper.PublicIpAddressWrapper publicIPAddress = azureClientWrapper.createPublicIpAddress("ip-" + plb.getId(), lb.getVirtualNetwork().getAzureRegion(), AzureUtils.getResourceGroupForCreatedResources(lb.getVirtualNetwork()), AzureUtils.getTagsWithName(String.format("Public IP address for %s", lb.getName()), this.defaultKeysTagService.getCloudApplicableTags(lb)));
                logger.info((Object)("Public IP address: " + publicIPAddress.id() + " -> " + publicIPAddress.ipAddress()));
                plb.setAzureExternalIpId(publicIPAddress.id());
                yield publicIPAddress.id();
            }
            default -> throw new IllegalArgumentException("Unexpected public ip mode: " + String.valueOf((Object)lb.getPublicIpMode()));
        };
    }

    private Set<AzureResourceManagerWrapper.Resource> buildResourceSet(LogicalLoadBalancer lb, AzureResourceManagerWrapper azureClientWrapper, boolean activeNodesOnly) {
        return lb.getLoadBalancerNodeMappingsPerHostName(activeNodesOnly).entrySet().stream().map(entry -> new AzureResourceManagerWrapper.Resource(AzureCloudLoadBalancerService.getResourceIdForHostname((String)entry.getKey()), LoadBalancerUtils.getFQDN((String)entry.getKey(), lb, this.azureDNSService), ((Set)entry.getValue()).stream().flatMap(nodeMapping -> Stream.ofNullable(nodeMapping.getLogicalInstance().getCurrentPhysicalInstance())).flatMap(physicalInstance -> Stream.ofNullable(physicalInstance.getAzureVMInstanceId())).map(azureClientWrapper::getInstancePrivateIp).collect(Collectors.toSet()))).collect(Collectors.toSet());
    }

    private LoadBalancerDTO.PhysicalStatus mapFrom(AzureResourceManagerWrapper.ReconciliationAction reconciliationAction) {
        return switch (reconciliationAction) {
            default -> throw new IncompatibleClassChangeError();
            case AzureResourceManagerWrapper.ReconciliationAction.NO_ACTION -> LoadBalancerDTO.PhysicalStatus.PROVISIONED;
            case AzureResourceManagerWrapper.ReconciliationAction.UPDATE -> LoadBalancerDTO.PhysicalStatus.NEED_UPDATING;
            case AzureResourceManagerWrapper.ReconciliationAction.REPROVISION -> LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING;
        };
    }

    private record ApplicationGatewayUpdateData(String applicationGatewayId, Set<AzureResourceManagerWrapper.Resource> resources, Predicate<HasName> isManagedPredicate, String publicIpId, boolean areNodesHttps, AzureResourceManagerWrapper.CertificateConfiguration certificateConfiguration) {
    }

    public static enum LoadBalancerAzureCodes implements InfoMessage.MessageCode
    {
        AZURE_LB_NOT_PROVISIONED("Azure load balancer not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_CLOUD_UNAVAILABLE("Azure load balancer exists but is not available in the cloud", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_CLOUD_PARTIALLY_PROVISIONED("Azure load balancer is partially provisioned in the cloud", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_PROVISIONING("Azure load balancer is starting", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_MISSING_DNS_RECORD("Azure load balancer is missing DNS records in Azure", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_ORPHAN_DNS_RECORD("Azure load balancer has orphan DNS records in Azure", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_WRONG_DNS_RECORD("Azure load balancer has wrong DNS records in Azure", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_WRONG_NETWORK("Azure load balancer is on the WRONG network", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_ORPHAN_RESOURCES("Azure load balancer has orphan resources", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_VM_LOOKUP_FAILED("Could not retrieve VM or network information", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_PROVISIONED("Azure load balancer started", InfoMessage.FixabilityCategory.IRRELEVANT),
        LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING("Load balancer has some rules which needs to be updated.", InfoMessage.FixabilityCategory.IRRELEVANT);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private LoadBalancerAzureCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

