/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.security.sso;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.jwt.JwtVerificationService;
import com.dataiku.dip.security.sso.OpenIDHelper;
import com.dataiku.dip.security.sso.SAMLHelper;
import com.dataiku.dip.security.sso.UserMapper;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMSSOService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.sso");
    @Autowired
    private JwtVerificationService jwtVerificationService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private SAMLHelper samlHelper;
    private OpenIDHelper openIDHelper;
    private UserMapper userMapper;

    @PostConstruct
    public void postConstruct() {
        this.applySettings();
    }

    private void refreshClients(FMSettings fmSettings) {
        try {
            this.samlHelper = null;
            this.openIDHelper = null;
            this.userMapper = null;
            if (fmSettings.ssoSettings.enabled) {
                this.userMapper = new UserMapper(fmSettings.ssoSettings);
                switch (fmSettings.ssoSettings.protocol) {
                    case SAML: {
                        logger.info((Object)"Initializing SAML login client");
                        this.samlHelper = new SAMLHelper(fmSettings.ssoSettings, this.passwordEncryptionService);
                        break;
                    }
                    case OPENID: {
                        logger.info((Object)"Initializing OpenID login client");
                        this.openIDHelper = new OpenIDHelper(fmSettings.ssoSettings, this.jwtVerificationService, this.passwordEncryptionService, fmSettings.proxySettings);
                        break;
                    }
                    case SPNEGO: {
                        logger.error((Object)"SPNEGO is not supported");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("SSO protocol " + String.valueOf(fmSettings.ssoSettings.protocol) + " mis-configured. Go to /login/ to fix the SSO settings"), (Throwable)e);
        }
    }

    public OpenIDHelper openid() {
        if (this.openIDHelper == null) {
            throw new IllegalStateException("OpenID should be setup at this point. Please verify your SSO settings.");
        }
        return this.openIDHelper;
    }

    public SAMLHelper saml() {
        if (this.samlHelper == null) {
            throw new IllegalStateException("SAML should be setup at this point. Please verify your SSO settings.");
        }
        return this.samlHelper;
    }

    public UserMapper userMapper() {
        if (this.userMapper == null) {
            throw new IllegalStateException("User mapping should be setup at this point. Please verify your SSO settings.");
        }
        return this.userMapper;
    }

    public void applySettings() {
        this.refreshClients(FMApp.getFMSettingsUnsafe());
    }
}

