/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.alerts;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.CheckDefinition;
import com.dataiku.fm.model.db.CheckElementType;
import com.dataiku.fm.model.db.CheckReporter;
import com.dataiku.fm.model.db.ElementCheck;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CheckDefinitionDTO;
import com.dataiku.fm.model.published.ProtoCheckDefinition;
import com.dataiku.fm.server.alerts.AlertingDBService;
import com.dataiku.fm.server.alerts.AlertingUtils;
import com.dataiku.fm.server.alerts.CheckDefinitionService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.utils.APIInputValidator;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CheckDefinitionCRUDService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.alerting.checkDefinitionCRUDService");
    private static final String MSG_TENANT_ID_MISSING = "The tenant ID is missing.";
    private static final String MSG_CHECK_DEFINITION_CONFIGURATION_EMPTY = "The supplied check definition configuration is empty.";
    private static final String MSG_INCORRECT_JSON_SYNTAX_ERROR = "The JSON structure of the configuration supplied for a check definition does not match this alert group type.";
    private static final String MSG_INVALID_CHECK_DEFINITION_TYPE = "The type of one check definition is invalid";
    private static final String MSG_CHECK_TYPE_DOES_NOT_EXIST = "The supplied check type does not exist";
    private static final String MSG_CHECK_DEFINITION_CONFIGURATION_NULL = "The configuration associated with a check definition cannot be null.";
    private static final String MSG_CHECK_DEFINITIONS_EMPTY = "The supplied check definitions configuration is empty";
    @Autowired
    private AlertingDBService dbService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private CheckDefinitionService checkDefinitionService;

    private CheckDefinition create(Tenant tenant, ProtoCheckDefinition protoCheckDefinition, DatabaseAccessService.ReadWriteTransaction rwt) {
        this.validateProto(protoCheckDefinition, true);
        CheckDefinition checkDefinition = new CheckDefinition();
        checkDefinition.setTenant(tenant);
        checkDefinition.setType(protoCheckDefinition.type);
        this.setDefaultedProperties(protoCheckDefinition, checkDefinition);
        this.setSanitizedConfiguration(protoCheckDefinition, checkDefinition);
        String newId = "cd-" + SecretKeyGenerator.generate((int)12);
        checkDefinition.setId(newId);
        rwt.getThreadEM().persist((Object)checkDefinition);
        this.validateAndSetCheckReporters(checkDefinition, tenant.getId(), protoCheckDefinition.checkReporterIds, rwt);
        List<LogicalInstance> provisionedInstances = this.instancesCRUDService.listInternal(tenant.getId()).stream().filter(i -> i.getCurrentPhysicalInstance() != null).toList();
        for (LogicalInstance instance : provisionedInstances) {
            this.persistElementCheckForInstance(rwt, instance.getId(), checkDefinition);
        }
        return checkDefinition;
    }

    private void validateInput(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
    }

    private void validateProto(ProtoCheckDefinition protoCheckDefinition, boolean validateImmutableFields) {
        APIInputValidator.checkNotNull(protoCheckDefinition, MSG_CHECK_DEFINITION_CONFIGURATION_EMPTY, new Object[0]);
        if (validateImmutableFields) {
            APIInputValidator.checkNotNull((Object)protoCheckDefinition.type, MSG_CHECK_TYPE_DOES_NOT_EXIST, new Object[0]);
        }
        APIInputValidator.checkNotEmpty(protoCheckDefinition.configuration, MSG_CHECK_DEFINITION_CONFIGURATION_NULL, new Object[0]);
    }

    private void setDefaultedProperties(ProtoCheckDefinition protoCheckDefinition, CheckDefinition checkDefinition) {
        if (protoCheckDefinition.gracePeriodInSec != null) {
            checkDefinition.setGracePeriodInSec(protoCheckDefinition.gracePeriodInSec);
        }
        if (protoCheckDefinition.resendNotificationPeriodInSec != null) {
            checkDefinition.setResendNotificationPeriodInSec(protoCheckDefinition.resendNotificationPeriodInSec);
        }
    }

    private void setSanitizedConfiguration(ProtoCheckDefinition protoCheckDefinition, CheckDefinition checkDefinition) {
        checkDefinition.setConfigurationVersion(AlertingUtils.getCheckDefinitionConfigurationDefaultVersion(checkDefinition.getType()));
        try {
            checkDefinition.setConfiguration(this.checkDefinitionService.getChecker(checkDefinition.getType(), checkDefinition.getConfigurationVersion()).sanitizeConfiguration(protoCheckDefinition.configuration));
        }
        catch (JsonSyntaxException e) {
            logger.errorV((Throwable)e, MSG_INCORRECT_JSON_SYNTAX_ERROR, new Object[0]);
            APIInputValidator.throwInvalidArgumentException(MSG_INCORRECT_JSON_SYNTAX_ERROR, new Object[0]);
        }
    }

    private void validateAndSetCheckReporters(CheckDefinition checkDefinition, String tenantId, List<String> checkReporterIds, DatabaseAccessService.ReadWriteTransaction rwt) {
        APIInputValidator.checkListNotEmpty(checkReporterIds, "There should be at least a check reporter associated to the check definition.", new Object[0]);
        List<CheckReporter> checkReporters = this.dbService.getMultipleCheckReporters(tenantId, checkReporterIds);
        if (checkReporters.size() < checkReporterIds.size()) {
            APIInputValidator.throwInvalidArgumentException("At least one of the specified check reporters does not exist.", new Object[0]);
        }
        checkDefinition.setCheckReporters(new HashSet<CheckReporter>(checkReporters));
        for (CheckReporter checkReporter : checkDefinition.getCheckReporters()) {
            checkReporter.getCheckDefinitions().add(checkDefinition);
            rwt.getThreadEM().merge((Object)checkReporter);
        }
    }

    private void persistElementCheckForInstance(DatabaseAccessService.ReadWriteTransaction rwt, String logicalInstanceId, CheckDefinition checkDefinition) {
        ElementCheck elementCheck = new ElementCheck();
        elementCheck.setId("ec-" + SecretKeyGenerator.generate((int)12));
        elementCheck.setCheckDefinition(checkDefinition);
        elementCheck.setElementType(CheckElementType.LOGICAL_INSTANCE);
        elementCheck.setElementId(logicalInstanceId);
        elementCheck.setLastStatusChangeTimestamp(System.currentTimeMillis());
        elementCheck.setLastKoNotificationTimestamp(System.currentTimeMillis());
        rwt.getThreadEM().persist((Object)elementCheck);
    }

    protected CheckDefinitionDTO convertToDTO(CheckDefinition checkDefinition) {
        CheckDefinitionDTO checkDefinitionDTO = new CheckDefinitionDTO();
        checkDefinitionDTO.id = checkDefinition.getId();
        checkDefinitionDTO.type = checkDefinition.getType();
        checkDefinitionDTO.checkReporterIds = checkDefinition.getCheckReporters().stream().map(CheckReporter::getId).collect(Collectors.toList());
        checkDefinitionDTO.gracePeriodInSec = checkDefinition.getGracePeriodInSec();
        checkDefinitionDTO.resendNotificationPeriodInSec = checkDefinition.getResendNotificationPeriodInSec();
        checkDefinitionDTO.configuration = checkDefinition.getConfiguration();
        checkDefinitionDTO.configurationVersion = checkDefinition.getConfigurationVersion();
        return checkDefinitionDTO;
    }

    public CheckDefinitionDTO upsert(String tenantId, ProtoCheckDefinition protoCheckDefinition) {
        this.validateInput(tenantId);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CheckDefinition checkDefinition = this.upsert(tenant, protoCheckDefinition, rwt);
            rwt.commit();
            CheckDefinitionDTO checkDefinitionDTO = this.convertToDTO(checkDefinition);
            return checkDefinitionDTO;
        }
    }

    private CheckDefinition upsert(Tenant tenant, ProtoCheckDefinition protoCheckDefinition, DatabaseAccessService.ReadWriteTransaction rwt) {
        this.validateProto(protoCheckDefinition, false);
        CheckDefinition checkDefinition = this.dbService.getSingleCheckDefinition(tenant.getId(), protoCheckDefinition.id);
        if (checkDefinition == null) {
            return this.create(tenant, protoCheckDefinition, rwt);
        }
        checkDefinition.setTenant(tenant);
        checkDefinition.setType(protoCheckDefinition.type);
        this.setDefaultedProperties(protoCheckDefinition, checkDefinition);
        this.setSanitizedConfiguration(protoCheckDefinition, checkDefinition);
        this.validateAndSetCheckReporters(checkDefinition, tenant.getId(), protoCheckDefinition.checkReporterIds, rwt);
        rwt.getThreadEM().merge((Object)checkDefinition);
        return checkDefinition;
    }

    public CheckDefinitionDTO get(String tenantId, String checkDefinitionId) {
        APIInputValidator.checkNotBlank(checkDefinitionId, "The check definition ID is missing", new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        CheckDefinition checkDefinition = this.dbService.getSingleCheckDefinition(tenantId, checkDefinitionId);
        return checkDefinition != null ? this.convertToDTO(checkDefinition) : null;
    }

    public void delete(String tenantId, String checkDefinitionId) {
        APIInputValidator.checkNotBlank(checkDefinitionId, "The check definition ID is missing", new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CheckDefinition checkDefinition = this.dbService.getSingleCheckDefinition(tenantId, checkDefinitionId);
            if (checkDefinition != null) {
                this.delete(checkDefinition, rwt);
                rwt.commit();
            }
        }
    }

    private void delete(CheckDefinition checkDefinition, DatabaseAccessService.ReadWriteTransaction rwt) {
        for (CheckReporter checkReporter : checkDefinition.getCheckReporters()) {
            checkReporter.getCheckDefinitions().remove(checkDefinition);
            rwt.getThreadEM().merge((Object)checkReporter);
        }
        List<ElementCheck> elementChecks = this.dbService.getAllElementChecksForCheckDefinition(checkDefinition.getId());
        for (ElementCheck elementCheck : elementChecks) {
            rwt.getThreadEM().remove((Object)elementCheck);
        }
        rwt.getThreadEM().remove((Object)checkDefinition);
    }

    public List<CheckDefinitionDTO> bulkCreate(String tenantId, List<ProtoCheckDefinition> protoCheckDefinitions) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotNull(protoCheckDefinitions, MSG_CHECK_DEFINITIONS_EMPTY, new Object[0]);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        ArrayList<CheckDefinition> checkDefinitions = new ArrayList<CheckDefinition>();
        if (protoCheckDefinitions.isEmpty()) {
            return new ArrayList<CheckDefinitionDTO>();
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            for (ProtoCheckDefinition protoCheckDefinition : protoCheckDefinitions) {
                APIInputValidator.checkNotNull((Object)protoCheckDefinition.type, MSG_INVALID_CHECK_DEFINITION_TYPE, new Object[0]);
                CheckDefinition checkDefinition = this.create(tenant, protoCheckDefinition, rwt);
                checkDefinitions.add(checkDefinition);
            }
            rwt.commit();
        }
        return this.convertToDTO(checkDefinitions);
    }

    public List<CheckDefinitionDTO> bulkUpsert(String tenantId, List<ProtoCheckDefinition> protoCheckDefinitions, DatabaseAccessService.ReadWriteTransaction rwt) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        APIInputValidator.checkNotNull(protoCheckDefinitions, MSG_CHECK_DEFINITIONS_EMPTY, new Object[0]);
        Tenant tenant = this.dbService.getMandatoryTenant(tenantId);
        ArrayList<CheckDefinition> checkDefinitions = new ArrayList<CheckDefinition>();
        List<CheckDefinition> existingCheckDefinitions = this.dbService.getAllCheckDefinitions(tenantId);
        Set protoCheckDefinitionIds = protoCheckDefinitions.stream().map(protoCheckDefinition -> protoCheckDefinition.id).collect(Collectors.toSet());
        for (CheckDefinition existingCheckDefinition : existingCheckDefinitions) {
            if (protoCheckDefinitionIds.contains(existingCheckDefinition.getId())) continue;
            this.delete(existingCheckDefinition, rwt);
        }
        for (ProtoCheckDefinition protoCheckDefinition2 : protoCheckDefinitions) {
            APIInputValidator.checkNotNull((Object)protoCheckDefinition2.type, MSG_INVALID_CHECK_DEFINITION_TYPE, new Object[0]);
            CheckDefinition checkDefinition = this.upsert(tenant, protoCheckDefinition2, rwt);
            checkDefinitions.add(checkDefinition);
        }
        return this.convertToDTO(checkDefinitions);
    }

    public void bulkDelete(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        this.dbService.getMandatoryTenant(tenantId);
        List<CheckDefinition> checkDefinitions = this.dbService.getAllCheckDefinitions(tenantId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            for (CheckDefinition checkDefinition : checkDefinitions) {
                this.delete(checkDefinition, rwt);
            }
            rwt.commit();
        }
    }

    private List<CheckDefinitionDTO> convertToDTO(List<CheckDefinition> checkDefinitions) {
        ArrayList<CheckDefinitionDTO> checkDefinitionsDTO = new ArrayList<CheckDefinitionDTO>();
        if (checkDefinitions == null || checkDefinitions.isEmpty()) {
            return checkDefinitionsDTO;
        }
        for (CheckDefinition checkDefinition : checkDefinitions) {
            checkDefinitionsDTO.add(this.convertToDTO(checkDefinition));
        }
        return checkDefinitionsDTO;
    }

    public List<CheckDefinitionDTO> list(String tenantId) {
        APIInputValidator.checkNotBlank(tenantId, MSG_TENANT_ID_MISSING, new Object[0]);
        List<CheckDefinition> checkDefinitions = this.dbService.getAllCheckDefinitions(tenantId);
        return checkDefinitions.stream().map(this::convertToDTO).collect(Collectors.toList());
    }

    public void onAfterInstanceProvision(String tenantId, String logicalInstanceId) {
        List<CheckDefinition> checkDefinitions = this.dbService.getAllCheckDefinitions(tenantId);
        List<ElementCheck> elementChecks = this.dbService.getAllElementChecksForLogicalInstance(logicalInstanceId);
        Map<String, List<ElementCheck>> elementCheckByCheckDefinitionId = elementChecks.stream().collect(Collectors.groupingBy(elementCheck -> elementCheck.getCheckDefinition().getId()));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            for (CheckDefinition checkDefinition : checkDefinitions) {
                if (!CollectionUtils.isEmpty((Collection)elementCheckByCheckDefinitionId.get(checkDefinition.getId()))) continue;
                this.persistElementCheckForInstance(rwt, logicalInstanceId, checkDefinition);
            }
            rwt.commit();
        }
    }

    public void onAfterInstanceDeprovision(String logicalInstanceId) {
        List<ElementCheck> elementChecks = this.dbService.getAllElementChecksForLogicalInstance(logicalInstanceId);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            for (ElementCheck elementCheck : elementChecks) {
                rwt.getThreadEM().remove((Object)elementCheck);
            }
            rwt.commit();
        }
    }
}

