/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.WildcardFileFilter;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.Diagnosis;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiagnosisService {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private static final String DIAGNOSIS_FILE_PREFIX = "diagnosis-";
    private static final String DIAGNOSIS_FILE_SUFFIX = ".zip";
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private DatabaseAccessService dbService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.maintenance");

    public FutureResponse<Diagnosis> startDiagnosis(FMAuthCtx authCtx) throws Exception {
        return this.futureService.runFuture(new GenerateDiagnosisThead(this.dbService, authCtx), 0L, (TypeToken)new TypeToken<FutureResponse<Diagnosis>>(){});
    }

    public Map<String, Diagnosis> getDiagnoses() {
        WildcardFileFilter filter = new WildcardFileFilter("*.zip");
        return Optional.ofNullable(FMApp.getFile((String)"diagnoses").listFiles((FileFilter)filter)).map(a -> Arrays.stream(a).map(f -> {
            String name = f.getName().replace(DIAGNOSIS_FILE_SUFFIX, "");
            try {
                return new Diagnosis(name, dateFormat.parse(name.replace(DIAGNOSIS_FILE_PREFIX, "")), (File)f);
            }
            catch (ParseException e) {
                logger.warn((Object)("Couldn't parse the date in the diagnosis name '" + name + "', putting the date as epoc=0."), (Throwable)e);
                return new Diagnosis(name, new Date(0L), (File)f);
            }
        }).collect(Collectors.toMap(Diagnosis::getName, Function.identity()))).orElse(Collections.emptyMap());
    }

    public Diagnosis checkDiagnosisExist(String diagnosisName) {
        Map<String, Diagnosis> diagnoses = this.getDiagnoses();
        if (!diagnoses.containsKey(diagnosisName)) {
            throw new IllegalArgumentException("Diagnosis doesn't exist.");
        }
        return diagnoses.get(diagnosisName);
    }

    public static class GenerateDiagnosisThead
    extends SimpleFMFutureThread<Diagnosis> {
        public GenerateDiagnosisThead(DatabaseAccessService dbService, FMAuthCtx owner) {
            super(dbService, owner, "startDiagnosis");
        }

        @Override
        protected Diagnosis compute() throws Exception {
            Date now = new Date();
            String diagnosisName = DiagnosisService.DIAGNOSIS_FILE_PREFIX + dateFormat.format(now);
            String diagnosisFileName = diagnosisName + DiagnosisService.DIAGNOSIS_FILE_SUFFIX;
            String homeDir = System.getenv("DIP_HOME");
            String diagnosisFilePath = homeDir + "/diagnoses/" + diagnosisFileName;
            DKUtils.execAndLog((String[])new String[]{"mkdir", homeDir + "/diagnoses/"}, System.getenv());
            int result = DKUtils.execAndLog((String[])new String[]{homeDir + "/bin/fmadmin", "run-diagnosis", "-c", "-f", "-l", "-i", "-v", "-s", "-d", diagnosisFilePath}, System.getenv());
            if (result == 0) {
                File diagnosisFile = new File(diagnosisFilePath);
                return new Diagnosis(diagnosisName, now, diagnosisFile);
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)FMServerCodes.ERR_DIAGNOSIS, "FM diagnosis failed. No zip was generated.");
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"generate_diag", (String)"Generating diagnosis");
        }
    }
}

