/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class FMFuturesController
extends DIPInternalControllerBase {
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.fm.futures");

    @AuditNotNeeded
    @RequestMapping(value={"/api/ui/futures/get-update"})
    public void getUpdate(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        FutureResponse update = this.futureService.getUpdate(futureId);
        FMFuturesController.writeJSON((HttpServletResponse)resp, (Object)update);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/ui/futures/peek-update"})
    public void peekUpdate(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        FutureResponse update = this.futureService.getProgress(futureId);
        if (update == null) {
            update = new FutureResponse();
            update.unknown = true;
        }
        FMFuturesController.writeJSON((HttpServletResponse)resp, update);
    }

    @AuditedCall(value={"msgType", "future-abort", "futureId", "${futureId}"})
    @RequestMapping(value={"/api/ui/futures/abort"})
    public void abort(HttpServletRequest req, HttpServletResponse resp, String futureId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        this.futureService.abort(futureId, authCtx);
    }
}

