/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.license.License;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.agent.ExpandedInstanceSettings;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.instances.JSonHelper;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstancesCRUDService {
    private final DatabaseAccessService dbService;
    private final CloudCryptoService cryptoService;
    private final InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances");

    @Autowired
    public InstancesCRUDService(DatabaseAccessService dbService, CloudCryptoService cryptoService, InstanceAgentActionsQueueService instanceAgentActionsQueueService) {
        this.dbService = dbService;
        this.cryptoService = cryptoService;
        this.instanceAgentActionsQueueService = instanceAgentActionsQueueService;
    }

    public List<LogicalInstance> listInternal(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        return this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1", tenant);
    }

    public LogicalInstance getInternal(String tenantId, String instanceId) {
        return this.getLogicalInstanceMand(tenantId, instanceId);
    }

    public boolean updateEncryption(LogicalInstance li, Tenant current, Tenant updated) {
        String key = li.getSslCertificateKeyPEM();
        if (StringUtils.isNotEmpty((String)key)) {
            String plainKey;
            String string = plainKey = this.cryptoService.isAbleToEncrypt(current) ? this.cryptoService.decrypt(current, key) : key;
            if (this.cryptoService.isAbleToEncrypt(updated)) {
                li.setSslCertificateKeyPEM(this.cryptoService.encrypt(updated, plainKey));
            } else {
                li.setSslCertificateKeyPEM(plainKey);
            }
            return true;
        }
        return false;
    }

    public ExpandedInstanceSettings getExpandedInstanceSettings(String tenantId, String instanceId) {
        ExpandedInstanceSettings ret = new ExpandedInstanceSettings();
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        if (li.getInstanceSettingsTemplate() != null) {
            InstanceSettingsTemplate instanceSettingsTemplate = li.getInstanceSettingsTemplate();
            ret.setupActions = InstancesCRUDService.filterEnabledActions(JSonHelper.parseJsonSetupActions(instanceSettingsTemplate.getSetupActions()));
            ret.setupActions.addAll(0, InstanceSettingsTemplateCRUDService.getHiddenSetupActions(li.getDssNodeType()));
            if (ret.setupActions.stream().noneMatch(t -> t.type.equals((Object)SetupAction.SetupActionType.SETUP_K8S_AND_SPARK))) {
                ret.setupActions.add(new SetupAction(SetupAction.SetupActionType.SETUP_NONE_K8S_AND_SPARK));
            }
        }
        return ret;
    }

    private static SetupAction.SetupActionList filterEnabledActions(SetupAction.SetupActionList setupActionList) {
        return setupActionList.stream().filter(action -> action.enabled).collect(SetupAction.SetupActionList::new, ArrayList::add, ArrayList::addAll);
    }

    public String getSSLCertificateKey(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        if (li.getSslCertificateKeyStorageMode() != LogicalInstance.CustomCertificateKeyStorageMode.INLINE_ENCRYPTED) {
            throw new IllegalArgumentException("There is no certificate key to retrieve, storage mode is not FM encryption.");
        }
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        return this.cryptoService.decrypt(tenant, li.getSslCertificateKeyPEM());
    }

    public InstanceLicense getLicense(String tenantId, String instanceId) {
        Sublicense sl;
        logger.info((Object)("getting license for " + tenantId + "." + instanceId));
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        InstanceLicense ret = new InstanceLicense();
        if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getLicense())) {
            ret.license = li.getInstanceSettingsTemplate().getLicense();
        } else if (li.getTenant().getLicenseMode() != Tenant.LicenseMode.NONE && StringUtils.isNotBlank((String)li.getTenant().getLicense())) {
            ret.license = li.getTenant().getLicense();
        }
        boolean bl = ret.hasLicense = !StringUtils.isBlank((String)ret.license);
        if (ret.hasLicense && li.getLicenseSelectionMode() == LogicalInstance.InstanceLicenseSelectionMode.EXPLICIT_SUBLICENSE && (sl = li.getSublicense()) != null && sl.getSublicense() != null) {
            ret.usesSublicense = true;
            ret.sublicenseId = sl.getId();
            ret.sublicenseLabel = sl.getLabel();
            License licenseObj = (License)JSON.parse((String)ret.license, License.class);
            licenseObj.sublicense = (JsonObject)JSON.parse((String)sl.getSublicense(), JsonObject.class);
            ret.license = JSON.pretty((Object)licenseObj);
            logger.info((Object)("Applied sublicense " + JSON.json((Object)licenseObj.sublicense)));
        }
        return ret;
    }

    public PhysicalInstanceCreationState createStateSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        PhysicalInstanceCreationState pics = new PhysicalInstanceCreationState();
        pics.setCloudInstanceType(li.getCloudInstanceType());
        pics.setImageId(li.getImageId());
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        if (ist != null) {
            InstanceSettingsTemplate istSnapshot = ist.copyWithoutId();
            istSnapshot.setId("ist-snap-" + SecretKeyGenerator.generate((int)12));
            istSnapshot.setLabel(String.format("Snapshot of %s at %s", ist.getLabel(), DKUDateUtils.isoFormatLocalNow()));
            istSnapshot.setCopiedFromId(ist.getId());
            istSnapshot.setForSnapshot(true);
            rwt.getThreadEM().persist((Object)istSnapshot);
            pics.setInstanceSettingsTemplate(istSnapshot);
        }
        return pics;
    }

    public FutureResponse<JsonObject> fetchAgentLogs(FMAuthCtx authCtx, String instanceId) throws Exception {
        PhysicalInstance pi = this.getPhysicalInstanceMand(authCtx.getTenantId(), instanceId);
        PhysicalInstance.LifecycleStage lifecycleStage = pi.getLifecycleStage();
        if (lifecycleStage != PhysicalInstance.LifecycleStage.RUNNING && lifecycleStage != PhysicalInstance.LifecycleStage.NOT_RESPONDING && lifecycleStage != PhysicalInstance.LifecycleStage.FAILED) {
            throw new IllegalStateException("Agent on this instance is not ready and cannot send its logs");
        }
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.SEND_LOGS;
        return this.instanceAgentActionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac);
    }

    public File getAgentLogFile(String tenantId, String instanceId) {
        PhysicalInstance pi = this.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Read agent logs tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
        File agentLogFilesDirectory = this.getAgentLogDirectory(tenantId, instanceId, pi.getId());
        if (!agentLogFilesDirectory.exists() || !agentLogFilesDirectory.isDirectory()) {
            logger.infoV("No logs found for tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
            return null;
        }
        return DKUFileUtils.newestByNameFile((File)agentLogFilesDirectory, (String)"^agent_logs_.*\\.log$");
    }

    public void saveAgentLogs(String tenantId, String instanceId, InputStream inputStream) throws IOException {
        PhysicalInstance pi = this.getPhysicalInstanceMand(tenantId, instanceId);
        logger.infoV("Save agent logs tenantId=%s liId=%s phId=%s", new Object[]{tenantId, instanceId, pi.getId()});
        String agentFilename = "agent_logs_" + System.currentTimeMillis() + ".log";
        File agentLogDirectory = this.getAgentLogDirectory(tenantId, instanceId, pi.getId());
        File agentLogFile = new File(agentLogDirectory, agentFilename);
        DKUFileUtils.mkdirs((File)agentLogFile.getParentFile());
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)agentLogFile);
        if (!DKUApp.getParams().getBoolParam("dku.agent.logs.purge.enabled", true)) {
            logger.info((Object)"Agent logs purge disabled by configuration, skipping");
            return;
        }
        long purgeThreshold = DKUApp.getParams().getLongParam("dku.agent.logs.purge.maxSize", 0xC800000L);
        DKUFileUtils.compressAndKeepLastFilesUpToSize((File)agentLogDirectory, (String)"agent_logs_", (String)".log", (long)purgeThreshold, (String)agentFilename);
    }

    private File getAgentLogDirectory(String tenantId, String instanceId, String physicalInstanceId) {
        return FMApp.getFile((String[])new String[]{"tmp", "agent-logs", instanceId, physicalInstanceId});
    }

    public AWSKeypair getDataikuAwsKeypair(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        assert (li.getInstanceSettingsTemplate().getDataikuAwsKeypairStorageMode() == InstanceSettingsTemplate.DataikuAWSKeypairStorageMode.INLINE_ENCRYPTED);
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT tn from tenant tn where tn.id=?1", tenantId);
        AWSKeypair ret = new AWSKeypair();
        ret.awsAccessKeyId = li.getInstanceSettingsTemplate().getDataikuAwsAccessKeyId();
        ret.awsSecretAccessKey = this.cryptoService.decrypt(tenant, li.getInstanceSettingsTemplate().getDataikuAwsSecretAccessKey());
        return ret;
    }

    public AdminAPIKey getAdminAPIKey(String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(this.dbService, tenantId, instanceId);
        AdminAPIKey ret = new AdminAPIKey();
        ret.adminAPIKey = this.cryptoService.decrypt(li.getTenant(), li.getPossiblyEncryptedAdminAPIKey());
        return ret;
    }

    public PhysicalInstance getPhysicalInstanceMand(String tenantId, String instanceId) {
        PhysicalInstance pi = this.getPhysicalInstance(tenantId, instanceId);
        if (pi == null) {
            throw new IllegalStateException(String.format("No physical instance attached to instance %s.%s", tenantId, instanceId));
        }
        return pi;
    }

    public PhysicalInstance getPhysicalInstance(String tenantId, String instanceId) {
        LogicalInstance li = this.getLogicalInstanceMand(tenantId, instanceId);
        return this.dbService.getSingleResult(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.logicalInstance=?1", li);
    }

    public LogicalInstance getLogicalInstanceMand(String tenantId, String instanceId) {
        LogicalInstance li = InstancesHelper.getInstance(this.dbService, tenantId, instanceId);
        if (li == null) {
            throw new IllegalStateException(String.format("Unknown or missing logical instance: %s.%s", tenantId, instanceId));
        }
        return li;
    }

    private String arrayToStringCleaned(List<String> array) {
        if (array == null) {
            return null;
        }
        ListIterator<String> listIterator = array.listIterator();
        while (listIterator.hasNext()) {
            String next = listIterator.next();
            if (!StringUtils.isBlank((String)next)) continue;
            listIterator.remove();
        }
        return array.isEmpty() ? null : JSON.json(array);
    }

    public void checkIfInstanceCreatedAndLabelChanges(String tenantId, String instanceId, String instanceLabel) throws CodedException {
        LogicalInstance existingInstance = this.listInternal(tenantId).stream().filter(p -> p.getId().equals(instanceId)).findFirst().orElse(null);
        if (existingInstance != null && !existingInstance.getLabel().equals(instanceLabel)) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_LABEL_CHANGE, "You cannot change the instance label once the instance has been created.");
        }
    }

    public void checkIfExternalURLIsValid(String externalURL) throws CodedException {
        String externalURLPattern = "^(http|https)://.*$";
        if (StringUtils.isNotBlank((String)externalURL) && !externalURL.matches(externalURLPattern)) {
            throw new CodedException((InfoMessage.MessageCode)FMServerCodes.ERR_INVALID_EXTERNAL_URL, "External URL needs to start with http(s)://.");
        }
    }

    public static class InstanceLicense {
        public boolean hasLicense;
        public String license;
        public boolean usesSublicense;
        public String sublicenseId;
        public String sublicenseLabel;
    }

    public static class AWSKeypair {
        public String awsAccessKeyId;
        public String awsSecretAccessKey;
    }

    public static class AdminAPIKey {
        public String adminAPIKey;
    }
}

