/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudLoadBalancerService;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.LoadBalancerUtils;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class NodesDirectoryUpdateService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private VirtualNetworksService virtualNetworksService;
    @Autowired
    private PhysicalInstanceProvisioningService provisioningService;
    @Autowired
    private InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    @Autowired
    private LoadBalancersCRUDService loadBalancersCRUDService;
    @Autowired
    private CloudLoadBalancerService cloudLoadBalancerService;
    @Autowired
    private DNSservice dnsService;
    @Autowired
    private CloudCryptoService cryptoService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.directory");

    public NodesDirectory getCurrentNodesDirectory(String tenantId, String virtualNetworkId) {
        logger.infoV("Generating nodes directory for tenant=%s network=%s", new Object[]{tenantId, virtualNetworkId});
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        NodesDirectory directory = new NodesDirectory();
        VirtualNetwork vn = this.virtualNetworksService.getVirtualNetworkMandatory(tenant, virtualNetworkId);
        List<LogicalInstance> logicalInstances = this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant=?1 and li.virtualNetwork.id=?2", tenant, virtualNetworkId);
        if (vn.isManagedNodesDirectory()) {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                boolean added = false;
                for (LogicalInstance logicalInstance : logicalInstances) {
                    if (logicalInstance.getPossiblyEncryptedEventServerAuthKey() != null) continue;
                    logger.info((Object)("Generating event server auth key for instance " + logicalInstance.getId()));
                    added = true;
                    if (this.cryptoService.isAbleToEncrypt(logicalInstance.getTenant())) {
                        logicalInstance.setEventServerAuthKey(this.cryptoService.encrypt(logicalInstance.getTenant(), SecretKeyGenerator.generate((int)12)));
                    } else {
                        logicalInstance.setEventServerAuthKey(SecretKeyGenerator.generate((int)12));
                    }
                    rwt.getThreadEM().persist((Object)logicalInstance);
                }
                if (added) {
                    rwt.commit();
                }
            }
        }
        directory.enabled = vn.isManagedNodesDirectory();
        directory.eventServerNodeId = vn.getEventServerNodeLabel();
        directory.governNodeId = vn.getGovernServerNodeLabel();
        for (LogicalInstance li : logicalInstances) {
            NodesDirectory.NodeRef nr = new NodesDirectory.NodeRef();
            nr.nodeId = li.getLabel();
            if (StringUtils.equals((String)nr.nodeId, (String)directory.eventServerNodeId)) {
                nr.configureEventServer = true;
            }
            switch (li.getDssNodeType()) {
                case "design": {
                    nr.nodeType = NodesDirectory.NodeType.DSS_DESIGN;
                    if (vn.getNodesDirectoryDeployerMode() != VirtualNetwork.NodesDirectoryDeployerMode.EACH_DESIGN_NODE) break;
                    nr.configureDeployerServer = true;
                    break;
                }
                case "automation": {
                    nr.nodeType = NodesDirectory.NodeType.DSS_EXECUTION;
                    nr.singleNodeAsInfrastructure = li.getSingleNodeAsInfrastructure();
                    break;
                }
                case "deployer": {
                    nr.configureDeployerServer = true;
                    if (vn.getNodesDirectoryDeployerMode() == VirtualNetwork.NodesDirectoryDeployerMode.CENTRAL_DEPLOYER) {
                        if (directory.remoteDeployerNodeId != null) {
                            logger.warn((Object)("There is already a deployer in this virtual network: " + directory.remoteDeployerNodeId));
                        }
                        directory.remoteDeployerNodeId = nr.nodeId;
                    }
                    nr.nodeType = NodesDirectory.NodeType.DSS_DEPLOYER;
                    break;
                }
                case "govern": {
                    nr.nodeType = NodesDirectory.NodeType.GOVERN;
                    break;
                }
                default: {
                    logger.warn((Object)("Unknown DSS node type " + li.getDssNodeType()));
                }
            }
            PublicPhysicalInstanceStatus publicPhysicalInstanceStatus = this.provisioningService.getStatus(tenantId, li.getId());
            if (publicPhysicalInstanceStatus.stage == null) {
                nr.status = NodesDirectory.NodeStatus.NOT_PROVISIONED;
            } else {
                switch (publicPhysicalInstanceStatus.stage) {
                    case INITIALIZING: 
                    case WAITING_AGENT: 
                    case DSS_STARTING_UP: {
                        nr.status = NodesDirectory.NodeStatus.STARTING;
                        break;
                    }
                    case RUNNING: {
                        nr.status = NodesDirectory.NodeStatus.RUNNING;
                        break;
                    }
                    case NOT_RESPONDING: {
                        nr.status = NodesDirectory.NodeStatus.NOT_RESPONDING;
                        break;
                    }
                    case FAILED: {
                        nr.status = NodesDirectory.NodeStatus.IN_ERROR;
                    }
                }
            }
            if (publicPhysicalInstanceStatus.stage == PhysicalInstance.LifecycleStage.RUNNING || publicPhysicalInstanceStatus.stage == PhysicalInstance.LifecycleStage.NOT_RESPONDING) {
                boolean isPrivateDefined = StringUtils.isNotBlank((String)publicPhysicalInstanceStatus.privateURL);
                boolean isPublicDefined = StringUtils.isNotBlank((String)publicPhysicalInstanceStatus.publicURL);
                if (isPrivateDefined) {
                    nr.url = publicPhysicalInstanceStatus.privateURL;
                } else if (isPublicDefined) {
                    nr.url = publicPhysicalInstanceStatus.publicURL;
                }
                if (isPublicDefined) {
                    nr.externalUrl = publicPhysicalInstanceStatus.publicURL;
                } else if (isPrivateDefined) {
                    nr.externalUrl = publicPhysicalInstanceStatus.privateURL;
                }
                nr.adminAPIKey = this.cryptoService.decrypt(li.getTenant(), li.getPossiblyEncryptedAdminAPIKey());
            }
            if (li.getPossiblyEncryptedEventServerAuthKey() != null) {
                nr.eventServerAuthKey = this.cryptoService.decrypt(li.getTenant(), li.getPossiblyEncryptedEventServerAuthKey());
            }
            directory.nodes.add(nr);
        }
        for (LogicalLoadBalancer loadBalancer : this.loadBalancersCRUDService.listInternal(vn)) {
            if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) continue;
            NodesDirectory.LoadBalancerRef loadBalancerRef = new NodesDirectory.LoadBalancerRef();
            loadBalancerRef.id = loadBalancer.getName();
            loadBalancerRef.link = this.cloudLoadBalancerService.getLoadBalancerLink(loadBalancer);
            for (LoadBalancerNodeMapping nodeMapping : loadBalancer.getLoadBalancerNodeMapping()) {
                Optional<LogicalInstance> node = logicalInstances.stream().filter(instance -> Objects.equals(instance.getId(), nodeMapping.getLogicalInstance().getId())).findFirst();
                if (node.isEmpty()) {
                    logger.errorV("Instance instanceId=%s referenced by load balancer id=%s name=%s was not found", new Object[]{nodeMapping.getLogicalInstance().getId(), loadBalancer.getId(), loadBalancer.getName()});
                    continue;
                }
                loadBalancerRef.targets.computeIfAbsent(LoadBalancerUtils.getFQDN(nodeMapping.getSubdomainOrFQDN(), loadBalancer, this.dnsService), k -> new HashSet()).add(node.get().getLabel());
            }
            directory.loadBalancers.add(loadBalancerRef);
        }
        directory.eventServerNodeId = vn.getEventServerNodeLabel();
        return directory;
    }

    public void onAfterInstanceStatusUpdate(String tenantId, String virtualNetworkId, String instanceId, String status) {
        logger.infoV("Instance was %s tenantId=%s vnId=%s instanceId=%s, sending updated nodes directory", new Object[]{status, tenantId, virtualNetworkId, instanceId});
        this.updateNodesDirectoryOnAllRunningNodes(tenantId, virtualNetworkId);
    }

    public void onAfterLoadBalancerStatusUpdate(String tenantId, String virtualNetworkId, String loadBalancerId, String status) {
        logger.infoV("Load balancer was %s tenantId=%s vnId=%s loadBalancerId=%s, sending updated nodes directory", new Object[]{status, tenantId, virtualNetworkId, loadBalancerId});
        this.updateNodesDirectoryOnAllRunningNodes(tenantId, virtualNetworkId);
    }

    private void updateNodesDirectoryOnAllRunningNodes(String tenantId, String virtualNetworkId) {
        VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)virtualNetworkId);
        if (!vn.isManagedNodesDirectory()) {
            logger.info((Object)("Nodes directory is disabled on virtual network " + virtualNetworkId + ", doing nothing"));
        }
        for (LogicalInstance li : this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.tenant.id=?1 and li.virtualNetwork.id=?2", tenantId, virtualNetworkId)) {
            PublicPhysicalInstanceStatus status = this.provisioningService.getStatus(tenantId, li.getId());
            if (status.stage != PhysicalInstance.LifecycleStage.RUNNING && status.stage != PhysicalInstance.LifecycleStage.NOT_RESPONDING) continue;
            this.updateNodesDirectoryOnNode(tenantId, li.getId());
        }
    }

    private void updateNodesDirectoryOnNode(String tenantId, String instanceId) {
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.UPDATE_NODES_DIRECTORY;
        this.instanceAgentActionsQueueService.enqueueCommand(null, tenantId, instanceId, ac);
    }

    public FutureResponse<JsonObject> updateNodesDirectoryOnNode_Future(FMAuthCtx authCtx, String instanceId) throws Exception {
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.UPDATE_NODES_DIRECTORY;
        return this.instanceAgentActionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac);
    }
}

