/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.licensing;

import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.license.FMLicenseStatusService;
import com.dataiku.fm.server.FMApp;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RegistrationService {
    @Autowired
    private FMLicenseStatusService licenseStatusService;

    public synchronized void installLicense(License license) throws Exception {
        LicenseStatusService.LicensingStatus ls = this.licenseStatusService.getLicensingStatus();
        if (ls.hasLicense && ls.valid && !ls.community) {
            throw new IllegalArgumentException("Fleet Manager is already registered");
        }
        LicenseUtils.verify((License)license);
        if (!LicenseUtils.verifyNode((List)license.content.allowedNodes)) {
            throw new IllegalArgumentException("The community license is not allowed on your host");
        }
        JSON.prettyToFile((Object)license, (File)FMApp.getFile((String)"config/license.json"));
        FMApp.invalidateCachedLicenseInstanceId();
        if (license.content.instanceId != null) {
            DKUFileUtils.writeFileUTF8((File)FMApp.getFile((String)"instance-id.txt"), (String)license.content.instanceId);
        }
    }
}

