/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.services;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.git.DSSCommitDef;
import com.dataiku.dip.transactions.git.jgit.JGitManager;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.UserEditable;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.transactions.git.FMTransactionProviderSettings;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;

public class FMMainTransactionService
implements TransactionService,
AutoCloseable {
    private File configDir;
    private TransactionProvider provider;

    public FMMainTransactionService() throws IOException {
        this.configDir = new File(FMApp.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new FMTransactionProviderSettings(false, true, true));
    }

    public FMMainTransactionService(boolean gitSupport) throws IOException {
        this.configDir = new File(FMApp.getBaseFolderF(), "config");
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new FMTransactionProviderSettings(false, true, gitSupport));
    }

    public FMMainTransactionService(File anotherRoot, boolean exclusive) throws IOException {
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(this.configDir, (TransactionProvider.TransactionProviderSettings)new FMTransactionProviderSettings(exclusive, true, true));
    }

    public void changeRoot(File anotherRoot, boolean exclusive) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        this.provider.close();
        this.configDir = anotherRoot;
        this.provider = new TransactionProvider(anotherRoot, (TransactionProvider.TransactionProviderSettings)new FMTransactionProviderSettings(exclusive, true, true));
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req, boolean checkXSRF) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForUI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForAPI(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteForTicket(HttpServletRequest req) throws IOException {
        throw new NotImplementedException();
    }

    public RWTransaction beginWriteAsLoggedInUser(AuthCtx usr, boolean committable) {
        assert (usr != null) : "User cannot be null";
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        RWTransaction rw = this.provider.beginWrite(usr, committable);
        try {
            ((UserEditable)rw).setUser(usr);
            TransactionContext.attach((TransactionRef)rw);
            return rw;
        }
        catch (Throwable t) {
            rw.close();
            throw t;
        }
    }

    public RWTransaction beginWriteAsDSS(boolean committable) {
        FMAuthCtx dss = FMAuthCtx.newNone();
        return this.beginWriteAsLoggedInUser(dss, committable);
    }

    public Transaction beginRead(IsolationLevel isolationLevel, @Nullable String fakeStack) {
        TransactionContext.assertNoAttachedTransaction();
        if (this.provider == null) {
            throw new RuntimeException("The DKU transaction provider has been closed");
        }
        Transaction t = this.provider.beginRead(isolationLevel, fakeStack);
        TransactionContext.attach((TransactionRef)t);
        return t;
    }

    public File resolve(RelFile file) {
        return file.resolve(this.configDir);
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public JGitManager getGitManager() {
        throw new NotImplementedException();
    }

    public void performDirectCommit(DSSCommitDef def) {
        throw new NotImplementedException();
    }

    public void flushPendingCommits(String projectKey) {
        throw new NotImplementedException();
    }

    public void clearCache() {
        this.provider.clearCache();
    }

    public void invalidateCache(RelFile file) {
        this.provider.invalidateCache(file);
    }

    public CachedReadFS getCache() {
        return this.provider.getCache();
    }
}

