/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.simulator.CloudSimulatorService;
import com.dataiku.fm.simulator.model.CloudDisk;
import com.dataiku.fm.simulator.model.CloudDiskSnapshot;
import com.dataiku.fm.simulator.model.CloudVM;
import com.dataiku.fm.simulator.model.CloudVMState;
import com.dataiku.fm.utils.DnsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudSimulatorInstanceService
implements CloudInstanceServiceInterface {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private InstancesEventLogService eventsLogService;
    private final Cloud cloud;
    private final CloudSimulatorService simulator;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.simulator.instances");

    public CloudSimulatorInstanceService(Cloud cloud, CloudSimulatorService simulator) {
        this.cloud = cloud;
        this.simulator = simulator;
    }

    @Override
    public void checkInstanceCreation(VirtualNetwork vn, InstanceSettingsTemplate ist) {
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolume(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        switch (this.cloud) {
            case AWS: {
                pics.setAwsAMIId(instanceImage.getAMIIdForRegion(settings.awsSettings.regionId));
                break;
            }
            case AZURE: {
                pics.setAzureImageId(instanceImage.getAzureImageIdForRegion(settings.azureSettings.regionId));
            }
        }
        this.simulate("disk.create");
        CloudDisk cloudDisk = this.simulator.createDisk(li.getDataVolumeSizeGB(), 3);
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        switch (this.cloud) {
            case AWS: {
                pdv.setAwsEBSId(cloudDisk.id);
                break;
            }
            case AZURE: {
                pdv.setAzureDiskId(cloudDisk.id);
            }
        }
        pdv.setCreationState(pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolumeFromExternalSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String externalSnapshotId) {
        throw new UnsupportedOperationException("This feature is not available for simulation");
    }

    @Override
    public PhysicalDataVolume createPhysicalDataVolumeFromSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String snapshotId) {
        DataVolumeSnapshot dvs = (DataVolumeSnapshot)this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)snapshotId);
        if (dvs == null) {
            throw new IllegalStateException("No Physical Data Volume Snapshot: " + snapshotId);
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        switch (this.cloud) {
            case AWS: {
                pics.setAwsAMIId(instanceImage.getAMIIdForRegion(settings.awsSettings.regionId));
                break;
            }
            case AZURE: {
                pics.setAzureImageId(instanceImage.getAzureImageIdForRegion(settings.azureSettings.regionId));
            }
        }
        CloudDiskSnapshot cloudDiskSnapshot = this.simulator.getDiskSnapshot_Mandatory(this.getCloudDiskSnapshotId(dvs));
        this.simulate("disk.create-from-snapshot");
        CloudDisk cloudDisk = this.simulator.createDisk(cloudDiskSnapshot);
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8));
        pdv.setLogicalInstance(li);
        switch (this.cloud) {
            case AWS: {
                pdv.setAwsEBSId(cloudDisk.id);
                break;
            }
            case AZURE: {
                pdv.setAzureDiskId(cloudDisk.id);
            }
        }
        pdv.setCreationState(pics);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public DataVolumeSnapshot createPhysicalDataVolumeSnapshot(LogicalInstance li, String snapshotType, String description) {
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No Physical Data Volume for instance: " + li.getId());
        }
        String snapshotId = "dvs-" + SecretKeyGenerator.generate((int)12);
        CloudDisk cloudDisk = this.simulator.getDisk_Mandatory(this.getCloudDiskId(pdv));
        this.simulate("disk.create-from-snapshot");
        CloudDiskSnapshot cloudDiskSnapshot = this.simulator.createDiskSnapshot(cloudDisk);
        long now = System.currentTimeMillis();
        DataVolumeSnapshot dvs = new DataVolumeSnapshot();
        dvs.setId(snapshotId);
        dvs.setLogicalInstance(li);
        switch (this.cloud) {
            case AWS: {
                dvs.setAwsSnapshotId(cloudDiskSnapshot.id);
                break;
            }
            case AZURE: {
                dvs.setAzureSnapshotId(cloudDiskSnapshot.id);
            }
        }
        dvs.setCreationDate(now);
        dvs.setSnapshotType(snapshotType);
        dvs.setDescription(description);
        return dvs;
    }

    @Override
    public void deletePhysicalDataVolumeSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance logicalInstance) {
        String cloudSnapshotDiskId = this.getCloudDiskSnapshotId(dataVolumeSnapshot);
        CloudDiskSnapshot cloudDiskSnapshot = this.simulator.getDiskSnapshot_Mandatory(cloudSnapshotDiskId);
        this.simulate("disk-snapshot.delete");
        this.simulator.deleteDiskSnapshot(cloudDiskSnapshot);
    }

    @Override
    public void deletePhysicalDataVolume(PhysicalDataVolume physicalDataVolume, LogicalInstance logicalInstance) {
        String cloudDiskId = this.getCloudDiskId(physicalDataVolume);
        CloudDisk cloudDisk = this.simulator.getDisk_Mandatory(cloudDiskId);
        this.simulate("volume.delete");
        this.simulator.deleteDisk(cloudDisk);
    }

    @Override
    public String createPhysicalInstance(LogicalInstance li, DKUtils.SmartLogTailBuilder smartLogTail) {
        PhysicalInstance pi;
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No PDV for instance: " + li.getId());
        }
        InstanceImagesSettings.InstanceImage instanceImage = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId());
        String physicalInstanceId = "pi-" + SecretKeyGenerator.generate((int)12);
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("cloudInstanceType", li.getCloudInstanceType()).with("imageId", li.getImageId()));
        this.simulate("vm.create");
        CloudVM vm = this.simulator.createVM(this.getCloudImageId(instanceImage), this.getCloudDiskId(pdv));
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-vm-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("vmId", vm.id));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
            pi = new PhysicalInstance();
            pi.setId(physicalInstanceId);
            pi.setLogicalInstance(li);
            pi.setCreationState(pics);
            switch (this.cloud) {
                case AWS: {
                    pi.setAwsEC2InstanceId(vm.id);
                    break;
                }
                case AZURE: {
                    pi.setAzureVMInstanceId(vm.id);
                }
            }
            rwt.getThreadEM().persist((Object)pics);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        logger.info((Object)"Waiting for instance to be running");
        this.simulate("vm.start");
        vm.state = CloudVMState.RUNNING;
        this.simulate("vm.attach-volume");
        this.simulator.startInstanceSimulator(pi);
        this.eventsLogService.addEventASync_NT(li, null, "pi-volume-attached", JF.obj().with("physicalInstanceId", physicalInstanceId).with("vmId", vm.id));
        logger.info((Object)("Assign elastic IP: " + this.getCloudPublicIPId(li)));
        switch (this.cloud) {
            case AWS: {
                if (!li.isAwsAssignElasticIP()) break;
                vm.awsElasticIPAllocationId = li.getAwsElasticIPAllocationId();
                break;
            }
            case AZURE: {
                if (!li.isAzureAssignPublicIP()) break;
                vm.azurePublicIPId = li.getAzurePublicIPId();
            }
        }
        VirtualNetwork virtualNetwork = li.getVirtualNetwork();
        logger.info((Object)("DNS strategy: " + String.valueOf((Object)virtualNetwork.getDnsStrategy())));
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                DatabaseAccessService.ReadWriteTransaction rwt;
                String zoneName;
                String zoneId;
                if (StringUtils.isNotBlank((CharSequence)li.getVirtualNetwork().getAwsRoute53PrivateIPZoneId())) {
                    zoneId = li.getVirtualNetwork().getAwsRoute53PrivateIPZoneId();
                    zoneName = DnsUtils.safeDnsName(zoneId, "acme.int");
                    String privateDnsName = DnsUtils.safeDnsName(li.getLabel(), zoneName);
                    rwt = this.dbService.rwTransaction();
                    try {
                        pi.setPrivateDnsName(privateDnsName);
                        rwt.getThreadEM().persist((Object)pi);
                        rwt.commit();
                    }
                    finally {
                        if (rwt != null) {
                            rwt.close();
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)li.getVirtualNetwork().getAwsRoute53PublicIPZoneId())) break;
                zoneId = li.getVirtualNetwork().getAwsRoute53PublicIPZoneId();
                zoneName = DnsUtils.safeDnsName(zoneId, "acme.com");
                String publicDnsName = DnsUtils.safeDnsName(li.getLabel(), zoneName);
                rwt = this.dbService.rwTransaction();
                try {
                    pi.setPublicDnsName(publicDnsName);
                    rwt.getThreadEM().persist((Object)pi);
                    rwt.commit();
                    break;
                }
                finally {
                    if (rwt != null) {
                        rwt.close();
                    }
                }
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String zoneId = li.getTenant().getAwsRoute53ManagedZoneId();
                String zoneName = DnsUtils.safeDnsName(zoneId, "acme.com");
                String subzone = li.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = DnsUtils.safeDnsName(li.getLabel(), subzone, zoneName);
                DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();
                try {
                    pi.setPublicDnsName(publicDnsName);
                    rwt.getThreadEM().persist((Object)pi);
                    rwt.commit();
                    if (rwt == null) break;
                    rwt.close();
                    break;
                }
                catch (Throwable throwable) {
                    if (rwt != null) {
                        try {
                            rwt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        return physicalInstanceId;
    }

    @Override
    public boolean growPhysicalDataVolume(LogicalInstance li, double growthFactor) {
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        boolean growthSuccessful = false;
        long dslc = System.currentTimeMillis() - pdv.getLastGrowthStateChangedTimestamp();
        if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.OK) {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                PhysicalInstance pi;
                int currentSize = li.getDataVolumeSizeGB();
                int newSize = (int)Math.ceil(growthFactor * (double)currentSize);
                if (newSize <= currentSize) {
                    newSize = currentSize + 1;
                }
                if (li.getDataVolumeSizeMaxGB() < newSize) {
                    newSize = li.getDataVolumeSizeMaxGB();
                }
                if ((pi = li.getCurrentPhysicalInstance()) != null) {
                    CloudDisk cloudDisk;
                    CloudVM vm = this.simulator.getVM(this.getCloudVmId(pi));
                    if (vm != null && (cloudDisk = this.simulator.getDisk(vm.diskId)) != null) {
                        cloudDisk.sizeGB = newSize;
                    }
                    pdv.setGrowthState(PhysicalDataVolume.GrowthState.OK);
                    pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    li.setDataVolumeSizeGB(newSize);
                    growthSuccessful = true;
                }
                rwt.getThreadEM().persist((Object)pdv);
                rwt.getThreadEM().persist((Object)li);
                rwt.commit();
            }
        } else {
            logger.debugV("Error delays not expired, disk growth skipped li=%s, pdv=%s", new Object[]{li, pdv});
        }
        return growthSuccessful;
    }

    @Override
    public void configurePhysicalInstanceBeforeStartupPhase(PhysicalInstance physicalInstance) {
    }

    @Override
    public void configurePhysicalInstanceAfterStartupPhase(PhysicalInstance pi) {
    }

    @Override
    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(Tenant tenant, Collection<PhysicalInstance> piList) {
        this.simulator.simulate("vm.describe");
        ArrayList<PhysicalInstanceCloudState> result = new ArrayList<PhysicalInstanceCloudState>();
        for (PhysicalInstance pi : piList) {
            PhysicalInstanceCloudState status = new PhysicalInstanceCloudState(pi);
            CloudVM vm = this.simulator.getVM(this.getCloudVmId(pi));
            if (vm == null) {
                status.cloudMachineExists = false;
                continue;
            }
            status.cloudMachineExists = true;
            if (vm.state == CloudVMState.RUNNING) {
                status.cloudMachineIsUp = true;
            }
            result.add(status);
        }
        return result;
    }

    @Override
    public void terminatePhysicalInstance(PhysicalInstance pi) {
        try {
            logger.infoV("Requesting termination of instance li=%s pi=%s cloudId=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            CloudVM vm = this.simulator.getVM(this.getCloudVmId(pi));
            if (vm != null) {
                this.simulator.killInstanceSimulator(vm.id);
                this.simulator.deleteVM(vm);
            }
            logger.infoV("waiting for termination of instance li=%s pi=%s cloud=%s to complete", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            this.simulate("vm.terminate");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void startPhysicalInstance(PhysicalInstance pi) {
        try {
            String vmId = this.getCloudVmId(pi);
            LogicalInstance li = pi.getLogicalInstance();
            logger.infoV("Requesting start of instance li=%s pi=%s cloud=%s", new Object[]{pi.getId(), li.getId(), vmId});
            CloudVM vm = this.simulator.getVM_Mandatory(vmId);
            this.simulator.killInstanceSimulator(vmId);
            logger.infoV("waiting for start of instance li=%s pi=%s cloud=%s to complete", new Object[]{pi.getId(), li.getId(), vmId});
            this.simulate("vm.start");
            vm.state = CloudVMState.RUNNING;
            this.simulator.startInstanceSimulator(pi);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void stopPhysicalInstance(PhysicalInstance pi) {
        try {
            logger.infoV("Requesting stop of instance li=%s pi=%s cloud=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            CloudVM vm = this.simulator.getVM_Mandatory(this.getCloudVmId(pi));
            vm.state = CloudVMState.STOPPING;
            this.simulator.killInstanceSimulator(vm.id);
            logger.infoV("waiting for stop of instance li=%s pi=%s cloud=%s to complete", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            this.simulate("vm.stop");
            vm.state = CloudVMState.STOPPED;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void rebootPhysicalInstance(PhysicalInstance pi) {
        try {
            logger.infoV("Requesting reboot of instance li=%s pi=%s cloud=%s", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            CloudVM vm = this.simulator.getVM_Mandatory(this.getCloudVmId(pi));
            vm.state = CloudVMState.STOPPING;
            this.simulator.killInstanceSimulator(vm.id);
            logger.infoV("Waiting for reboot of instance li=%s pi=%s cloud=%s to complete", new Object[]{pi.getId(), pi.getLogicalInstance().getId(), this.getCloudVmId(pi)});
            this.simulate("vm.reboot");
            vm.state = CloudVMState.RUNNING;
            this.simulator.startInstanceSimulator(pi);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void fillPhysicalStatusWithCloudSpecificData(PhysicalInstance pi, PhysicalDataVolume physicalDataVolume, PublicPhysicalInstanceStatus status) {
        this.simulator.simulate("vm.describe");
        VirtualNetwork virtualNetwork = pi.getLogicalInstance().getVirtualNetwork();
        CloudVM vm = this.simulator.getVM(this.getCloudVmId(pi));
        if (vm == null) {
            status.cloudMachineExists = false;
        } else {
            status.cloudMachineExists = true;
            if (vm.state == CloudVMState.RUNNING) {
                status.cloudMachineIsUp = true;
            } else {
                status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "Cloud machine is not RUNNING: it is '%s'", new Object[]{vm.state.name()});
            }
            status.awsInstanceId = vm.id;
            status.privateIP = "172.2.3.4";
            status.publicIP = this.usePublicIP(virtualNetwork) ? "3.219.21.5" : null;
        }
        status.externalURL = pi.getLogicalInstance().getExternalURL();
        status.privateDNS = pi.getPrivateDnsName();
        status.privateURL = CloudSimulatorInstanceService.computeUrl(virtualNetwork, status.privateDNS, status.privateIP);
        status.publicDNS = pi.getPublicDnsName();
        status.publicURL = StringUtils.isBlank((CharSequence)status.externalURL) ? CloudSimulatorInstanceService.computeUrl(virtualNetwork, status.publicDNS, status.publicIP) : status.externalURL;
    }

    private void simulate(String step) {
        this.simulator.simulate(step);
    }

    private boolean usePublicIP(VirtualNetwork vn) {
        switch (this.cloud) {
            case AWS: {
                return vn.isAwsAssignPublicIP();
            }
            case AZURE: {
                return vn.isAzureAssignPublicIP();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private String getCloudVmId(PhysicalInstance pi) {
        switch (this.cloud) {
            case AWS: {
                return pi.getAwsEC2InstanceId();
            }
            case AZURE: {
                return pi.getAzureVMInstanceId();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private String getCloudDiskId(PhysicalDataVolume pdv) {
        switch (this.cloud) {
            case AWS: {
                return pdv.getAwsEBSId();
            }
            case AZURE: {
                return pdv.getAzureDiskId();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private String getCloudDiskSnapshotId(DataVolumeSnapshot dataVolumeSnapshot) {
        switch (this.cloud) {
            case AWS: {
                return dataVolumeSnapshot.getAwsSnapshotId();
            }
            case AZURE: {
                return dataVolumeSnapshot.getAzureSnapshotId();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private String getCloudImageId(InstanceImagesSettings.InstanceImage instanceImage) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (this.cloud) {
            case AWS: {
                return instanceImage.getAMIIdForRegion(settings.awsSettings.regionId);
            }
            case AZURE: {
                return instanceImage.getAzureImageIdForRegion(settings.azureSettings.regionId);
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private boolean getCloudPublicIPId(LogicalInstance li) {
        switch (this.cloud) {
            case AWS: {
                return li.isAwsAssignElasticIP();
            }
            case AZURE: {
                return li.isAzureAssignPublicIP();
            }
        }
        throw new IllegalArgumentException("Cloud type not supported:" + this.cloud.toString());
    }

    private static String computeUrl(VirtualNetwork virtualNetwork, String dnsName, String ip) {
        String prefix;
        String string = prefix = virtualNetwork.getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? "http://" : "https://";
        if (dnsName != null) {
            return StringUtils.removeEnd((String)(prefix + dnsName), (String)".");
        }
        if (ip != null) {
            return prefix + ip;
        }
        return null;
    }
}

