/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.VolumeNotFoundException;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.simulator.CloudSimulatorInstanceService;
import com.dataiku.fm.simulator.CloudSimulatorNetworkService;
import com.dataiku.fm.simulator.SimulatorBasics;
import com.dataiku.fm.simulator.SimulatorVariables;
import com.dataiku.fm.simulator.VMSimulator;
import com.dataiku.fm.simulator.model.CloudDisk;
import com.dataiku.fm.simulator.model.CloudDiskSnapshot;
import com.dataiku.fm.simulator.model.CloudSimulatorState;
import com.dataiku.fm.simulator.model.CloudVM;
import com.dataiku.fm.simulator.model.CloudVMState;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudSimulatorService {
    @Autowired
    private DatabaseAccessService dbService;
    private final SimulatorVariables variables = new SimulatorVariables();
    private Cloud cloud;
    private List<CloudDisk> disks = new ArrayList<CloudDisk>();
    private List<CloudDiskSnapshot> diskSnapshots = new ArrayList<CloudDiskSnapshot>();
    private List<CloudVM> vms = new ArrayList<CloudVM>();
    private Map<String, VMSimulator> vmSimulators = new HashMap<String, VMSimulator>();

    @PostConstruct
    public void init() {
        this.cloud = FMApp.getFMSettingsUnsafe().cloud;
        this.initSimulator();
    }

    public void simulate(String step) {
        new SimulatorBasics(this.variables).simulate(step);
    }

    public synchronized void startInstanceSimulator(PhysicalInstance pi) {
        String vmId = this.getVmId(pi);
        CloudVM vm = this.getVM_Mandatory(vmId);
        CloudDisk disk = this.getDisk_Mandatory(vm.diskId);
        VMSimulator vmSimulator = this.vmSimulators.get(vmId);
        if (vmSimulator != null) {
            throw new IllegalStateException("Simulator already started for this instance.");
        }
        LogicalInstance li = pi.getLogicalInstance();
        vmSimulator = new VMSimulator(li.getTenant().getId(), li.getId(), vm, disk, this.variables);
        vmSimulator.start();
        this.vmSimulators.put(vmId, vmSimulator);
    }

    public synchronized void killInstanceSimulator(String vmId) throws InterruptedException {
        VMSimulator vmSimulator = this.vmSimulators.get(vmId);
        if (vmSimulator != null) {
            vmSimulator.stopRequested = true;
            vmSimulator.interrupt();
            vmSimulator.join();
            this.vmSimulators.remove(vmId);
        }
    }

    public synchronized CloudDisk createDisk(CloudDiskSnapshot snapshot) {
        return this.createDisk(snapshot.sizeGB, snapshot.usedGB);
    }

    public synchronized CloudDisk createDisk(String diskId, int diskSizeGB, int diskUsedGB) {
        CloudDisk disk = new CloudDisk(diskId, diskSizeGB, diskUsedGB);
        this.disks.add(disk);
        return disk;
    }

    public synchronized CloudDisk createDisk(int diskSizeGB, int diskUsedGB) {
        return this.createDisk(this.nextAvailableDiskId(), diskSizeGB, diskUsedGB);
    }

    public synchronized void deleteDisk(CloudDisk cloudDisk) {
        this.disks.remove(cloudDisk);
    }

    public synchronized CloudDiskSnapshot createDiskSnapshot(String snapshotId, CloudDisk disk) {
        CloudDiskSnapshot snapshot = new CloudDiskSnapshot(snapshotId, disk.sizeGB, disk.usedGB);
        this.diskSnapshots.add(snapshot);
        return snapshot;
    }

    public synchronized CloudDiskSnapshot createDiskSnapshot(CloudDisk disk) {
        return this.createDiskSnapshot(this.nextAvailableSnapshotId(), disk);
    }

    public synchronized void deleteDiskSnapshot(CloudDiskSnapshot snapshot) {
        this.diskSnapshots.remove(snapshot);
    }

    public synchronized CloudVM createVM(String vmId, String amiId, String cloudDiskId) {
        CloudVM cloudVM = new CloudVM(vmId, amiId, cloudDiskId);
        this.vms.add(cloudVM);
        return cloudVM;
    }

    public synchronized CloudVM createVM(String amiId, String cloudDiskId) {
        return this.createVM(this.nextAvailableVmId(), amiId, cloudDiskId);
    }

    public synchronized void deleteVM(CloudVM instance) {
        this.vms.remove(instance);
    }

    public synchronized CloudVM getVM_Mandatory(String vmId) {
        CloudVM result = this.getVM(vmId);
        if (result == null) {
            throw new IllegalArgumentException("Unknown Cloud instance: " + vmId);
        }
        return result;
    }

    public synchronized CloudVM getVM(final String vmId) {
        return (CloudVM)FluentIterable.from(this.vms).firstMatch((Predicate)new Predicate<CloudVM>(){

            public boolean apply(CloudVM vm) {
                return vm.id.equals(vmId);
            }
        }).orNull();
    }

    public synchronized CloudDisk getDisk(final String cloudDiskId) {
        return (CloudDisk)FluentIterable.from(this.disks).firstMatch((Predicate)new Predicate<CloudDisk>(){

            public boolean apply(CloudDisk fakeAWSDataVolume) {
                return fakeAWSDataVolume.id.equals(cloudDiskId);
            }
        }).orNull();
    }

    public synchronized CloudDisk getDisk_Mandatory(String cloudDiskId) {
        CloudDisk result = this.getDisk(cloudDiskId);
        if (result == null) {
            throw new VolumeNotFoundException(cloudDiskId, null);
        }
        return result;
    }

    public synchronized CloudDiskSnapshot getDiskSnapshot(final String cloudDiskSnapshotId) {
        return (CloudDiskSnapshot)FluentIterable.from(this.diskSnapshots).firstMatch((Predicate)new Predicate<CloudDiskSnapshot>(){

            public boolean apply(CloudDiskSnapshot diskSnapshot) {
                return diskSnapshot.id.equals(cloudDiskSnapshotId);
            }
        }).orNull();
    }

    public synchronized CloudDiskSnapshot getDiskSnapshot_Mandatory(String cloudDiskSnapshotId) {
        CloudDiskSnapshot result = this.getDiskSnapshot(cloudDiskSnapshotId);
        if (result == null) {
            throw new IllegalStateException("Unknown Cloud snapshot ID: " + cloudDiskSnapshotId);
        }
        return result;
    }

    public synchronized CloudSimulatorState saveState() {
        CloudSimulatorState state = new CloudSimulatorState();
        state.disks = this.disks;
        state.diskSnapshots = this.diskSnapshots;
        state.vms = this.vms;
        state.variables = new TreeMap<String, String>(this.variables.getVariables());
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadState(CloudSimulatorState newState) {
        boolean interrupted = false;
        try {
            for (String vmId : this.vmSimulators.keySet()) {
                try {
                    this.killInstanceSimulator(vmId);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (newState.vms != null) {
                this.vms = newState.vms;
            }
            if (newState.disks != null) {
                this.disks = newState.disks;
            }
            if (newState.diskSnapshots != null) {
                this.diskSnapshots = newState.diskSnapshots;
            }
            if (newState.variables != null) {
                this.executeUpdateVariables(newState.variables);
            }
            for (CloudVM vm : this.vms) {
                switch (vm.state) {
                    case PENDING: 
                    case RUNNING: {
                        vm.state = CloudVMState.RUNNING;
                        PhysicalInstance pi = this.getPhysicalInstance(vm);
                        if (pi == null) break;
                        this.startInstanceSimulator(pi);
                        break;
                    }
                    case STOPPING: 
                    case STOPPED: {
                        vm.state = CloudVMState.STOPPED;
                        break;
                    }
                    case TERMINATING: 
                    case TERMINATED: {
                        vm.state = CloudVMState.TERMINATED;
                    }
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public CloudInstanceServiceInterface createInstanceService() {
        return new CloudSimulatorInstanceService(this.cloud, this);
    }

    public CloudNetworkServiceInterface createNetworkService() {
        return new CloudSimulatorNetworkService(this.cloud);
    }

    public CloudVM executeGetVM(String vmId) {
        return this.getVM_Mandatory(vmId);
    }

    public void executeStartVM(String vmId) {
        PhysicalInstance pi;
        CloudVM vm = this.getVM_Mandatory(vmId);
        if (vm.state == CloudVMState.PENDING || vm.state == CloudVMState.STOPPED) {
            vm.state = CloudVMState.RUNNING;
            pi = this.getPhysicalInstance(vm);
            if (pi == null) {
                throw new IllegalStateException("Cannot start agent because there is no physical instance attached to the Cloud instance");
            }
        } else {
            throw new IllegalStateException("Cloud instance cannot be started. It is in state: " + String.valueOf((Object)vm.state));
        }
        this.startInstanceSimulator(pi);
    }

    public void executeStopVM(String vmId) {
        CloudVM vm = this.getVM_Mandatory(vmId);
        if (vm.state != CloudVMState.PENDING && vm.state != CloudVMState.RUNNING) {
            throw new IllegalStateException("Cloud instance cannot be stopped. It is in state: " + String.valueOf((Object)vm.state));
        }
        vm.state = CloudVMState.STOPPING;
        this.stopInstanceSimulator(vm);
        vm.state = CloudVMState.STOPPED;
    }

    public void executeDeleteVM(String vmId) {
        CloudVM cloudVM = this.getVM_Mandatory(vmId);
        this.deleteVM(cloudVM);
    }

    public void executeStartStopAgentHeartbeat(String vmId, boolean start) {
        CloudVM vm = this.getVM_Mandatory(vmId);
        VMSimulator instanceSimulator = this.vmSimulators.get(vm.id);
        instanceSimulator.setHeartbeatActive(start);
    }

    public synchronized void executeStartAgent(String vmId) {
        CloudVM vm = this.getVM_Mandatory(vmId);
        if (vm.state != CloudVMState.RUNNING) {
            throw new IllegalStateException("Cannot start agent because the Cloud instance is not in RUNNING state: " + String.valueOf((Object)vm.state));
        }
        PhysicalInstance pi = this.getPhysicalInstance(vm);
        if (pi == null) {
            throw new IllegalStateException("Cannot start agent because there is no physical instance attached to the Cloud instance");
        }
        this.startInstanceSimulator(pi);
    }

    public synchronized void executeStopAgent(String vmId) {
        CloudVM vm = this.getVM_Mandatory(vmId);
        this.stopInstanceSimulator(vm);
    }

    public void executeUpdateDisk(String diskId, Integer sizeGB, Integer usedGB) {
        CloudDisk cloudDisk = this.getDisk_Mandatory(diskId);
        if (sizeGB != null) {
            cloudDisk.sizeGB = sizeGB;
        }
        if (usedGB != null) {
            cloudDisk.usedGB = usedGB;
        }
    }

    public void executeUpdateVMState(String vmId, CloudVMState state) {
        CloudVM vm = this.getVM_Mandatory(vmId);
        if (state != null) {
            vm.state = state;
        }
    }

    public void executeUpdateVariables(Map<String, String> args) {
        this.variables.setVariables(args);
    }

    private void stopInstanceSimulator(CloudVM vm) {
        try {
            this.killInstanceSimulator(vm.id);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void initSimulator() {
        List<LogicalInstance> instanceList = this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li", new Object[0]);
        for (LogicalInstance li : instanceList) {
            PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
            if (pdv == null) continue;
            String diskId = this.getCloudDiskId(pdv);
            CloudDisk disk = this.createDisk(diskId, li.getDataVolumeSizeGB(), new Random().nextInt(li.getDataVolumeSizeGB() * 3 / 5));
            PhysicalInstance pi = li.getCurrentPhysicalInstance();
            if (pi != null) {
                String vmId = this.getVmId(pi);
                this.createVM(vmId, li.getImageId(), diskId);
            }
            List<DataVolumeSnapshot> dataVolumeSnapshots = this.listSnapshotsOldestFirst(li);
            for (DataVolumeSnapshot dvs : dataVolumeSnapshots) {
                String snapshotId = this.getCloudSnapshotId(dvs);
                this.createDiskSnapshot(snapshotId, disk);
            }
        }
    }

    private String getCloudSnapshotId(DataVolumeSnapshot dvs) {
        return this.cloud == Cloud.AWS ? dvs.getAwsSnapshotId() : dvs.getAzureSnapshotId();
    }

    private List<DataVolumeSnapshot> listSnapshotsOldestFirst(LogicalInstance logicalinstance) {
        return this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", logicalinstance);
    }

    private String getCloudDiskId(PhysicalDataVolume pdv) {
        return this.cloud == Cloud.AWS ? pdv.getAwsEBSId() : pdv.getAzureDiskId();
    }

    private PhysicalInstance getPhysicalInstance(CloudVM vm) {
        String query = this.cloud == Cloud.AWS ? "SELECT pi from physicalinstance pi where pi.awsEC2InstanceId=?1" : "SELECT pi from physicalinstance pi where pi.azureVMInstanceId=?1";
        return this.dbService.getSingleResult(PhysicalInstance.class, query, vm.id);
    }

    private synchronized String nextAvailableVmId() {
        String id;
        int counter = 1;
        do {
            id = String.format("simulator-vm-%03d", counter);
            ++counter;
        } while (this.getVM(id) != null);
        return id;
    }

    private synchronized String nextAvailableDiskId() {
        String id;
        int counter = 1;
        do {
            id = String.format("simulator-disk-%03d", counter);
            ++counter;
        } while (this.getDisk(id) != null);
        return id;
    }

    private synchronized String nextAvailableSnapshotId() {
        String id;
        int counter = 1;
        do {
            id = String.format("simulator-snapshot-%03d", counter);
            ++counter;
        } while (this.getDiskSnapshot(id) != null);
        return id;
    }

    private String getVmId(PhysicalInstance pi) {
        return this.cloud == Cloud.AWS ? pi.getAwsEC2InstanceId() : pi.getAzureVMInstanceId();
    }
}

