/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.simulator;

import java.util.HashMap;
import java.util.Map;

public class SimulatorVariables {
    private Map<String, String> variables = SimulatorVariables.defaultVariables();

    public static Map<String, String> defaultVariables() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("vm.describe/duration", "100");
        result.put("vm.create/duration", "1000");
        result.put("vm.attach-volume/duration", "1000");
        result.put("vm.start/duration", "1000");
        result.put("vm.stop/duration", "1000");
        result.put("vm.terminate/duration", "1000");
        result.put("disk.create/duration", "1000");
        result.put("disk.create-from-snapshot/duration", "1000");
        result.put("disk.delete/duration", "1000");
        result.put("disk-snapshot.create/duration", "1000");
        result.put("disk-snapshot.delete/duration", "1000");
        result.put("agent.bootstrap/duration", "1000");
        result.put("agent.initialize/duration", "1000");
        result.put("agent.start-dss/duration", "1000");
        result.put("agent.auto-restart/duration", "1000");
        result.put("agent-command.restart-dss/duration", "1000");
        result.put("agent-command.send-logs/duration", "1000");
        result.put("agent-command.grow-filesystem/duration", "1000");
        return result;
    }

    public synchronized String getVariable(String name) {
        return this.variables.get(name);
    }

    public long getDurationVariable(String variableName) {
        try {
            String variable = this.getVariable(variableName + "/duration");
            if (variable != null && variable.length() > 0) {
                return Long.parseLong(variable);
            }
            return 0L;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to retrieve duration variable: " + variableName);
        }
    }

    public int getFailVariableAndDecrement(String variableName) {
        return this.getIntVariableAndDecrement(variableName + "/fail");
    }

    public int getCrashVariableAndDecrement(String variableName) {
        return this.getIntVariableAndDecrement(variableName + "/crash");
    }

    private synchronized int getIntVariableAndDecrement(String name) {
        String variable = this.variables.get(name);
        if (variable == null || "false".equalsIgnoreCase(variable)) {
            return 0;
        }
        if ("true".equalsIgnoreCase(variable)) {
            return Integer.MAX_VALUE;
        }
        int result = Integer.parseInt(variable);
        if (result > 0) {
            this.variables.put(name, String.valueOf(result - 1));
        }
        return result;
    }

    public synchronized Map<String, String> getVariables() {
        return new HashMap<String, String>(this.variables);
    }

    public synchronized void setVariables(Map<String, String> variables) {
        this.variables.putAll(variables);
    }
}

