/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.google.gson.internal.sql;

import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.JsonSyntaxException;
import com.dataiku.dss.shadelib.com.google.gson.TypeAdapter;
import com.dataiku.dss.shadelib.com.google.gson.TypeAdapterFactory;
import com.dataiku.dss.shadelib.com.google.gson.reflect.TypeToken;
import com.dataiku.dss.shadelib.com.google.gson.stream.JsonReader;
import com.dataiku.dss.shadelib.com.google.gson.stream.JsonToken;
import com.dataiku.dss.shadelib.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == java.sql.Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.sql.Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String s2 = in.nextString();
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            TimeZone originalTimeZone = this.format.getTimeZone();
            try {
                Date utilDate = this.format.parse(s2);
                java.sql.Date date = new java.sql.Date(utilDate.getTime());
                return date;
            }
            catch (ParseException e) {
                throw new JsonSyntaxException("Failed parsing '" + s2 + "' as SQL Date; at path " + in.getPreviousPath(), e);
            }
            finally {
                this.format.setTimeZone(originalTimeZone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter out, java.sql.Date value) throws IOException {
        String dateString;
        if (value == null) {
            out.nullValue();
            return;
        }
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            dateString = this.format.format(value);
        }
        out.value(dateString);
    }
}

