/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import java.io.IOException;

public final class RemoveDuplicatesTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncAttribute = this.addAttribute(PositionIncrementAttribute.class);
    private final CharArraySet previous = new CharArraySet(8, false);

    public RemoveDuplicatesTokenFilter(TokenStream in) {
        super(in);
    }

    @Override
    public boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            char[] term = this.termAttribute.buffer();
            int length = this.termAttribute.length();
            int posIncrement = this.posIncAttribute.getPositionIncrement();
            if (posIncrement > 0) {
                this.previous.clear();
            }
            boolean duplicate = posIncrement == 0 && this.previous.contains(term, 0, length);
            char[] saved = new char[length];
            System.arraycopy(term, 0, saved, 0, length);
            this.previous.add(saved);
            if (duplicate) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.previous.clear();
    }
}

