/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.facet;

import com.dataiku.dss.shadelib.org.apache.lucene.facet.FacetResult;
import com.dataiku.dss.shadelib.org.apache.lucene.facet.Facets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MultiFacets
extends Facets {
    private final Map<String, Facets> dimToFacets;
    private final Facets defaultFacets;

    public MultiFacets(Map<String, Facets> dimToFacets) {
        this(dimToFacets, null);
    }

    public MultiFacets(Map<String, Facets> dimToFacets, Facets defaultFacets) {
        this.dimToFacets = dimToFacets;
        this.defaultFacets = defaultFacets;
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets == null) {
            if (this.defaultFacets == null) {
                throw new IllegalArgumentException("invalid dim \"" + dim + "\"");
            }
            facets = this.defaultFacets;
        }
        return facets.getAllChildren(dim, path);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        MultiFacets.validateTopN(topN);
        Facets facets = this.dimToFacets.get(dim);
        if (facets == null) {
            if (this.defaultFacets == null) {
                throw new IllegalArgumentException("invalid dim \"" + dim + "\"");
            }
            facets = this.defaultFacets;
        }
        return facets.getTopChildren(topN, dim, path);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        Facets facets = this.dimToFacets.get(dim);
        if (facets == null) {
            if (this.defaultFacets == null) {
                throw new IllegalArgumentException("invalid dim \"" + dim + "\"");
            }
            facets = this.defaultFacets;
        }
        return facets.getSpecificValue(dim, path);
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        MultiFacets.validateTopN(topN);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (Map.Entry<String, Facets> ent : this.dimToFacets.entrySet()) {
            results.add(ent.getValue().getTopChildren(topN, ent.getKey(), new String[0]));
        }
        if (this.defaultFacets != null) {
            for (FacetResult result : this.defaultFacets.getAllDims(topN)) {
                if (this.dimToFacets.containsKey(result.dim)) continue;
                results.add(result);
            }
        }
        return results;
    }
}

