/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.docvalues;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSourceScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.mutable.MutableValue;
import com.dataiku.dss.shadelib.org.apache.lucene.util.mutable.MutableValueDouble;
import java.io.IOException;

public abstract class DoubleDocValues
extends FunctionValues {
    protected final ValueSource vs;

    public DoubleDocValues(ValueSource vs) {
        this.vs = vs;
    }

    @Override
    public byte byteVal(int doc) throws IOException {
        return (byte)this.doubleVal(doc);
    }

    @Override
    public short shortVal(int doc) throws IOException {
        return (short)this.doubleVal(doc);
    }

    @Override
    public float floatVal(int doc) throws IOException {
        return (float)this.doubleVal(doc);
    }

    @Override
    public int intVal(int doc) throws IOException {
        return (int)this.doubleVal(doc);
    }

    @Override
    public long longVal(int doc) throws IOException {
        return (long)this.doubleVal(doc);
    }

    @Override
    public boolean boolVal(int doc) throws IOException {
        return this.doubleVal(doc) != 0.0;
    }

    @Override
    public abstract double doubleVal(int var1) throws IOException;

    @Override
    public String strVal(int doc) throws IOException {
        return Double.toString(this.doubleVal(doc));
    }

    @Override
    public Object objectVal(int doc) throws IOException {
        return this.exists(doc) ? Double.valueOf(this.doubleVal(doc)) : null;
    }

    @Override
    public String toString(int doc) throws IOException {
        return this.vs.description() + "=" + this.strVal(doc);
    }

    @Override
    public ValueSourceScorer getRangeScorer(Weight weight, LeafReaderContext readerContext, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        double lower = lowerVal == null ? Double.NEGATIVE_INFINITY : Double.parseDouble(lowerVal);
        double upper = upperVal == null ? Double.POSITIVE_INFINITY : Double.parseDouble(upperVal);
        final double l = lower;
        final double u = upper;
        if (includeLower && includeUpper) {
            return new ValueSourceScorer(weight, readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!DoubleDocValues.this.exists(doc)) {
                        return false;
                    }
                    double docVal = DoubleDocValues.this.doubleVal(doc);
                    return docVal >= l && docVal <= u;
                }
            };
        }
        if (includeLower && !includeUpper) {
            return new ValueSourceScorer(weight, readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!DoubleDocValues.this.exists(doc)) {
                        return false;
                    }
                    double docVal = DoubleDocValues.this.doubleVal(doc);
                    return docVal >= l && docVal < u;
                }
            };
        }
        if (!includeLower && includeUpper) {
            return new ValueSourceScorer(weight, readerContext, this){

                @Override
                public boolean matches(int doc) throws IOException {
                    if (!DoubleDocValues.this.exists(doc)) {
                        return false;
                    }
                    double docVal = DoubleDocValues.this.doubleVal(doc);
                    return docVal > l && docVal <= u;
                }
            };
        }
        return new ValueSourceScorer(weight, readerContext, this){

            @Override
            public boolean matches(int doc) throws IOException {
                if (!DoubleDocValues.this.exists(doc)) {
                    return false;
                }
                double docVal = DoubleDocValues.this.doubleVal(doc);
                return docVal > l && docVal < u;
            }
        };
    }

    @Override
    public FunctionValues.ValueFiller getValueFiller() {
        return new FunctionValues.ValueFiller(){
            private final MutableValueDouble mval = new MutableValueDouble();

            @Override
            public MutableValue getValue() {
                return this.mval;
            }

            @Override
            public void fillValue(int doc) throws IOException {
                this.mval.value = DoubleDocValues.this.doubleVal(doc);
                this.mval.exists = DoubleDocValues.this.exists(doc);
            }
        };
    }
}

