/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSet;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;

public class BitDocIdSet
extends DocIdSet {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(BitDocIdSet.class);
    private final BitSet set;
    private final long cost;

    public BitDocIdSet(BitSet set, long cost) {
        if (cost < 0L) {
            throw new IllegalArgumentException("cost must be >= 0, got " + cost);
        }
        this.set = set;
        this.cost = cost;
    }

    public BitDocIdSet(BitSet set) {
        this(set, set.approximateCardinality());
    }

    @Override
    public DocIdSetIterator iterator() {
        return new BitSetIterator(this.set, this.cost);
    }

    @Override
    public BitSet bits() {
        return this.set;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.set.ramBytesUsed();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(set=" + this.set + ",cost=" + this.cost + ")";
    }
}

