/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.util.Locale;

public class TermAndVector {
    private final BytesRef term;
    private final float[] vector;

    public TermAndVector(BytesRef term, float[] vector) {
        this.term = term;
        this.vector = vector;
    }

    public BytesRef getTerm() {
        return this.term;
    }

    public float[] getVector() {
        return this.vector;
    }

    public int size() {
        return this.vector.length;
    }

    public void normalizeVector() {
        int i;
        float vectorLength = 0.0f;
        for (i = 0; i < this.vector.length; ++i) {
            vectorLength += this.vector[i] * this.vector[i];
        }
        vectorLength = (float)Math.sqrt(vectorLength);
        i = 0;
        while (i < this.vector.length) {
            int n = i++;
            this.vector[n] = this.vector[n] / vectorLength;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.term.utf8ToString());
        builder.append(" [");
        if (this.vector.length > 0) {
            for (int i = 0; i < this.vector.length - 1; ++i) {
                builder.append(String.format(Locale.ROOT, "%.3f,", Float.valueOf(this.vector[i])));
            }
            builder.append(String.format(Locale.ROOT, "%.3f]", Float.valueOf(this.vector[this.vector.length - 1])));
        }
        return builder.toString();
    }
}

