(function () {
    'use strict';

    const app = angular.module('dataiku.fm.topbar', ['dataiku.services']);

    app.directive('topbarDrawer', function () {
        return {
            scope: true,
            link: function (scope, element) {
                scope.shown = false;
                $(element).hide();

                function hideIfClickElsewhere(event) {
                    if (event.target) {
                        var e = event.target;
                        // go back up to find a bootstrap-select or absence of <body> (that would indicate we're after a bootstrap-select closed itself)
                        while (e) {
                            if (e.classList && e.classList.indexOf && e.classList.indexOf("bootstrap-select") >= 0) return;
                            if (e.tagName.toLowerCase() === 'body') break;
                            e = e.parentElement;
                        }
                        if (e == null) return;
                    }
                    if (!element.get(0).contains(event.target) && !event.target.classList.contains("dropdown-menu")) {
                        hide();
                    }
                }

                function hide() {
                    element.hide();
                    $("html").unbind("click", hideIfClickElsewhere);
                    scope.shown = false;
                }

                function show() {
                    scope.shown = true;
                    $(element).show();
                    window.setTimeout(function () {
                        $("html").click(hideIfClickElsewhere);
                    }, 0);
                }

                scope.toggle = function () {
                    if (scope.shown) hide(); else show();
                };

                scope.$on('$stateChangeSuccess', hide);
            }
        };
    });

    app.directive('userDrawer', function ($rootScope) {
        return {
            restrict: 'A',
            templateUrl: '/app/topbar/user-drawer.html',
            link: function (scope) {
                scope.context = "drawer";
                $rootScope.toggleUserDrawer = function () {
                    scope.toggle();
                };
            }
        };
    });

})();
