(function() {
    "use strict";

    angular.module("dataiku.addDatasetWorkflow")
        .controller("AddDatasetModalController", AddDatasetModalController);

    function AddDatasetModalController(
        $scope,
        $timeout,
        AddDatasetWorkflowService,
        translate
    ) {
        const ctrl = this;
        ctrl.datasetsMenus = [];


        $scope.initModal = function(element, outerScope) {
            ctrl.outerScope = outerScope;
            // ensure this runs after the modal has been rendered.
            $timeout(() => {
                const modal = element[0];
                const searchInput = modal.getElementsByClassName('basic-search-box__input').item(0)
                if (searchInput) {
                    searchInput.focus();
                }
            }, 500)

            AddDatasetWorkflowService.getMenuData($scope.flowScope)
                .then(results => {
                    ctrl.datasetsMenus = results.datasetsMenus;
                })
                .catch(setErrorInScope.bind($scope.flowScope));
        }
    }
})();
