(function() {
    'use strict';

    const app = angular.module('dataiku.charts');

    /**
     * (!) This service previously was in static/dataiku/js/simple_report/chart_view_commons.js
     */
    app.factory('d3Utils', function() {
        return {
            // d3 < v4.0 doesnt have a ordinalScale.rangeStep() function (equivalent of rangeBand() when is the range is set with rangePoints)
            getOrdinalScaleRangeStep: function(ordinalScale) {
                if (ordinalScale.range().length < 2) {
                    return 100;
                }
                return Math.abs(ordinalScale.range()[1] - ordinalScale.range()[0]);
            },

            // Call a function once all transitions of a selection have ended
            endAll: function(transition, globalCallback, perItemCallback) {
                if (transition.size() === 0 && globalCallback) {
                    globalCallback();
                }
                let n = 0;
                transition
                    .each(function() {
                        ++n;
                    })
                    .each('end', function() {
                        if (perItemCallback) {
                            perItemCallback.apply(this, arguments);
                        }
                        if (!--n) {
                            globalCallback.apply(this, arguments);
                        }
                    });
            },

            // Computes the range length for an ordinal scale to have the given rangeBand, given domain length, padding & outerPadding
            getRangeForGivenRangeBand: function(rangeBand, domainLength, padding, outerPadding) {
                const step = rangeBand / (1 - padding);
                return rangeBand * domainLength + step * padding * (domainLength - 1) + 2 * step * outerPadding;
            }
        }
    });
})();
