/* global describe, it, beforeEach, ChartFeaturesTestUtils */

describe('chart features lines', function () {

    const chartType = 'lines';
    const chartVariant = 'normal';

    /* Get tests helpers */
    const { expectIdToBeVisible, expectIdToBeHidden, renderTemplate } = ChartFeaturesTestUtils;

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
        ChartFeaturesTestUtils.setAxisSpecs(chartType);
    });

    it('has left menu filters dropzone', function () {
        renderTemplate('/templates/simple_report/left-column/left-column.html');

        expectIdToBeVisible('qa_charts_filter-submenu-header');
        expectIdToBeVisible('qa_charts_filters-dropzone');
    })

    it('has left menu dimensions options', function () {
        renderTemplate('/templates/simple_report/left-column/dimensions.html');

        expectIdToBeVisible('qa_charts_tooltip-submenu-header');
        expectIdToBeVisible('qa_charts_animation-submenu-header');
        expectIdToBeVisible('qa_charts_animation-dropzone');
        expectIdToBeVisible('qa_charts_subchart-submenu-header');
        expectIdToBeVisible('qa_charts_subcharts-dropzone');
    })

    it('doesn\'t have regression line options', function () {
        renderTemplate(`/templates/simple_report/types/options-${chartType}.html`);
        expectIdToBeHidden('qa_charts_regression-line-form');
    })

});
