/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class IntegrationChannelPermissionsService {
    public boolean hasIntegrationChannelPrivilege(AuthCtx authCtx, IntegrationChannel channel, IntegrationChannelPrivilegeType privilege) throws DKUSecurityException {
        Preconditions.checkNotNull((Object)authCtx);
        return switch (authCtx.getAuthSource()) {
            default -> throw new IncompatibleClassChangeError();
            case AuthCtx.AuthSource.PERSONAL_API_KEY, AuthCtx.AuthSource.USER_FROM_UI, AuthCtx.AuthSource.GLOBAL_API_KEY_WITH_GROUPS -> {
                if (authCtx.isAdmin()) {
                    yield true;
                }
                String login = authCtx.getAssociatedDSSUser();
                Set<String> groups = authCtx.getGroups();
                yield channel.permissions.stream().filter(Objects::nonNull).anyMatch(pi -> pi.includes(privilege) && (login != null && login.equals(pi.user) || groups.contains(pi.group) || "$$ALL_USERS$$".equals(pi.group)));
            }
            case AuthCtx.AuthSource.CONFIGURABLE_API_KEY_GLOBAL, AuthCtx.AuthSource.CONFIGURABLE_API_KEY_PROJECT -> {
                if (authCtx.isAdmin()) {
                    yield true;
                }
                yield channel.permissions.stream().filter(Objects::nonNull).anyMatch(pi -> pi.includes(privilege) && "$$ALL_USERS$$".equals(pi.group));
            }
            case AuthCtx.AuthSource.NONE -> throw new Error("cannot check permissions on a NONE context");
        };
    }

    public void checkIntegrationChannelPrivilege(AuthCtx authCtx, IntegrationChannel channel, IntegrationChannelPrivilegeType privilege) throws DKUSecurityException {
        if (!this.hasIntegrationChannelPrivilege(authCtx, channel, privilege)) {
            throw new UnauthorizedException("Usage of integration channel forbidden: " + channel.id, "integration-channel-use-denied");
        }
    }

    public void checkIntegrationChannelUse(AuthCtx authCtx, IntegrationChannel channel) throws DKUSecurityException {
        this.checkIntegrationChannelPrivilege(authCtx, channel, IntegrationChannelPrivilegeType.USE);
    }

    public static enum IntegrationChannelPrivilegeType {
        USE;

    }

    public static class IntegrationChannelPermissionItem {
        @Nullable
        public String group;
        @Nullable
        public String user;
        public boolean canUse;

        private IntegrationChannelPermissionItem() {
        }

        public IntegrationChannelPermissionItem(String user, String group) {
            this.user = user;
            this.group = group;
        }

        public IntegrationChannelPermissionItem withCanUse() {
            this.canUse = true;
            return this;
        }

        public boolean includes(IntegrationChannelPrivilegeType privilege) {
            switch (privilege) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case USE: 
            }
            return this.canUse;
        }
    }
}

