/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.jwt;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.DefaultResourceRetriever;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class ProxyResourceRetriever
extends DefaultResourceRetriever {
    private final boolean useProxy;
    private final ProxySettings proxySettings;

    public boolean isUsingProxy() {
        return this.useProxy;
    }

    public ProxyResourceRetriever(int connectTimeout, int readTimeout, int sizeLimit, ProxySettings proxySettings, boolean useProxy) {
        super(connectTimeout, readTimeout, sizeLimit);
        this.proxySettings = proxySettings;
        this.useProxy = useProxy;
        if (useProxy && proxySettings.hasProxy()) {
            this.setProxy(proxySettings.getProxy());
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection httpURLConnection = super.openConnection(url);
        if (this.useProxy) {
            ProxyUtils.applyProxyAuthentication(this.proxySettings, httpURLConnection);
        }
        return httpURLConnection;
    }
}

