/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.common.server.DKUControllerBase;
import java.lang.reflect.Type;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class EmptyRequiredRequestBodyAdvice
extends RequestBodyAdviceAdapter {
    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return this.isRequestBodyRequired(methodParameter);
    }

    private boolean isRequestBodyRequired(MethodParameter methodParameter) {
        RequestBody requestBody = (RequestBody)methodParameter.getParameterAnnotation(RequestBody.class);
        return requestBody != null && requestBody.required() && !methodParameter.isOptional();
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        String cause = String.format("Required request body is missing: %s", targetType.getTypeName());
        throw new DKUControllerBase.MalformedRequestException(cause);
    }
}

