/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.Journal;
import com.dataiku.dip.transactions.fs.ReadOnlyFSBase;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.CachedReadFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileAttribute;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GuavaCacheMetrics;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class LegacyCache
extends ReadOnlyFSBase
implements CachedReadFS {
    private final ReadOnlyFS fs;
    private final RelFileFilter cacheabilityFilter;
    private final Cache<RelFile, CacheEntry> cache;
    @Nullable
    private Metrics metrics;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.transactions.readfs");

    @Override
    public void registerMetrics(String prefix, MetricRegistry registry) {
        if (this.metrics == null) {
            Metrics metrics = new Metrics();
            metrics.registerOn(prefix, registry);
            this.metrics = metrics;
        }
    }

    public LegacyCache(ReadOnlyFS fs) {
        this(fs, new AcceptAllFilter());
    }

    public LegacyCache(ReadOnlyFS fs, RelFileFilter cacheabilityFilter) {
        Cache _cache;
        this.cacheabilityFilter = cacheabilityFilter;
        try {
            _cache = CacheBuilder.newBuilder().recordStats().build();
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)("Failed to create cache with stats recording, retrying without: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            _cache = CacheBuilder.newBuilder().build();
        }
        this.cache = _cache;
        this.fs = fs;
    }

    @Override
    public List<RelFile> listFilesUnordered(RelFile directory) throws IOException {
        return this.fs.listFilesUnordered(directory);
    }

    private RelFileAttribute getFileAttributes(RelFile file) throws IOException {
        RelFileAttribute fileAttributes = this.fs.getAttributes(file);
        if (fileAttributes != null && fileAttributes.getFileType() == RelFileAttribute.FileType.FILE) {
            return fileAttributes;
        }
        throw new IOException("Not a file: " + String.valueOf(file));
    }

    private CacheEntry getFromCache(RelFile file) throws IOException {
        CacheEntry entry = (CacheEntry)this.cache.getIfPresent((Object)file);
        RelFileAttribute fileAttributes = this.getFileAttributes(file);
        if (entry == null) {
            if (this.metrics != null) {
                this.metrics.fullMissMeter.mark();
            }
        } else {
            if (entry.lastModified == fileAttributes.getLastModified() && entry.content.getInMemoryLength() == fileAttributes.getLength()) {
                if (this.metrics != null) {
                    this.metrics.realHitMeter.mark();
                }
                return entry;
            }
            if (this.metrics != null) {
                this.metrics.staleHitMeter.mark();
            }
        }
        FileContent content = this.fs.readContentUnsafe(file);
        entry = new CacheEntry(content, fileAttributes.getLastModified());
        if (this.cacheabilityFilter.accept(this, file)) {
            this.cache.put((Object)file, (Object)entry);
        }
        return entry;
    }

    @Override
    public void invalidate(RelFile file) {
        ArrayList<RelFile> toInvalidate = new ArrayList<RelFile>();
        for (RelFile rf : this.cache.asMap().keySet()) {
            if (!file.isAncestorOf(rf)) continue;
            toInvalidate.add(rf);
        }
        if (this.metrics != null) {
            this.metrics.fileInvalidationMeter.mark((long)toInvalidate.size());
        }
        this.cache.invalidateAll(toInvalidate);
    }

    private void updateCache(RelFile file, FileContent content) throws IOException {
        boolean cacheable = this.cacheabilityFilter.accept(this, file);
        if (content.isPossiblyNotStoredInMemory() || !cacheable) {
            this.cache.invalidate((Object)file);
        } else {
            long lastModified = this.getFileAttributes(file).getLastModified();
            CacheEntry entry = new CacheEntry(content, lastModified);
            if (this.metrics != null) {
                this.metrics.cacheUpdateMeter.mark();
            }
            this.cache.put((Object)file, (Object)entry);
        }
    }

    @Override
    public void updateCache(Journal journal) throws IOException {
        for (RelFile rf : journal.deletedFiles) {
            this.invalidate(rf);
        }
        for (RelFile rf : journal.deletedDirectories) {
            this.invalidate(rf);
        }
        for (Journal.WrittenFile wf : journal.getWrittenFiles()) {
            if (wf.content == null) continue;
            this.updateCache(wf.file, wf.content);
        }
    }

    @Override
    public RelFileAttribute getAttributes(RelFile file) throws IOException {
        return this.fs.getAttributes(file);
    }

    @Override
    public FileContent readContentUnsafe(RelFile file) throws IOException {
        return this.getFromCache((RelFile)file).content;
    }

    @Override
    public void inspectionData(Appendable sb) throws IOException {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            CacheEntry ce = (CacheEntry)entry.getValue();
            sb.append(((RelFile)entry.getKey()).getFullPath()).append("\t");
            if (ce != null && ce.content != null) {
                sb.append(ce.content.inspectionData()).append("\n");
                continue;
            }
            sb.append("no_content\n");
        }
    }

    @Override
    public String fullDumpItem(String path) {
        CacheEntry ce = (CacheEntry)this.cache.getIfPresent((Object)RelFile.fromPath(path));
        if (ce != null && ce.content != null) {
            return ce.content.fullDumpObject();
        }
        return null;
    }

    private class Metrics {
        Meter fullMissMeter = new Meter();
        Meter realHitMeter = new Meter();
        Meter staleHitMeter = new Meter();
        Meter fileInvalidationMeter = new Meter();
        Meter cacheUpdateMeter = new Meter();

        private Metrics() {
        }

        void registerOn(String prefix, MetricRegistry registry) {
            HashMap<CallSite, Object> metricsToRegister = new HashMap<CallSite, Object>();
            metricsToRegister.put((CallSite)((Object)(prefix + ".fullMiss")), this.fullMissMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".realHit")), this.realHitMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".staleHit")), this.staleHitMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".fileInvalidation")), this.fileInvalidationMeter);
            metricsToRegister.put((CallSite)((Object)(prefix + ".cacheUpdate")), this.cacheUpdateMeter);
            metricsToRegister.putAll(GuavaCacheMetrics.cacheMetricsSet(prefix, LegacyCache.this.cache).getMetrics());
            metricsToRegister.put((CallSite)((Object)(prefix + ".bytesWeightKB")), new CachedGauge<Long>(5L, TimeUnit.MINUTES){

                public Long loadValue() {
                    long total = 0L;
                    for (Map.Entry entry : LegacyCache.this.cache.asMap().entrySet()) {
                        CacheEntry ce = (CacheEntry)entry.getValue();
                        if (ce == null || ce.content == null) continue;
                        total += ce.content.getInMemoryLength() / 1024L;
                    }
                    return total;
                }
            });
            registry.removeMatching((name, metric) -> metricsToRegister.containsKey(name));
            registry.registerAll(() -> metricsToRegister);
        }
    }

    private static final class CacheEntry {
        public final long lastModified;
        public final FileContent content;

        public CacheEntry(FileContent content, long lastModified) {
            this.lastModified = lastModified;
            this.content = content;
        }
    }
}

