/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.fs.ifaces;

import com.dataiku.dip.transactions.fs.FileContent;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.SubReadWriteFS;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.fs.ifaces.RelFileOutputStream;
import java.io.IOException;

public interface ReadWriteFS
extends ReadOnlyFS {
    public boolean deleteFile(RelFile var1) throws IOException;

    public boolean deleteDirectory(RelFile var1) throws IOException;

    public boolean makeDirectory(RelFile var1) throws IOException;

    public void writeContentUnsafeNoMkdir(RelFile var1, FileContent var2) throws IOException;

    public <T> void writeObjectNoMkdir(String var1, T var2) throws IOException;

    public boolean deleteFile(String var1) throws IOException;

    public RelFileOutputStream writeStream(String var1) throws IOException;

    public boolean deleteDirectory(String var1) throws IOException;

    public boolean makeDirectory(String var1) throws IOException;

    public void writeStringUTF8NoMkdir(String var1, String var2) throws IOException;

    public <T> void writeObjectUnsafeNoMkdir(String var1, T var2) throws IOException;

    public <T> void writeObjectNoMkdir(RelFile var1, T var2) throws IOException;

    public <T> void writeObject(RelFile var1, T var2) throws IOException;

    public <T> void writeObject(String var1, T var2) throws IOException;

    public void writeStringUTF8(String var1, String var2) throws IOException;

    public void writeStringUTF8(RelFile var1, String var2) throws IOException;

    public void copyFile(RelFile var1, RelFile var2) throws IOException;

    public void moveFile(RelFile var1, RelFile var2) throws IOException;

    public void moveFile(String var1, String var2) throws IOException;

    public void copyRelFile(RelFile var1, RelFile var2) throws IOException;

    public void writeBytes(RelFile var1, byte[] var2) throws IOException;

    public void writeBytes(String var1, byte[] var2) throws IOException;

    public void writeStringUTF8NoMkdir(RelFile var1, String var2) throws IOException;

    public <T> void writeObjectUnsafeNoMkdir(RelFile var1, T var2) throws IOException;

    public void writeCompressedBytesUnsafeNoMkdir(RelFile var1, ReadOnlyFS.CompressedFileData var2) throws IOException;

    public RelFileOutputStream writeStreamNoMkdir(RelFile var1) throws IOException;

    public RelFileOutputStream writeStream(RelFile var1) throws IOException;

    @Override
    default public ReadWriteFS directoryView(RelFile dir) throws IOException {
        return new SubReadWriteFS(this, dir);
    }

    @Override
    default public ReadWriteFS directoryView(String path) throws IOException {
        return this.directoryView(RelFile.fromPath(path));
    }

    public ZipWriteFS writeZip(RelFile var1) throws IOException;

    default public ZipWriteFS writeZip(String path) throws IOException {
        return this.writeZip(RelFile.fromPath(path));
    }

    default public boolean deleteFileOrDirectory(RelFile file) throws IOException {
        if (this.isDirectory(file)) {
            return this.deleteDirectory(file);
        }
        if (this.isFile(file)) {
            return this.deleteFile(file);
        }
        return false;
    }

    default public boolean deleteFileOrDirectory(String path) throws IOException {
        return this.deleteFileOrDirectory(RelFile.fromPath(path));
    }
}

