/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.auth;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSCredentialsProvider;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicAWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.BasicSessionCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class EnvironmentVariableCredentialsProvider
implements AWSCredentialsProvider {
    private static final String PROVIDER_NAME = "EnvironmentVariableCredentialsProvider";

    @Override
    public AWSCredentials getCredentials() {
        String secretKey;
        String accessKey = System.getenv("AWS_ACCESS_KEY_ID");
        if (accessKey == null) {
            accessKey = System.getenv("AWS_ACCESS_KEY");
        }
        if ((secretKey = System.getenv("AWS_SECRET_KEY")) == null) {
            secretKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        }
        accessKey = StringUtils.trim(accessKey);
        secretKey = StringUtils.trim(secretKey);
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new SdkClientException("Unable to load AWS credentials from environment variables (AWS_ACCESS_KEY_ID (or AWS_ACCESS_KEY) and AWS_SECRET_KEY (or AWS_SECRET_ACCESS_KEY))");
        }
        String sessionToken = StringUtils.trim(System.getenv("AWS_SESSION_TOKEN"));
        return StringUtils.isNullOrEmpty(sessionToken) ? new BasicAWSCredentials(accessKey, secretKey, null, PROVIDER_NAME) : new BasicSessionCredentials(accessKey, secretKey, sessionToken, null, PROVIDER_NAME);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

