/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateVerifiedAccessInstanceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateVerifiedAccessInstanceRequestMarshaller
implements Marshaller<Request<CreateVerifiedAccessInstanceRequest>, CreateVerifiedAccessInstanceRequest> {
    @Override
    public Request<CreateVerifiedAccessInstanceRequest> marshall(CreateVerifiedAccessInstanceRequest createVerifiedAccessInstanceRequest) {
        SdkInternalList createVerifiedAccessInstanceRequestTagSpecificationsList;
        if (createVerifiedAccessInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVerifiedAccessInstanceRequest> request = new DefaultRequest<CreateVerifiedAccessInstanceRequest>(createVerifiedAccessInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVerifiedAccessInstance");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVerifiedAccessInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createVerifiedAccessInstanceRequest.getDescription()));
        }
        if (!(createVerifiedAccessInstanceRequestTagSpecificationsList = (SdkInternalList)createVerifiedAccessInstanceRequest.getTagSpecifications()).isEmpty() || !createVerifiedAccessInstanceRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVerifiedAccessInstanceRequestTagSpecificationsListValue : createVerifiedAccessInstanceRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVerifiedAccessInstanceRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createVerifiedAccessInstanceRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVerifiedAccessInstanceRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createVerifiedAccessInstanceRequest.getClientToken()));
        if (createVerifiedAccessInstanceRequest.getFIPSEnabled() != null) {
            request.addParameter("FIPSEnabled", StringUtils.fromBoolean(createVerifiedAccessInstanceRequest.getFIPSEnabled()));
        }
        return request;
    }
}

