/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.DescribeInstanceTypesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Filter;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class DescribeInstanceTypesRequestMarshaller
implements Marshaller<Request<DescribeInstanceTypesRequest>, DescribeInstanceTypesRequest> {
    @Override
    public Request<DescribeInstanceTypesRequest> marshall(DescribeInstanceTypesRequest describeInstanceTypesRequest) {
        SdkInternalList describeInstanceTypesRequestFiltersList;
        if (describeInstanceTypesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInstanceTypesRequest> request = new DefaultRequest<DescribeInstanceTypesRequest>(describeInstanceTypesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceTypes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstanceTypesRequestInstanceTypesList = (SdkInternalList)describeInstanceTypesRequest.getInstanceTypes();
        if (!describeInstanceTypesRequestInstanceTypesList.isEmpty() || !describeInstanceTypesRequestInstanceTypesList.isAutoConstruct()) {
            int instanceTypesListIndex = 1;
            for (String describeInstanceTypesRequestInstanceTypesListValue : describeInstanceTypesRequestInstanceTypesList) {
                if (describeInstanceTypesRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString(describeInstanceTypesRequestInstanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (!(describeInstanceTypesRequestFiltersList = (SdkInternalList)describeInstanceTypesRequest.getFilters()).isEmpty() || !describeInstanceTypesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceTypesRequestFiltersListValue : describeInstanceTypesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceTypesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeInstanceTypesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceTypesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeInstanceTypesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeInstanceTypesRequest.getMaxResults()));
        }
        if (describeInstanceTypesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeInstanceTypesRequest.getNextToken()));
        }
        return request;
    }
}

