/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.NetworkCardInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.NetworkInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform.EfaInfoStaxUnmarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform.NetworkCardInfoStaxUnmarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class NetworkInfoStaxUnmarshaller
implements Unmarshaller<NetworkInfo, StaxUnmarshallerContext> {
    private static NetworkInfoStaxUnmarshaller instance;

    @Override
    public NetworkInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInfo networkInfo = new NetworkInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return networkInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("networkPerformance", targetDepth)) {
                    networkInfo.setNetworkPerformance(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumNetworkInterfaces", targetDepth)) {
                    networkInfo.setMaximumNetworkInterfaces(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumNetworkCards", targetDepth)) {
                    networkInfo.setMaximumNetworkCards(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultNetworkCardIndex", targetDepth)) {
                    networkInfo.setDefaultNetworkCardIndex(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkCards", targetDepth)) {
                    networkInfo.withNetworkCards(new ArrayList<NetworkCardInfo>());
                    continue;
                }
                if (context.testExpression("networkCards/item", targetDepth)) {
                    networkInfo.withNetworkCards(NetworkCardInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv4AddressesPerInterface", targetDepth)) {
                    networkInfo.setIpv4AddressesPerInterface(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6AddressesPerInterface", targetDepth)) {
                    networkInfo.setIpv6AddressesPerInterface(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6Supported", targetDepth)) {
                    networkInfo.setIpv6Supported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("enaSupport", targetDepth)) {
                    networkInfo.setEnaSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("efaSupported", targetDepth)) {
                    networkInfo.setEfaSupported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("efaInfo", targetDepth)) {
                    networkInfo.setEfaInfo(EfaInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("encryptionInTransitSupported", targetDepth)) {
                    networkInfo.setEncryptionInTransitSupported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("enaSrdSupported", targetDepth)) continue;
                networkInfo.setEnaSrdSupported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return networkInfo;
    }

    public static NetworkInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkInfoStaxUnmarshaller();
        }
        return instance;
    }
}

