/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeTargetGroupsRequest>, DescribeTargetGroupsRequest> {
    @Override
    public Request<DescribeTargetGroupsRequest> marshall(DescribeTargetGroupsRequest describeTargetGroupsRequest) {
        if (describeTargetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTargetGroupsRequest> request = new DefaultRequest<DescribeTargetGroupsRequest>(describeTargetGroupsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTargetGroups");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeTargetGroupsRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString(describeTargetGroupsRequest.getLoadBalancerArn()));
        }
        if (describeTargetGroupsRequest.getTargetGroupArns() != null) {
            List<String> targetGroupArnsList = describeTargetGroupsRequest.getTargetGroupArns();
            if (targetGroupArnsList.isEmpty()) {
                request.addParameter("TargetGroupArns", "");
            } else {
                int targetGroupArnsListIndex = 1;
                for (String targetGroupArnsListValue : targetGroupArnsList) {
                    if (targetGroupArnsListValue != null) {
                        request.addParameter("TargetGroupArns.member." + targetGroupArnsListIndex, StringUtils.fromString(targetGroupArnsListValue));
                    }
                    ++targetGroupArnsListIndex;
                }
            }
        }
        if (describeTargetGroupsRequest.getNames() != null) {
            List<String> namesList = describeTargetGroupsRequest.getNames();
            if (namesList.isEmpty()) {
                request.addParameter("Names", "");
            } else {
                int namesListIndex = 1;
                for (String namesListValue : namesList) {
                    if (namesListValue != null) {
                        request.addParameter("Names.member." + namesListIndex, StringUtils.fromString(namesListValue));
                    }
                    ++namesListIndex;
                }
            }
        }
        if (describeTargetGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeTargetGroupsRequest.getMarker()));
        }
        if (describeTargetGroupsRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeTargetGroupsRequest.getPageSize()));
        }
        return request;
    }
}

