/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class RemoveListenerCertificatesRequestMarshaller
implements Marshaller<Request<RemoveListenerCertificatesRequest>, RemoveListenerCertificatesRequest> {
    @Override
    public Request<RemoveListenerCertificatesRequest> marshall(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) {
        if (removeListenerCertificatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemoveListenerCertificatesRequest> request = new DefaultRequest<RemoveListenerCertificatesRequest>(removeListenerCertificatesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "RemoveListenerCertificates");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeListenerCertificatesRequest.getListenerArn() != null) {
            request.addParameter("ListenerArn", StringUtils.fromString(removeListenerCertificatesRequest.getListenerArn()));
        }
        if (removeListenerCertificatesRequest.getCertificates() != null) {
            List<Certificate> certificatesList = removeListenerCertificatesRequest.getCertificates();
            if (certificatesList.isEmpty()) {
                request.addParameter("Certificates", "");
            } else {
                int certificatesListIndex = 1;
                for (Certificate certificatesListValue : certificatesList) {
                    if (certificatesListValue != null) {
                        if (certificatesListValue.getCertificateArn() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".CertificateArn", StringUtils.fromString(certificatesListValue.getCertificateArn()));
                        }
                        if (certificatesListValue.getIsDefault() != null) {
                            request.addParameter("Certificates.member." + certificatesListIndex + ".IsDefault", StringUtils.fromBoolean(certificatesListValue.getIsDefault()));
                        }
                    }
                    ++certificatesListIndex;
                }
            }
        }
        return request;
    }
}

