/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import java.util.Random;

public class CloudNetworkServiceUtils {
    private static final int FIRST_B = 150;
    private static final int LAST_B = 200;
    private static final int FIRST_C = 150;
    private static final int LAST_C = 200;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.network");

    public static String findUniqueCIDR(DatabaseAccessService dbService) {
        String cidr;
        Random r = new Random();
        while (true) {
            int b = 150 + r.nextInt(50);
            int c = 150 + r.nextInt(50);
            cidr = "10." + b + "." + c + ".0/24";
            List<VirtualNetwork> results = dbService.listResults(VirtualNetwork.class, "SELECT vn FROM virtualnetwork vn where vn.managedCidr = ?1", cidr);
            if (results.size() == 0) break;
            logger.warnV("CIDR %s already used, trying again", new Object[]{cidr});
        }
        return cidr;
    }
}

