/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.license.License;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.json.GoogleJsonError;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.Compute;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.ComputeRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.AcceleratorConfig;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.AccessConfig;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Address;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.AttachedDisk;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.AttachedDiskInitializeParams;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.CustomerEncryptionKey;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Disk;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.DisksResizeRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.GlobalSetLabelsRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Image;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Instance;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.InstanceAggregatedList;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.InstancesScopedList;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Metadata;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.NetworkInterface;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Operation;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Scheduling;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.ServiceAccount;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Snapshot;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Tags;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Zone;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.ZoneList;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.ZoneSetLabelsRequest;
import com.dataiku.dss.shadelibgcp.com.google.api.services.iam.v1.Iam;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceServiceInterface;
import com.dataiku.fm.cloud.CloudInstanceServiceUtils;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.cloud.VolumeNotFoundException;
import com.dataiku.fm.cloud.gcp.GCPClientService;
import com.dataiku.fm.cloud.gcp.GCPDNSService;
import com.dataiku.fm.cloud.gcp.GCPUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDataVolume;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTag;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.PublicPhysicalInstanceStatus;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesEventLogService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.tag.TagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;

public class GCPCloudInstanceService
implements CloudInstanceServiceInterface {
    public static final long GCP_DISK_RATE_LIMIT_RETRY_DELAY_MILLIS = 100000L;
    public static final long AWS_DISK_OPTIMIZING_RETRY_DELAY_MILLIS = 60000L;
    private static final CloudTag FALLBACK_GOOGLE_PARTNER_CLOUDTAG = new CloudTag("goog-partner-solution", "isol_psn_0014m00001h39q5qai_dataiku");
    @Autowired
    private GCPClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private InstancesEventLogService eventsLogService;
    @Autowired
    private GCPDNSService gcpdnsService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private FMApp fmApp;
    @Autowired
    private TagService tagService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.gcp.instances");

    private GCPInstanceUserDataFMInfo generateFMInfo(Tenant tenant, FMSettings settings, LogicalInstance li) {
        GCPInstanceUserDataFMInfo fmInfo = new GCPInstanceUserDataFMInfo();
        CloudInstanceServiceUtils.fillFMInfo(this.cryptoService, fmInfo, settings, li, this.fmApp);
        switch (li.getVirtualNetwork().getHttpsStrategy()) {
            case NONE: {
                break;
            }
            case SELF_SIGNED: 
            case LETSENCRYPT: {
                fmInfo.domainNamesForCertificate.addAll(this.gcpdnsService.getFQDNs(li.getVirtualNetwork(), li.getLabel()).values());
                if (StringUtils.isNotBlank((String)li.getAdditionalDomainNamesForCertificate())) {
                    JSON.StringList additionalDomainNames = (JSON.StringList)JSON.parse((String)li.getAdditionalDomainNamesForCertificate(), JSON.StringList.class);
                    fmInfo.domainNamesForCertificate.addAll(additionalDomainNames);
                }
                fmInfo.certbotStaging = Boolean.parseBoolean(System.getenv("DKU_FMMAIN_CERTBOT_STAGING"));
                fmInfo.contactMail = li.getVirtualNetwork().getContactMail();
                break;
            }
            case CUSTOM_CERTIFICATE: {
                fmInfo.sslCertificateKeyStorageMode = li.getSSLCertificateKeyStorageMode();
                fmInfo.sslCertificatePEM = li.getSslCertificatePEM();
                fmInfo.sslCertificateGcpSecretId = li.getSslCertificateGcpSecretId();
                break;
            }
            case AWS_ACM_PCA: {
                throw new NotImplementedException("AWS ACM PCA");
            }
        }
        fmInfo.restrictGcpMetadataServerAccess = li.getInstanceSettingsTemplate().isRestrictGcpMetadataServerAccess();
        return fmInfo;
    }

    private String getResourceName(String resourceName, LogicalInstance li, String resourceType) {
        return StringUtils.isBlank((String)resourceName) ? "dss-" + li.getLabel().replaceAll("[^a-z0-9\\-]", "") + "-" + resourceType + "-" + SecretKeyGenerator.generate((int)8) : resourceName;
    }

    @Override
    public void checkInstanceCreation(VirtualNetwork vn, InstanceSettingsTemplate ist) {
        Iam iamClient = this.clientService.getCloudIAMClient(vn.getCloudAccountOrVirtualCloudAccount());
        String serviceAccount = ist.getStartupServiceAccount();
        if (StringUtils.isEmpty((String)serviceAccount)) {
            return;
        }
        String cloudAccount = vn.getCloudAccountOrVirtualCloudAccount().getLabel();
        try {
            Iam.Projects.ServiceAccounts.Get account = iamClient.projects().serviceAccounts().get("projects/" + vn.getCloudAccountOrVirtualCloudAccount().getGcpProjectId() + "/serviceAccounts/" + serviceAccount);
            if (account.isEmpty()) {
                throw new IllegalArgumentException("The service account '" + serviceAccount + "' was not found when using the network cloud account '" + cloudAccount + "'.");
            }
            account.execute();
        }
        catch (GoogleJsonResponseException gexc) {
            if (gexc.getStatusCode() == 403) {
                logger.info((Object)"No right to check if service account exist.");
                return;
            }
            throw new IllegalArgumentException("The service account '" + serviceAccount + "' was not found when using the network cloud account '" + cloudAccount + "': " + gexc.getMessage());
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("The service account '" + serviceAccount + "' was not found when using the network cloud account '" + cloudAccount + "': " + exc.getMessage());
        }
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolume(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li) {
        String zone;
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            zone = this.getZoneFromVirtualNetwork(instanceProjectId, apiClient, li.getVirtualNetwork());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get zone from virtual network's region", e);
        }
        li.setGcpZone(zone);
        Map<String, String> labels = GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li).with(this.buildGoogleTrackerTag(li.getTenant())));
        Disk disk = new Disk().setName(this.getResourceName(li.getGcpDataVolumeName(), li, "data-disk").toLowerCase()).setDescription("Datadir for " + li.getLabel() + " (DSS managed by FM)").setLabels(labels).setSizeGb(Long.valueOf(li.getDataVolumeSizeGB())).setType(String.format("projects/%s/zones/%s/diskTypes/%s", instanceProjectId, zone, li.getDataVolumeType()));
        if (li.getEncryptDataVolume()) {
            CustomerEncryptionKey diskEncryptionKey = new CustomerEncryptionKey();
            if (StringUtils.isNotBlank((String)li.getDataVolumeEncryptionKey())) {
                diskEncryptionKey.setKmsKeyName(li.getDataVolumeEncryptionKey());
            }
            disk.setDiskEncryptionKey(diskEncryptionKey);
        }
        try {
            Compute.Disks.Insert insert = apiClient.disks().insert(instanceProjectId, zone, disk);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)insert, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create disk", e);
        }
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setgcpCIId(FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId()).getGCPCIIdForRegion(zone));
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8).toLowerCase());
        pdv.setLogicalInstance(li);
        pdv.setGcpDiskId(disk.getName());
        pdv.setCreationState(pics);
        pdv.setGrowthState(PhysicalDataVolume.GrowthState.OK);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public PhysicalDataVolume createInitialPhysicalDataVolumeFromExternalSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String externalSnapshotId) {
        throw new UnsupportedOperationException("This feature is not supported for GCP instances");
    }

    private String getZoneFromVirtualNetwork(String projectId, Compute apiClient, VirtualNetwork vn) throws IOException {
        String zone = vn.getGcpZone();
        String subnetworkRegion = vn.getGcpRegion();
        if (StringUtils.isBlank((String)zone)) {
            logger.info((Object)("No zone specified by virtual network, picking a zone of region " + subnetworkRegion));
            Compute.Zones.List list = apiClient.zones().list(projectId);
            ZoneList zonesList = (ZoneList)list.execute();
            while (true) {
                if (zonesList.getItems() != null) {
                    for (Zone zoneItem : zonesList.getItems()) {
                        String zoneRegion = zoneItem.getRegion();
                        if (zoneRegion.contains("/")) {
                            zoneRegion = zoneRegion.substring(zoneRegion.lastIndexOf(47) + 1);
                        }
                        if (!StringUtils.equals((String)subnetworkRegion, (String)zoneRegion)) continue;
                        zone = zoneItem.getName();
                        break;
                    }
                    list.setPageToken(zonesList.getNextPageToken());
                    if (list.getPageToken() == null) break;
                }
                zonesList = (ZoneList)list.execute();
            }
            if (StringUtils.isBlank((String)zone)) {
                throw new IllegalArgumentException("Could not find a usable zone in region " + subnetworkRegion);
            }
        }
        return zone;
    }

    @Override
    public PhysicalDataVolume createPhysicalDataVolumeFromSnapshot(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance li, String snapshotId) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        DataVolumeSnapshot dvs = (DataVolumeSnapshot)this.dbService.getThreadEM().find(DataVolumeSnapshot.class, (Object)snapshotId);
        Map<String, String> labels = GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li, Optional.empty(), Optional.of(dvs.getId())).with(this.buildGoogleTrackerTag(li.getTenant())));
        Disk disk = new Disk().setName(this.getResourceName(li.getGcpDataVolumeName(), li, "data-disk").toLowerCase()).setDescription("Datadir for " + li.getLabel() + " (DSS managed by FM)").setSizeGb(Long.valueOf(li.getDataVolumeSizeGB())).setType(String.format("projects/%s/zones/%s/diskTypes/%s", instanceProjectId, zone, li.getDataVolumeType())).setSourceSnapshot(String.format("global/snapshots/%s", dvs.getGcpSnapshotId())).setLabels(labels);
        if (li.getEncryptDataVolume()) {
            CustomerEncryptionKey diskEncryptionKey = new CustomerEncryptionKey();
            if (StringUtils.isNotBlank((String)li.getDataVolumeEncryptionKey())) {
                diskEncryptionKey.setKmsKeyName(li.getDataVolumeEncryptionKey());
            }
            disk.setDiskEncryptionKey(diskEncryptionKey);
        }
        try {
            Compute.Disks.Insert insert = apiClient.disks().insert(instanceProjectId, zone, disk);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)insert, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create disk", e);
        }
        PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
        pics.setgcpCIId(FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId()).getGCPCIIdForRegion(zone));
        PhysicalDataVolume pdv = new PhysicalDataVolume();
        pdv.setId("pdv-" + SecretKeyGenerator.generate((int)8).toLowerCase());
        pdv.setLogicalInstance(li);
        pdv.setGcpDiskId(disk.getName());
        pdv.setCreationState(pics);
        pdv.setGrowthState(PhysicalDataVolume.GrowthState.OK);
        rwt.getThreadEM().persist((Object)pics);
        rwt.getThreadEM().persist((Object)pdv);
        return pdv;
    }

    @Override
    public DataVolumeSnapshot createPhysicalDataVolumeSnapshot(LogicalInstance li, String snapshotType, String description) {
        String region;
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String zone = li.getGcpZone();
        try {
            region = GCPUtils.getRegionOfZone(instanceProjectId, zone, apiClient);
        }
        catch (Exception e) {
            region = DKUApp.getProperty((String)"dku.fm.gcp.snapshot.default-location", (String)"eu");
            logger.warn((Object)("Unable to get region from zone '" + zone + "', default set to '" + region + "'"), (Throwable)e);
        }
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No Physical Data Volume for instance: " + li.getId());
        }
        long now = System.currentTimeMillis();
        Map<String, String> labels = GCPUtils.fromCloudTags(this.tagService.getSnapshotCloudApplicableTags(li, snapshotType, description, Optional.empty()).with(this.buildGoogleTrackerTag(li.getTenant())));
        Snapshot snapshot = new Snapshot().setName("dss-snap-" + SecretKeyGenerator.generate((int)8).toLowerCase()).setDescription(String.format("fm-snap-%s-%s-%s", li.getId(), description, DKUDateUtils.isoFormatFileFriendlyLocal((long)now))).setStorageLocations((List)Lists.newArrayList((Object[])new String[]{region})).setLabels(labels);
        try {
            Compute.Disks.CreateSnapshot createSnapshot = apiClient.disks().createSnapshot(instanceProjectId, zone, pdv.getGcpDiskId(), snapshot);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)createSnapshot, instanceProjectId, apiClient);
        }
        catch (GoogleJsonResponseException googleException) {
            GoogleJsonError error = googleException.getDetails();
            if (error != null && error.getCode() == 404) {
                throw new VolumeNotFoundException(pdv.getGcpDiskId(), new RuntimeException(googleException));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create snapshot", e);
        }
        DataVolumeSnapshot dvs = new DataVolumeSnapshot();
        dvs.setId("dvs-" + SecretKeyGenerator.generate((int)12).toLowerCase());
        dvs.setLogicalInstance(li);
        dvs.setGcpSnapshotId(snapshot.getName());
        dvs.setCreationDate(now);
        dvs.setSnapshotType(snapshotType);
        dvs.setDescription(description);
        return dvs;
    }

    @Override
    public void deletePhysicalDataVolumeSnapshot(DataVolumeSnapshot dataVolumeSnapshot, LogicalInstance li) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            Compute.Snapshots.Delete delete = apiClient.snapshots().delete(instanceProjectId, dataVolumeSnapshot.getGcpSnapshotId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)delete, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to delete snapshot", e);
        }
    }

    @Override
    public void deletePhysicalDataVolume(PhysicalDataVolume physicalDataVolume, LogicalInstance li) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            Compute.Disks.Delete delete = apiClient.disks().delete(instanceProjectId, zone, physicalDataVolume.getGcpDiskId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)delete, instanceProjectId, apiClient);
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() != 404) {
                throw new IllegalArgumentException("Unable to delete disk", e);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to delete disk", e);
        }
    }

    private long getImageSize(Compute apiClient, String instanceProjectId, String imageId) {
        Pattern imageFamilyWithProject = Pattern.compile("^(.*/)?projects/([^/]+)/global/images/family/(.*)$");
        Pattern imageIdWithProject = Pattern.compile("^(.*/)?projects/([^/]+)/global/images/(.*)$");
        Matcher imageFamilyWithProjectMatch = imageFamilyWithProject.matcher(imageId);
        Matcher imageIdWithProjectMatch = imageIdWithProject.matcher(imageId);
        Long imageSize = null;
        try {
            if (imageFamilyWithProjectMatch.matches()) {
                imageSize = ((Image)apiClient.images().getFromFamily(imageFamilyWithProjectMatch.group(2), imageFamilyWithProjectMatch.group(3)).execute()).getDiskSizeGb();
            } else if (imageIdWithProjectMatch.matches()) {
                imageSize = ((Image)apiClient.images().get(imageIdWithProjectMatch.group(2), imageIdWithProjectMatch.group(3)).execute()).getDiskSizeGb();
            } else if (!imageId.contains("/")) {
                imageSize = ((Image)apiClient.images().get(instanceProjectId, imageId).execute()).getDiskSizeGb();
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to inspect image to get disk size, assuming 20GB", (Throwable)e);
        }
        if (imageSize == null) {
            imageSize = 32L;
        }
        return imageSize;
    }

    @Override
    public String createPhysicalInstance(LogicalInstance li, DKUtils.SmartLogTailBuilder smartLogTail) throws MessagingException, IOException {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String networkProjectId = GCPUtils.getNetworkProjectId(li.getVirtualNetwork(), li.getTenant(), settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        if (pdv == null) {
            throw new IllegalStateException("No PDV for instance: " + li.getId());
        }
        Hibernate.initialize((Object)li.getTenant());
        Tenant tenant = li.getTenant();
        assert (tenant != null);
        String dssInstance = this.getResourceName(li.getGcpInstanceName(), li, "vm").toLowerCase();
        String physicalInstanceId = "pi-" + SecretKeyGenerator.generate((int)12).toLowerCase();
        logger.info((Object)("Creating the physical instance: " + physicalInstanceId));
        PhysicalInstance pi = new PhysicalInstance();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            PhysicalInstanceCreationState pics = this.instancesService.createStateSnapshot(rwt, li);
            pi.setId(physicalInstanceId);
            pi.setLogicalInstance(li);
            pi.setCreationState(pics);
            rwt.getThreadEM().persist((Object)pics);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        logger.info((Object)("Created the physical instance: " + physicalInstanceId));
        String cloudInstanceType = li.getCloudInstanceType();
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("cloudInstanceType", cloudInstanceType).with("imageId", li.getImageId()));
        VirtualNetwork vn = li.getVirtualNetwork();
        String diskName = pdv.getGcpDiskId();
        String subnetworkName = vn.getGcpSubnetwork();
        String subnetworkRegion = vn.getGcpRegion();
        Map<String, String> labels = GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li, physicalInstanceId).with(this.buildGoogleTrackerTag(tenant)));
        String imageId = FMApp.getInstanceImagesSettings(settings.cloud).get(li.getImageId()).getGCPCIIdForRegion(zone);
        long imageSize = this.getImageSize(apiClient, instanceProjectId, imageId);
        if (li.getRootVolumeSizeGB() != null) {
            imageSize = Math.max(imageSize, (long)li.getRootVolumeSizeGB().intValue());
        }
        logger.info((Object)("Created OS disk with size= " + imageSize));
        AttachedDiskInitializeParams installDiskParams = new AttachedDiskInitializeParams().setSourceImage(imageId).setDiskSizeGb(Long.valueOf(imageSize)).setDiskType(String.format("projects/%s/zones/%s/diskTypes/%s", instanceProjectId, zone, "pd-standard")).setLabels(labels);
        AttachedDisk installDisk = new AttachedDisk().setDeviceName("install").setInitializeParams(installDiskParams).setType("PERSISTENT").setBoot(Boolean.valueOf(true)).setMode("READ_WRITE").setAutoDelete(Boolean.valueOf(true));
        if (li.getEncryptRootVolume()) {
            CustomerEncryptionKey diskEncryptionKey = new CustomerEncryptionKey();
            if (StringUtils.isNotBlank((String)li.getDataVolumeEncryptionKey())) {
                diskEncryptionKey.setKmsKeyName(li.getDataVolumeEncryptionKey());
            }
            installDisk.setDiskEncryptionKey(diskEncryptionKey);
        }
        Disk existingDataDisk = null;
        try {
            existingDataDisk = (Disk)apiClient.disks().get(instanceProjectId, zone, diskName).execute();
        }
        catch (GoogleJsonResponseException e) {
            GoogleJsonError error = e.getDetails();
            if (error != null && error.getCode() == 404) {
                throw new IllegalStateException(String.format("Data disk '%s' was not found, either reprovision from a snapshot, or re-create a new DSS instance using template '%s'", pdv.getGcpDiskId(), li.getInstanceSettingsTemplate().getId()));
            }
            throw e;
        }
        AttachedDisk dataDisk = new AttachedDisk().setDeviceName(diskName).setSource(String.format("projects/%s/zones/%s/disks/%s", instanceProjectId, zone, diskName)).setType("PERSISTENT").setBoot(Boolean.valueOf(false)).setMode("READ_WRITE").setAutoDelete(Boolean.valueOf(false));
        ArrayList accessConfigs = Lists.newArrayList();
        logger.info((Object)("Assign Public IP: " + li.isGcpAssignPublicIP() + " / " + vn.isGcpAssignPublicIP() + " -> " + StringUtils.defaultIfBlank((String)li.getGcpPublicIPId(), (String)"** auto **")));
        if (vn.isGcpAssignPublicIP() || li.isGcpAssignPublicIP()) {
            AccessConfig accessConfig = new AccessConfig().setName("Instance NAT").setKind("ONE_TO_ONE_NAT");
            if (li.isGcpAssignPublicIP() && StringUtils.isNotBlank((String)li.getGcpPublicIPId())) {
                Address address = (Address)apiClient.addresses().get(instanceProjectId, subnetworkRegion, li.getGcpPublicIPId()).execute();
                accessConfig.setNatIP(address.getAddress());
            }
            accessConfigs.add(accessConfig);
        }
        NetworkInterface networkInterface = new NetworkInterface().setSubnetwork(String.format("projects/%s/regions/%s/subnetworks/%s", networkProjectId, subnetworkRegion, subnetworkName)).setAccessConfigs((List)accessConfigs);
        if (StringUtils.isNotBlank((String)li.getGcpPrivateIP())) {
            networkInterface.setNetworkIP(li.getGcpPrivateIP());
        }
        String serviceAccountEmail = null;
        if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getStartupServiceAccount())) {
            serviceAccountEmail = li.getInstanceSettingsTemplate().getStartupServiceAccount();
        }
        ArrayList serviceAccounts = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)serviceAccountEmail)) {
            serviceAccounts.add(new ServiceAccount().setEmail(serviceAccountEmail).setScopes((List)Lists.newArrayList((Object[])new String[]{"https://www.googleapis.com/auth/cloud-platform"})));
        }
        String userData = CloudInstanceServiceUtils.generateUserData(this.generateFMInfo(tenant, settings, li));
        logger.info((Object)("Sending metadata:\n" + userData));
        ArrayList metadataItems = Lists.newArrayList((Object[])new Metadata.Items[]{new Metadata.Items().setKey("user-data").setValue(userData)});
        if (li.getInstanceSettingsTemplate().isGcpBlockProjectWideKeys()) {
            metadataItems.add(new Metadata.Items().setKey("block-project-ssh-keys").setValue("true"));
        }
        if (StringUtils.isNotBlank((String)li.getInstanceSettingsTemplate().getGcpSshKey())) {
            metadataItems.add(new Metadata.Items().setKey("ssh-keys").setValue("centos:" + li.getInstanceSettingsTemplate().getGcpSshKey().trim()));
        }
        Metadata metadata = new Metadata().setItems((List)metadataItems);
        HashMap accelerators = Maps.newHashMap();
        Pattern acceleratorsPattern = Pattern.compile("^(.*)\\((.*)\\)$");
        Matcher acceleratorsMatcher = acceleratorsPattern.matcher(cloudInstanceType);
        if (acceleratorsMatcher.matches()) {
            String acceleratorsDesc = acceleratorsMatcher.group(2);
            cloudInstanceType = acceleratorsMatcher.group(1);
            for (String acceleratorDesc : acceleratorsDesc.split(",")) {
                String acceleratorName = acceleratorDesc.trim();
                int acceleratorCount = 1;
                Pattern acceleratorPattern = Pattern.compile("^(.*)=([0-9]+)$");
                Matcher acceleratorMatcher = acceleratorPattern.matcher(acceleratorName);
                if (acceleratorMatcher.matches()) {
                    acceleratorName = acceleratorMatcher.group(1).trim();
                    acceleratorCount = Integer.parseInt(acceleratorMatcher.group(2));
                }
                acceleratorName = acceleratorName.replace("${projectId}", instanceProjectId).replace("${zone}", zone);
                accelerators.put(acceleratorName, acceleratorCount);
            }
        }
        Instance instance = new Instance().setName(dssInstance).setLabels(labels).setDisks((List)Lists.newArrayList((Object[])new AttachedDisk[]{installDisk, dataDisk})).setMachineType(String.format("projects/%s/zones/%s/machineTypes/%s", instanceProjectId, zone, cloudInstanceType)).setNetworkInterfaces((List)Lists.newArrayList((Object[])new NetworkInterface[]{networkInterface})).setServiceAccounts((List)serviceAccounts).setMetadata(metadata);
        if (!accelerators.isEmpty()) {
            instance.setGuestAccelerators(accelerators.entrySet().stream().map(a -> new AcceleratorConfig().setAcceleratorType((String)a.getKey()).setAcceleratorCount((Integer)a.getValue())).collect(Collectors.toList()));
            instance.setScheduling(new Scheduling().setAutomaticRestart(Boolean.valueOf(false)).setOnHostMaintenance("TERMINATE"));
        }
        if (StringUtils.isNotBlank((String)vn.getGcpNetworkTags())) {
            Tags networkTags = new Tags();
            networkTags.setItems((List)Lists.newArrayList((Object[])vn.getGcpNetworkTags().split(",")));
            instance.setTags(networkTags);
        }
        try {
            Optional<String> restoredFromFMSnapshotIdOptional = Optional.ofNullable(existingDataDisk.getSourceSnapshotId()).filter(StringUtils::isNotBlank);
            Map<String, String> dataDiskLabels = GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li, Optional.of(physicalInstanceId), restoredFromFMSnapshotIdOptional).with(this.buildGoogleTrackerTag(tenant)));
            String previousLabelFingerprint = existingDataDisk.getLabelFingerprint();
            ZoneSetLabelsRequest tagsRequest = new ZoneSetLabelsRequest().setLabelFingerprint(previousLabelFingerprint).setLabels(dataDiskLabels);
            apiClient.disks().setLabels(instanceProjectId, zone, existingDataDisk.getName(), tagsRequest).execute();
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Unable to update tags on data disk '%s' in zone '%s' from project '%s'. Skipping.", new Object[]{existingDataDisk.getName(), zone, instanceProjectId});
        }
        try {
            Compute.Instances.Insert insert = apiClient.instances().insert(instanceProjectId, zone, instance);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)insert, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create instance", e);
        }
        String vmInstanceId = instance.getName();
        this.eventsLogService.addEventASync_NT(li, null, "pi-creation-vm-started", JF.obj().with("physicalInstanceId", physicalInstanceId).with("gcpGCEInstanceId", vmInstanceId));
        this.eventsLogService.addEventASync_NT(li, null, "pi-volume-attached", JF.obj().with("physicalInstanceId", physicalInstanceId).with("gcpGCEInstanceId", vmInstanceId));
        logger.info((Object)("Updating physical instance: " + physicalInstanceId + " with VM instance id: " + vmInstanceId));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            pi = (PhysicalInstance)this.dbService.getThreadEM().find(PhysicalInstance.class, (Object)physicalInstanceId);
            pi.setGcpGCEInstanceId(vmInstanceId);
            rwt.getThreadEM().persist((Object)pi);
            rwt.commit();
        }
        this.gcpdnsService.updateDnsRecords(apiClient, pi, GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li)));
        try {
            List<DataVolumeSnapshot> snapshots = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from datavolumesnapshot dvs where dvs.logicalInstance=?1", li);
            if (snapshots == null || snapshots.isEmpty()) {
                logger.debugV("The instance '%s' has no linked snapshots, or none was found", new Object[]{li.getLabel()});
            } else {
                snapshots.stream().filter(snapshot -> StringUtils.isNotBlank((String)snapshot.getGcpSnapshotId())).forEach(snapshot -> {
                    try {
                        Snapshot gcpSnapshot = (Snapshot)apiClient.snapshots().get(instanceProjectId, snapshot.getGcpSnapshotId()).execute();
                        CloudTagList newSnapshotLabels = this.tagService.getSnapshotCloudApplicableTags(li, physicalInstanceId, snapshot.getSnapshotType(), snapshot.getDescription(), Optional.empty()).with(this.buildGoogleTrackerTag(tenant));
                        GlobalSetLabelsRequest request = new GlobalSetLabelsRequest().setLabelFingerprint(gcpSnapshot.getLabelFingerprint()).setLabels(GCPUtils.fromCloudTags(newSnapshotLabels));
                        apiClient.snapshots().setLabels(instanceProjectId, snapshot.getGcpSnapshotId(), request).execute();
                    }
                    catch (IOException e) {
                        logger.warnV((Throwable)e, "Error updating labels on snapshot '%s' for instance '%s'. Skipping.", new Object[]{snapshot.getGcpSnapshotId(), li.getLabel()});
                    }
                });
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error updating labels on snapshots for instance '%s'. Skipping.", new Object[]{li.getLabel()});
        }
        return physicalInstanceId;
    }

    @Override
    public boolean growPhysicalDataVolume(LogicalInstance li, double growthFactor) {
        PhysicalDataVolume pdv = InstancesHelper.getVolume(this.dbService, li);
        logger.info((Object)("growPhysicalDataVolume pdv.getGrowthState()=" + String.valueOf((Object)pdv.getGrowthState()) + " pdv.getLastGrowthStateChangedTimestamp()=" + pdv.getLastGrowthStateChangedTimestamp()));
        boolean growthSuccessful = false;
        long dslc = System.currentTimeMillis() - pdv.getLastGrowthStateChangedTimestamp();
        if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.OK || 60000L < dslc && pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_OPTIMTIZING || 100000L < dslc && pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT) {
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
            String zone = li.getGcpZone();
            Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                int currentSize = li.getDataVolumeSizeGB();
                int newSize = (int)Math.ceil(growthFactor * (double)currentSize);
                if (newSize <= currentSize) {
                    newSize = currentSize + 1;
                }
                if (li.getDataVolumeSizeMaxGB() < newSize) {
                    newSize = li.getDataVolumeSizeMaxGB();
                }
                DisksResizeRequest resizeRequest = new DisksResizeRequest();
                resizeRequest.setSizeGb(Long.valueOf(newSize));
                try {
                    Compute.Disks.Resize resize = apiClient.disks().resize(instanceProjectId, zone, pdv.getGcpDiskId(), resizeRequest);
                    GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)resize, instanceProjectId, apiClient);
                    li.setDataVolumeSizeGB(newSize);
                    growthSuccessful = true;
                }
                catch (GoogleJsonResponseException e) {
                    logger.warn((Object)"Volume cannot be grown", (Throwable)e);
                    GoogleJsonError.ErrorInfo errorInfo = null;
                    if (e.getDetails().getErrors() != null && !e.getDetails().getErrors().isEmpty()) {
                        errorInfo = (GoogleJsonError.ErrorInfo)e.getDetails().getErrors().get(0);
                    }
                    if (errorInfo != null && "rateLimitExceeded".equals(errorInfo.getReason())) {
                        pdv.setGrowthState(PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT);
                        pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    }
                    if (errorInfo != null && "invalidResourceUsage".equals(errorInfo.getReason())) {
                        pdv.setGrowthState(PhysicalDataVolume.GrowthState.AWS_OPTIMTIZING);
                        pdv.setLastGrowthStateChangedTimestamp(System.currentTimeMillis());
                    }
                    throw new IllegalArgumentException("Unable to resize disk", e);
                }
                catch (Exception e) {
                    logger.warn((Object)"Volume cannot be grown", (Throwable)e);
                    throw new IllegalArgumentException("Unable to resize disk", e);
                }
                rwt.getThreadEM().persist((Object)pdv);
                rwt.getThreadEM().persist((Object)li);
                rwt.commit();
            }
        }
        logger.debugV("Error delays not expired, disk growth skipped li=%s, pdv=%s", new Object[]{li, pdv});
        return growthSuccessful;
    }

    @Override
    public void terminatePhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(pi, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            Compute.Instances.Delete delete = apiClient.instances().delete(instanceProjectId, zone, pi.getGcpGCEInstanceId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)delete, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to terminate instance", e);
        }
        this.gcpdnsService.removeDNSRecords(pi.getLogicalInstance().getVirtualNetwork(), pi.getLogicalInstance().getLabel(), DNSservice.RecordType.A, true);
    }

    @Override
    public void startPhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(pi, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            logger.infoV("Requesting start of instance li=%s pi=%s gce=%s", new Object[]{pi.getId(), li.getId(), pi.getGcpGCEInstanceId()});
            Compute.Instances.Start start = apiClient.instances().start(instanceProjectId, zone, pi.getGcpGCEInstanceId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)start, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to start instance", e);
        }
        this.gcpdnsService.updateDnsRecords(apiClient, pi, GCPUtils.fromCloudTags(this.tagService.getCloudApplicableTags(li)));
    }

    @Override
    public void stopPhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(pi, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            logger.infoV("Requesting stop of instance li=%s pi=%s gce=%s", new Object[]{pi.getId(), li.getId(), pi.getGcpGCEInstanceId()});
            Compute.Instances.Stop stop = apiClient.instances().stop(instanceProjectId, zone, pi.getGcpGCEInstanceId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)stop, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to start instance", e);
        }
    }

    @Override
    public void rebootPhysicalInstance(PhysicalInstance pi) {
        LogicalInstance li = pi.getLogicalInstance();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(pi, settings);
        String zone = li.getGcpZone();
        Compute apiClient = this.clientService.getAPIClient(pi.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            logger.infoV("Requesting reboot of instance li=%s pi=%s gce=%s", new Object[]{pi.getId(), li.getId(), pi.getGcpGCEInstanceId()});
            Compute.Instances.Reset reset = apiClient.instances().reset(instanceProjectId, zone, pi.getGcpGCEInstanceId());
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)reset, instanceProjectId, apiClient);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to start instance", e);
        }
    }

    @Override
    public void configurePhysicalInstanceBeforeStartupPhase(PhysicalInstance physicalInstance) {
    }

    @Override
    public void configurePhysicalInstanceAfterStartupPhase(PhysicalInstance pi) {
    }

    @Override
    public Collection<PhysicalInstanceCloudState> getPhysicalInstancesCloudState(Tenant tenant, Collection<PhysicalInstance> piList) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        return piList.stream().collect(Collectors.groupingBy(physicalInstance -> physicalInstance.getLogicalInstance().getVirtualNetwork().getCloudAccountOrVirtualCloudAccount())).entrySet().stream().flatMap(e -> this.getPhysicalInstanceCloudStates((CloudAccount)e.getKey(), tenant, (Collection)e.getValue(), settings).stream()).collect(Collectors.toList());
    }

    private Collection<PhysicalInstanceCloudState> getPhysicalInstanceCloudStates(CloudAccount cloudAccount, Tenant tenant, Collection<PhysicalInstance> piList, FMSettings settings) {
        Compute apiClient = this.clientService.getAPIClient(cloudAccount);
        HashMap<String, PhysicalInstanceCloudState> cloudStateMap = new HashMap<String, PhysicalInstanceCloudState>();
        HashSet instanceProjectIds = Sets.newHashSet();
        for (PhysicalInstance pi : piList) {
            cloudStateMap.put(pi.getGcpGCEInstanceId(), new PhysicalInstanceCloudState(pi));
            String instanceProjectId = GCPUtils.getInstanceProjectId(pi, tenant, settings);
            instanceProjectIds.add(instanceProjectId);
        }
        block3: for (String instanceProjectId : instanceProjectIds) {
            try {
                Compute.Instances.AggregatedList list = apiClient.instances().aggregatedList(instanceProjectId);
                InstanceAggregatedList instancesList = (InstanceAggregatedList)list.execute();
                while (true) {
                    if (instancesList.getItems() != null) {
                        for (Map.Entry zoneInstances : instancesList.getItems().entrySet()) {
                            for (Instance instance : ((InstancesScopedList)zoneInstances.getValue()).getInstances()) {
                                PhysicalInstanceCloudState state = (PhysicalInstanceCloudState)cloudStateMap.get(instance.getName());
                                if (state == null) {
                                    logger.warn((Object)("Received instance state about a non-requested instance: " + instance.getName()));
                                    continue;
                                }
                                state.cloudMachineExists = true;
                                if (!instance.getStatus().equalsIgnoreCase("RUNNING")) continue;
                                state.cloudMachineIsUp = true;
                            }
                        }
                        list.setPageToken(instancesList.getNextPageToken());
                        if (list.getPageToken() == null) continue block3;
                    }
                    instancesList = (InstanceAggregatedList)list.execute();
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to describe instances, they are probably not available", (Throwable)e);
            }
        }
        return cloudStateMap.values();
    }

    @Override
    public void fillPhysicalStatusWithCloudSpecificData(PhysicalInstance pi, PhysicalDataVolume pdv, PublicPhysicalInstanceStatus status) {
        long remainingTimeMillis;
        LogicalInstance li = pi.getLogicalInstance();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, settings);
        String zone = li.getGcpZone();
        status.gcpProjectId = instanceProjectId;
        status.gcpZone = zone;
        status.externalURL = pi.getLogicalInstance().getExternalURL();
        Compute apiClient = this.clientService.getAPIClient(li.getVirtualNetwork().getCloudAccountOrVirtualCloudAccount());
        try {
            Instance instance = (Instance)apiClient.instances().get(instanceProjectId, zone, StringUtils.defaultIfEmpty((String)pi.getGcpGCEInstanceId(), (String)"not-yet-started")).execute();
            status.cloudMachineExists = true;
            status.gcpInstanceName = instance.getName();
            AttachedDisk dataDisk = instance.getDisks().stream().filter(d -> d.getBoot() == null || d.getBoot() == false).findFirst().orElse(null);
            String string = status.gcpDataVolumeName = dataDisk == null ? "" : dataDisk.getDeviceName();
            if (instance.getStatus().equalsIgnoreCase("RUNNING")) {
                status.cloudMachineIsUp = true;
            } else {
                if (instance.getStatus().equalsIgnoreCase("STOPPING")) {
                    status.cloudInTransition = true;
                }
                status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "GCE machine is not RUNNING: it is '%s'", new Object[]{instance.getStatus()});
            }
            if (instance.getNetworkInterfaces().isEmpty()) {
                status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "GCE machine has no network interface", new Object[0]);
            } else {
                NetworkInterface networkInterface = (NetworkInterface)instance.getNetworkInterfaces().get(0);
                status.privateIP = networkInterface.getNetworkIP();
                if (networkInterface.getAccessConfigs() == null || networkInterface.getAccessConfigs().isEmpty()) {
                    status.statusMessages.withInfo((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "GCE machine has a network without public access");
                } else {
                    AccessConfig accessConfig = (AccessConfig)networkInterface.getAccessConfigs().get(0);
                    status.publicIP = accessConfig.getNatIP();
                }
            }
        }
        catch (GoogleJsonResponseException e) {
            logger.warn((Object)"Failed to describe instance, it's probably not available", (Throwable)e);
            status.cloudMachineExists = false;
            status.statusMessages.withFatalV((InfoMessage.MessageCode)FMServerCodes.ERR_INSTANCE_NOT_DEPLOYED, "Failed to get the status of the GCE machine: %s", new Object[]{e.getContent()});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to inspect instance", e);
        }
        VirtualNetwork virtualNetwork = li.getVirtualNetwork();
        status.privateDNS = pi.getPrivateDnsName();
        status.privateURL = GCPCloudInstanceService.computeUrl(virtualNetwork, status.privateDNS, status.privateIP);
        status.publicDNS = pi.getPublicDnsName();
        status.publicURL = StringUtils.isBlank((String)status.externalURL) ? GCPCloudInstanceService.computeUrl(virtualNetwork, status.publicDNS, status.publicIP) : status.externalURL;
        if (pdv.getGrowthState() == PhysicalDataVolume.GrowthState.AWS_RATE_LIMIT && 0L < (remainingTimeMillis = 100000L - System.currentTimeMillis() + pdv.getLastGrowthStateChangedTimestamp())) {
            long remainingHours = TimeUnit.MILLISECONDS.toHours(remainingTimeMillis);
            long remainingMinutes = TimeUnit.MILLISECONDS.toMinutes(remainingTimeMillis - 3600000L * remainingHours);
            status.statusMessages.withWarningV((InfoMessage.MessageCode)FMServerCodes.WARN_DATA_VOLUME_CANNOT_GROW, "GCP volume exceeded the growth rate limit. Remaining time before next growth: %d hour(s) and %d minute(s)", new Object[]{remainingHours, remainingMinutes});
        }
    }

    private static String computeUrl(VirtualNetwork virtualNetwork, String dnsName, String ip) {
        String prefix;
        String string = prefix = virtualNetwork.getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? "http://" : "https://";
        if (dnsName != null) {
            return StringUtils.removeEnd((String)(prefix + dnsName), (String)".");
        }
        if (ip != null) {
            return prefix + ip;
        }
        return null;
    }

    private CloudTag buildGoogleTrackerTag(Tenant tenant) {
        return Optional.ofNullable(tenant.getLicense()).filter(StringUtils::isNotBlank).map(licenseText -> (License)JSON.parse((String)licenseText, License.class)).flatMap(license -> Optional.ofNullable((String)license.content.properties.get("partner.google.urn"))).map(urn -> new CloudTag("goog-partner-solution", (String)urn)).orElse(FALLBACK_GOOGLE_PARTNER_CLOUDTAG);
    }

    static class GCPInstanceUserDataFMInfo
    extends CloudInstanceServiceUtils.BaseInstanceUserDataFMInfo {
        boolean restrictGcpMetadataServerAccess;
        String sslCertificateGcpSecretId;

        GCPInstanceUserDataFMInfo() {
        }
    }
}

