/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.Compute;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.AccessConfig;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.Instance;
import com.dataiku.dss.shadelibgcp.com.google.api.services.compute.model.NetworkInterface;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.Dns;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.model.Change;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.model.ManagedZone;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.model.ResourceRecordSet;
import com.dataiku.dss.shadelibgcp.com.google.api.services.dns.model.ResourceRecordSetsListResponse;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.gcp.GCPClientService;
import com.dataiku.fm.cloud.gcp.GCPUtils;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.utils.DnsUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GCPDNSService
implements DNSservice {
    @Autowired
    private GCPClientService clientService;
    @Autowired
    private DatabaseAccessService dbService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.gcp.dns");

    @Override
    public Map<DNSservice.ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork virtualNetwork, String recordName, String targetPublicIP, String targetPrivateIp, DNSservice.RecordType recordType, Map<String, String> tags) {
        HashMap<DNSservice.ZoneType, PhysicalDNSRecord> result = new HashMap<DNSservice.ZoneType, PhysicalDNSRecord>();
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Dns dnsClient = this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount());
        String networkProjectId = GCPUtils.getNetworkProjectId(virtualNetwork, virtualNetwork.getTenant(), settings);
        VirtualNetwork.DNSStrategy dnsStrategy = virtualNetwork.getDnsStrategy();
        switch (dnsStrategy) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                if (StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPrivateIPZoneId()) && targetPrivateIp != null) {
                    logger.infoV("Update DNS record for private IP for record '%s'", new Object[]{recordName});
                    zoneId = virtualNetwork.getGcpCloudDnsPrivateIPZoneId();
                    zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                    String privateDnsName = DnsUtils.safeDnsName(recordName, zoneName);
                    this.addOrUpdateDNSRecord(dnsClient, networkProjectId, zoneId, privateDnsName, targetPrivateIp);
                    result.put(DNSservice.ZoneType.PRIVATE, new PhysicalDNSRecord(recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PRIVATE));
                }
                if (!StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPublicIPZoneId()) || targetPublicIP == null) break;
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                zoneId = virtualNetwork.getGcpCloudDnsPublicIPZoneId();
                zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                String publicDnsName = DnsUtils.safeDnsName(recordName, zoneName);
                this.addOrUpdateDNSRecord(dnsClient, networkProjectId, zoneId, publicDnsName, targetPublicIP);
                result.put(DNSservice.ZoneType.PUBLIC, new PhysicalDNSRecord(recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                String zoneId = virtualNetwork.getTenant().getGcpCloudDnsManagedZoneId();
                String zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = DnsUtils.safeDnsName(recordName, subzone, zoneName);
                this.addOrUpdateDNSRecord(dnsClient, networkProjectId, zoneId, publicDnsName, targetPublicIP);
                result.put(DNSservice.ZoneType.PUBLIC, new PhysicalDNSRecord(recordName, zoneId, DNSservice.RecordType.A, DNSservice.ZoneType.PUBLIC));
                break;
            }
        }
        return result;
    }

    @Override
    public void removeDNSRecords(VirtualNetwork virtualNetwork, String recordName, DNSservice.RecordType recordType, boolean computeDNSNameWithZone) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        Dns dnsClient = this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount());
        String networkProjectId = GCPUtils.getNetworkProjectId(virtualNetwork, virtualNetwork.getTenant(), settings);
        VirtualNetwork.DNSStrategy dnsStrategy = virtualNetwork.getDnsStrategy();
        switch (dnsStrategy) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                if (StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPrivateIPZoneId())) {
                    logger.infoV("Update DNS record for private IP for record '%s'", new Object[]{recordName});
                    zoneId = virtualNetwork.getGcpCloudDnsPrivateIPZoneId();
                    zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                    String privateDnsName = DnsUtils.safeDnsName(recordName, zoneName);
                    this.deleteDNSRecord(dnsClient, networkProjectId, zoneId, privateDnsName, recordType);
                }
                if (!StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPublicIPZoneId())) break;
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                zoneId = virtualNetwork.getGcpCloudDnsPublicIPZoneId();
                zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                String publicDnsName = DnsUtils.safeDnsName(recordName, zoneName);
                this.deleteDNSRecord(dnsClient, networkProjectId, zoneId, publicDnsName, recordType);
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                logger.infoV("Update DNS record for public IP for record '%s'", new Object[]{recordName});
                String zoneId = virtualNetwork.getTenant().getGcpCloudDnsManagedZoneId();
                String zoneName = this.getDnsNameFromZoneId(dnsClient, networkProjectId, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                String publicDnsName = DnsUtils.safeDnsName(recordName, subzone, zoneName);
                this.deleteDNSRecord(dnsClient, networkProjectId, zoneId, publicDnsName, recordType);
                break;
            }
        }
    }

    @Override
    public Map<DNSservice.ZoneType, String> getFQDNs(VirtualNetwork virtualNetwork, String recordName) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String projectId = GCPUtils.getNetworkProjectId(virtualNetwork, virtualNetwork.getTenant(), settings);
        HashMap<DNSservice.ZoneType, String> hostnames = new HashMap<DNSservice.ZoneType, String>();
        switch (virtualNetwork.getDnsStrategy()) {
            case NONE: {
                break;
            }
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                String zoneName;
                String zoneId;
                if (StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPublicIPZoneId())) {
                    zoneId = virtualNetwork.getGcpCloudDnsPublicIPZoneId();
                    zoneName = this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                    hostnames.put(DNSservice.ZoneType.PUBLIC, DnsUtils.relativeSafeDnsName(recordName, zoneName));
                }
                if (!StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPrivateIPZoneId())) break;
                zoneId = virtualNetwork.getGcpCloudDnsPrivateIPZoneId();
                zoneName = this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                hostnames.put(DNSservice.ZoneType.PRIVATE, DnsUtils.relativeSafeDnsName(recordName, zoneName));
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String zoneId = virtualNetwork.getTenant().getGcpCloudDnsManagedZoneId();
                String zoneName = this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                hostnames.put(DNSservice.ZoneType.PUBLIC, DnsUtils.relativeSafeDnsName(recordName, subzone, zoneName));
                break;
            }
        }
        return hostnames;
    }

    @Override
    public String getPublicDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.getDNSZoneDomain(virtualNetwork, DNSservice.ZoneType.PUBLIC);
    }

    @Override
    public String getPrivateDNSZoneDomain(VirtualNetwork virtualNetwork) {
        return this.getDNSZoneDomain(virtualNetwork, DNSservice.ZoneType.PRIVATE);
    }

    private String getDNSZoneDomain(VirtualNetwork virtualNetwork, DNSservice.ZoneType zoneType) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String projectId = GCPUtils.getNetworkProjectId(virtualNetwork, virtualNetwork.getTenant(), settings);
        VirtualNetwork.DNSStrategy dnsStrategy = virtualNetwork.getDnsStrategy();
        Object dnsName = "";
        switch (dnsStrategy) {
            case VN_SPECIFIC_CLOUD_DNS_SERVICE: {
                if (zoneType == DNSservice.ZoneType.PUBLIC && StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPublicIPZoneId())) {
                    String zoneId = virtualNetwork.getGcpCloudDnsPublicIPZoneId();
                    dnsName = this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                    break;
                }
                if (zoneType != DNSservice.ZoneType.PRIVATE || !StringUtils.isNotBlank((String)virtualNetwork.getGcpCloudDnsPrivateIPZoneId())) break;
                String zoneId = virtualNetwork.getGcpCloudDnsPrivateIPZoneId();
                dnsName = this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                break;
            }
            case FM_MANAGED_CLOUD_DNS_SERVICE: {
                String zoneId = virtualNetwork.getTenant().getGcpCloudDnsManagedZoneId();
                String subzone = virtualNetwork.getTenant().getId().replaceAll("-", "").toLowerCase(Locale.ENGLISH);
                dnsName = subzone + "." + this.getDnsNameFromZoneId(this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount()), projectId, zoneId);
                break;
            }
        }
        if (((String)dnsName).endsWith(".")) {
            return ((String)dnsName).substring(0, ((String)dnsName).length() - 1);
        }
        return dnsName;
    }

    @Override
    public void checkIfZoneExist(VirtualNetwork virtualNetwork, String zoneId) {
        Dns dnsClient = this.clientService.getCloudDNSClient(virtualNetwork.getCloudAccountOrVirtualCloudAccount());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String projectId = GCPUtils.getNetworkProjectId(virtualNetwork, virtualNetwork.getTenant(), settings);
        try {
            logger.info((Object)("Get DNS zone name for " + zoneId + " of " + projectId));
            dnsClient.managedZones().get(projectId, "global", zoneId).execute();
        }
        catch (Exception e) {
            throw new ApplicativeException("Invalid DNS Zone Identifier", "The DNS zone '" + zoneId + "' cannot be retrieved from GCP project '" + projectId + "'.");
        }
    }

    private void addOrUpdateDNSRecord(Dns dnsClient, String projectId, String zoneId, String recordName, String ip) {
        try {
            logger.info((Object)("Update DNS record " + recordName + " in " + zoneId + " of " + projectId));
            ArrayList records = Lists.newArrayList();
            Dns.ResourceRecordSets.List listing = dnsClient.resourceRecordSets().list(projectId, "global", zoneId);
            ResourceRecordSetsListResponse list = (ResourceRecordSetsListResponse)listing.execute();
            while (true) {
                if (list.getRrsets() != null) {
                    records.addAll(list.getRrsets());
                }
                listing.setPageToken(list.getNextPageToken());
                if (list.getNextPageToken() == null) break;
                list = (ResourceRecordSetsListResponse)listing.execute();
            }
            ResourceRecordSet existing = records.stream().filter(r -> r.getType().equals("A") && r.getName().equals(recordName)).findAny().orElse(null);
            ResourceRecordSet added = new ResourceRecordSet();
            added.setName(recordName);
            added.setType("A");
            added.setTtl(Integer.valueOf(300));
            added.setRrdatas((List)Lists.newArrayList((Object[])new String[]{ip}));
            Change change = new Change();
            if (existing != null) {
                change.setDeletions((List)Lists.newArrayList((Object[])new ResourceRecordSet[]{existing}));
            }
            change.setAdditions((List)Lists.newArrayList((Object[])new ResourceRecordSet[]{added}));
            dnsClient.changes().create(projectId, "global", zoneId, change).execute();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to adjust DNS records", e);
        }
    }

    private Optional<String> getDNSRecord(Dns dnsClient, String projectId, String zoneId, String recordName, DNSservice.RecordType recordType) {
        try {
            logger.info((Object)("Update DNS record " + recordName + " in " + zoneId + " of " + projectId));
            ArrayList records = Lists.newArrayList();
            Dns.ResourceRecordSets.List listing = dnsClient.resourceRecordSets().list(projectId, "global", zoneId);
            ResourceRecordSetsListResponse list = (ResourceRecordSetsListResponse)listing.execute();
            while (true) {
                if (list.getRrsets() != null) {
                    records.addAll(list.getRrsets());
                }
                listing.setPageToken(list.getNextPageToken());
                if (list.getNextPageToken() == null) break;
                list = (ResourceRecordSetsListResponse)listing.execute();
            }
            return records.stream().filter(r -> r.getName().equals(recordName)).filter(r -> r.getType().equals(recordType.name())).findAny().flatMap(r -> r.getRrdatas().stream().findAny());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to adjust DNS records", e);
        }
    }

    private void deleteDNSRecord(Dns dnsClient, String projectId, String zoneId, String recordName, DNSservice.RecordType recordType) {
        try {
            logger.info((Object)("Delete DNS record " + recordName + " in " + zoneId + " of " + projectId));
            ArrayList records = Lists.newArrayList();
            Dns.ResourceRecordSets.List listing = dnsClient.resourceRecordSets().list(projectId, "global", zoneId);
            ResourceRecordSetsListResponse list = (ResourceRecordSetsListResponse)listing.execute();
            while (true) {
                if (list.getRrsets() != null) {
                    records.addAll(list.getRrsets());
                }
                listing.setPageToken(list.getNextPageToken());
                if (list.getNextPageToken() == null) break;
                list = (ResourceRecordSetsListResponse)listing.execute();
            }
            ResourceRecordSet existing = records.stream().filter(r -> r.getType().equals(recordType.name()) && r.getName().equals(recordName)).findAny().orElse(null);
            Change change = new Change();
            if (existing != null) {
                change.setDeletions((List)Lists.newArrayList((Object[])new ResourceRecordSet[]{existing}));
            }
            dnsClient.changes().create(projectId, "global", zoneId, change).execute();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to adjust DNS records", e);
        }
    }

    public void updateDnsRecords(Compute apiClient, PhysicalInstance pi, Map<String, String> tags) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        LogicalInstance li = pi.getLogicalInstance();
        VirtualNetwork virtualNetwork = li.getVirtualNetwork();
        String vmInstanceId = pi.getGcpGCEInstanceId();
        String instanceProjectId = GCPUtils.getInstanceProjectId(li, virtualNetwork.getTenant(), settings);
        String zone = li.getGcpZone();
        String privateIP = null;
        String publicIP = null;
        try {
            Instance instance = (Instance)apiClient.instances().get(instanceProjectId, zone, StringUtils.defaultIfEmpty((String)vmInstanceId, (String)"not-yet-started")).execute();
            if (!instance.getNetworkInterfaces().isEmpty()) {
                NetworkInterface networkInterface = (NetworkInterface)instance.getNetworkInterfaces().get(0);
                privateIP = networkInterface.getNetworkIP();
                if (networkInterface.getAccessConfigs() != null && !networkInterface.getAccessConfigs().isEmpty()) {
                    AccessConfig accessConfig = (AccessConfig)networkInterface.getAccessConfigs().get(0);
                    publicIP = accessConfig.getNatIP();
                }
            }
        }
        catch (GoogleJsonResponseException e) {
            logger.warn((Object)"Failed to describe instance, it's probably not available", (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to inspect instance", e);
        }
        this.addDNSRecords(virtualNetwork, li.getLabel(), publicIP, privateIP, DNSservice.RecordType.A, tags);
        Map<DNSservice.ZoneType, String> hostnames = this.getFQDNs(virtualNetwork, li.getLabel());
        if (hostnames != null) {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                if (hostnames.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                    pi.setPrivateDnsName(hostnames.get((Object)DNSservice.ZoneType.PRIVATE));
                }
                if (hostnames.containsKey((Object)DNSservice.ZoneType.PUBLIC)) {
                    pi.setPublicDnsName(hostnames.get((Object)DNSservice.ZoneType.PUBLIC));
                }
                rwt.getThreadEM().persist((Object)pi);
                rwt.commit();
            }
        }
    }

    private String getDnsNameFromZoneId(Dns dnsClient, String projectId, String zoneId) {
        try {
            logger.info((Object)("Get DNS zone name for " + zoneId + " of " + projectId));
            ManagedZone zone = (ManagedZone)dnsClient.managedZones().get(projectId, "global", zoneId).execute();
            return zone.getDnsName();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to adjust DNS records", e);
        }
    }
}

