/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.license;

import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.utils.Params;
import org.apache.log4j.Logger;

public class MinimalDSSLicenseParser {
    private static Logger logger = Logger.getLogger((String)"dku.fm.license");

    public static FMLicenseFeaturesStatus parse(License license) {
        FMLicenseFeaturesStatus ret = new FMLicenseFeaturesStatus();
        ret.license = license;
        try {
            if (System.getenv("DKU_HA_LICENSE") == null) {
                LicenseUtils.verify((License)license);
            }
            ret.valid = true;
        }
        catch (Exception e) {
            ret.invalidMessage = e.getMessage();
        }
        Params params = new Params(license.content.properties);
        String standardOffer = params.getParam("standardOffer", null);
        if (standardOffer != null) {
            switch (standardOffer) {
                case "custom-discover-2021": 
                case "cloudstacks-discover-2021": 
                case "discover-fy2023-1": 
                case "cloustacks-discover-fy2023-1": {
                    ret.fmMaxDesignNodes = 1;
                    ret.fmMaxAutomationNodes = 0;
                    ret.fmMaxDeployerNodes = 0;
                    break;
                }
                case "custom-business-2021": 
                case "cloudstacks-business-2021": 
                case "business-fy2023-1": 
                case "cloudstacks-business-fy2023-1": {
                    ret.fmMaxDesignNodes = 1;
                    ret.fmMaxAutomationNodes = 1;
                    ret.fmMaxDeployerNodes = 1;
                    break;
                }
                case "custom-enterprise-2021": 
                case "cloudstacks-enterprise-2021": 
                case "enterprise-fy2023-1": 
                case "cloudstacks-enterprise-fy2023-1": {
                    break;
                }
                case "online-discover-fy2023-1": 
                case "online-business-fy2023-1": {
                    logger.warn((Object)("Online license offer in a Fleet Manager?! Unexpected: " + standardOffer));
                    break;
                }
                default: {
                    logger.warn((Object)("Unrecognized standard offer?! Unexpected: " + standardOffer));
                }
            }
        }
        return ret;
    }

    public static class FMLicenseFeaturesStatus {
        public boolean valid;
        public String invalidMessage;
        public License license;
        public Integer fmMaxDesignNodes;
        public Integer fmMaxAutomationNodes;
        public Integer fmMaxDeployerNodes;
    }
}

