/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.Tenant;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.util.Objects;

@Entity(name="instancesettingstemplate")
public class InstanceSettingsTemplate {
    @Id
    private String id;
    private String label;
    @Column(columnDefinition="text")
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    private Tenant tenant;
    @Column(columnDefinition="text")
    public String license;
    public Integer dssPort = 10000;
    private Boolean storiesEnabled;
    private boolean forSnapshot;
    private String copiedFromId;
    @Column(columnDefinition="text")
    private String setupActions;
    @Column(columnDefinition="text")
    private String azureSshKey;
    @Column(columnDefinition="text")
    private String gcpSshKey;
    private String awsKeyPairName;
    private String startupInstanceProfileArn;
    private String runtimeInstanceProfileArn;
    private String startupManagedIdentity;
    private String runtimeManagedIdentity;
    private String startupServiceAccount;
    private Boolean restrictAwsMetadataServerAccess;
    private Boolean restrictGcpMetadataServerAccess;
    private Boolean gcpBlockProjectWideKeys;
    private Boolean restrictAzureMetadataServerAccess;
    @Enumerated(value=EnumType.STRING)
    private DataikuAWSAPIAccessMode dataikuAwsAPIAccessMode = DataikuAWSAPIAccessMode.NONE;
    @Enumerated(value=EnumType.STRING)
    private DataikuAWSKeypairStorageMode dataikuAwsKeypairStorageMode = DataikuAWSKeypairStorageMode.NONE;
    private String dataikuAwsAccessKeyId;
    @Column(columnDefinition="text")
    private String dataikuAwsSecretAccessKey;
    private String dataikuAwsSecretAccessKeyAwsSecretName;

    public String getStartupManagedIdentity() {
        return this.startupManagedIdentity;
    }

    public void setStartupManagedIdentity(String startupManagedIdentity) {
        this.startupManagedIdentity = startupManagedIdentity;
    }

    public String getRuntimeManagedIdentity() {
        return this.runtimeManagedIdentity;
    }

    public void setRuntimeManagedIdentity(String runtimeManagedIdentity) {
        this.runtimeManagedIdentity = runtimeManagedIdentity;
    }

    public String getStartupServiceAccount() {
        return this.startupServiceAccount;
    }

    public void setStartupServiceAccount(String startupServiceAccount) {
        this.startupServiceAccount = startupServiceAccount;
    }

    public String getCopiedFromId() {
        return this.copiedFromId;
    }

    public void setCopiedFromId(String copiedFromId) {
        this.copiedFromId = copiedFromId;
    }

    public InstanceSettingsTemplate copyWithoutId() {
        InstanceSettingsTemplate newIST = new InstanceSettingsTemplate();
        newIST.label = this.getLabel();
        newIST.description = this.getDescription();
        newIST.tenant = this.getTenant();
        newIST.license = this.getLicense();
        newIST.forSnapshot = this.isForSnapshot();
        newIST.copiedFromId = this.getCopiedFromId();
        newIST.setupActions = this.getSetupActions();
        newIST.awsKeyPairName = this.getAwsKeyPairName();
        newIST.azureSshKey = this.getAzureSshKey();
        newIST.gcpSshKey = this.getGcpSshKey();
        newIST.startupInstanceProfileArn = this.getStartupInstanceProfileArn();
        newIST.runtimeInstanceProfileArn = this.getRuntimeInstanceProfileArn();
        newIST.startupManagedIdentity = this.getStartupManagedIdentity();
        newIST.runtimeManagedIdentity = this.getRuntimeManagedIdentity();
        newIST.startupServiceAccount = this.getStartupServiceAccount();
        newIST.dataikuAwsAPIAccessMode = this.getDataikuAWSAPIAccessMode();
        newIST.dataikuAwsKeypairStorageMode = this.getDataikuAwsKeypairStorageMode();
        newIST.dataikuAwsAccessKeyId = this.getDataikuAwsAccessKeyId();
        newIST.dataikuAwsSecretAccessKey = this.getDataikuAwsSecretAccessKey();
        newIST.dataikuAwsSecretAccessKeyAwsSecretName = this.getDataikuAwsSecretAccessKeyAwsSecretName();
        newIST.storiesEnabled = this.getStoriesEnabled();
        return newIST;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSetupActions() {
        return this.setupActions;
    }

    public void setSetupActions(String setupActions) {
        this.setupActions = setupActions;
    }

    public String getAzureSshKey() {
        return this.azureSshKey;
    }

    public void setAzureSshKey(String azureSshKey) {
        this.azureSshKey = azureSshKey;
    }

    public String getGcpSshKey() {
        return this.gcpSshKey;
    }

    public void setGcpSshKey(String gcpSshKey) {
        this.gcpSshKey = gcpSshKey;
    }

    public boolean isForSnapshot() {
        return this.forSnapshot;
    }

    public void setForSnapshot(boolean forSnapshot) {
        this.forSnapshot = forSnapshot;
    }

    public Tenant getTenant() {
        return this.tenant;
    }

    public void setTenant(Tenant tenant) {
        this.tenant = tenant;
    }

    public String getAwsKeyPairName() {
        return this.awsKeyPairName;
    }

    public void setAwsKeyPairName(String awsKeyPairName) {
        this.awsKeyPairName = awsKeyPairName;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getRuntimeInstanceProfileArn() {
        return this.runtimeInstanceProfileArn;
    }

    public void setRuntimeInstanceProfileArn(String runtimeInstanceProfileArn) {
        this.runtimeInstanceProfileArn = runtimeInstanceProfileArn;
    }

    public String getStartupInstanceProfileArn() {
        return this.startupInstanceProfileArn;
    }

    public void setStartupInstanceProfileArn(String startupInstanceProfileArn) {
        this.startupInstanceProfileArn = startupInstanceProfileArn;
    }

    public boolean isRestrictAwsMetadataServerAccess() {
        return this.restrictAwsMetadataServerAccess != null && this.restrictAwsMetadataServerAccess != false;
    }

    public void setRestrictAwsMetadataServerAccess(boolean restrictAwsMetadataServerAccess) {
        this.restrictAwsMetadataServerAccess = restrictAwsMetadataServerAccess;
    }

    public boolean isRestrictGcpMetadataServerAccess() {
        return this.restrictGcpMetadataServerAccess != null && this.restrictGcpMetadataServerAccess != false;
    }

    public void setRestrictGcpMetadataServerAccess(boolean restrictGcpMetadataServerAccess) {
        this.restrictGcpMetadataServerAccess = restrictGcpMetadataServerAccess;
    }

    public boolean isGcpBlockProjectWideKeys() {
        return this.gcpBlockProjectWideKeys != null && this.gcpBlockProjectWideKeys != false;
    }

    public void setGcpBlockProjectWideKeys(boolean gcpBlockProjectWideKeys) {
        this.gcpBlockProjectWideKeys = gcpBlockProjectWideKeys;
    }

    public boolean isRestrictAzureMetadataServerAccess() {
        return this.restrictAzureMetadataServerAccess != null && this.restrictAzureMetadataServerAccess != false;
    }

    public void setRestrictAzureMetadataServerAccess(boolean restrictAzureMetadataServerAccess) {
        this.restrictAzureMetadataServerAccess = restrictAzureMetadataServerAccess;
    }

    public DataikuAWSAPIAccessMode getDataikuAWSAPIAccessMode() {
        return this.dataikuAwsAPIAccessMode;
    }

    public void setDataikuAWSAPIAccessMode(DataikuAWSAPIAccessMode dataikuAWSAPIAccessMode) {
        this.dataikuAwsAPIAccessMode = dataikuAWSAPIAccessMode;
    }

    public DataikuAWSKeypairStorageMode getDataikuAwsKeypairStorageMode() {
        return this.dataikuAwsKeypairStorageMode;
    }

    public void setDataikuAwsKeypairStorageMode(DataikuAWSKeypairStorageMode dataikuAwsKeypairStorageMode) {
        this.dataikuAwsKeypairStorageMode = dataikuAwsKeypairStorageMode;
    }

    public String getDataikuAwsAccessKeyId() {
        return this.dataikuAwsAccessKeyId;
    }

    public void setDataikuAwsAccessKeyId(String dataikuAwsAccessKeyId) {
        this.dataikuAwsAccessKeyId = dataikuAwsAccessKeyId;
    }

    public String getDataikuAwsSecretAccessKey() {
        return this.dataikuAwsSecretAccessKey;
    }

    public void setDataikuAwsSecretAccessKey(String dataikuAwsSecretAccessKey) {
        this.dataikuAwsSecretAccessKey = dataikuAwsSecretAccessKey;
    }

    public String getDataikuAwsSecretAccessKeyAwsSecretName() {
        return this.dataikuAwsSecretAccessKeyAwsSecretName;
    }

    public void setDataikuAwsSecretAccessKeyAwsSecretName(String dataikuAwsSecretAccessKeyAwsSecretName) {
        this.dataikuAwsSecretAccessKeyAwsSecretName = dataikuAwsSecretAccessKeyAwsSecretName;
    }

    public Integer getDssPort() {
        return this.dssPort;
    }

    public void setDssPort(Integer dssPort) {
        this.dssPort = dssPort;
    }

    public Boolean getStoriesEnabled() {
        return this.storiesEnabled != null && this.storiesEnabled != false;
    }

    public void setStoriesEnabled(boolean storiesEnabled) {
        this.storiesEnabled = storiesEnabled;
    }

    public boolean sameAs(InstanceSettingsTemplate other) {
        return other != null && Objects.equals(this.getLicense(), other.getLicense()) && Objects.equals(this.getSetupActions(), other.getSetupActions()) && Objects.equals(this.getAzureSshKey(), other.getAzureSshKey()) && Objects.equals(this.getGcpSshKey(), other.getGcpSshKey()) && Objects.equals(this.getAwsKeyPairName(), other.getAwsKeyPairName()) && Objects.equals(this.getStartupInstanceProfileArn(), other.getStartupInstanceProfileArn()) && Objects.equals(this.getRuntimeInstanceProfileArn(), other.getRuntimeInstanceProfileArn()) && Objects.equals(this.getRuntimeManagedIdentity(), other.getRuntimeManagedIdentity()) && Objects.equals(this.getStartupManagedIdentity(), other.getStartupManagedIdentity()) && Objects.equals(this.getStartupServiceAccount(), other.getStartupServiceAccount()) && this.getDataikuAWSAPIAccessMode() == other.getDataikuAWSAPIAccessMode() && this.getDataikuAwsKeypairStorageMode() == other.getDataikuAwsKeypairStorageMode() && Objects.equals(this.getDataikuAwsAccessKeyId(), other.getDataikuAwsAccessKeyId()) && Objects.equals(this.getDataikuAwsSecretAccessKey(), other.getDataikuAwsSecretAccessKey()) && Objects.equals(this.getDataikuAwsSecretAccessKeyAwsSecretName(), other.getDataikuAwsSecretAccessKeyAwsSecretName()) && Objects.equals(this.getDssPort(), other.getDssPort()) && Objects.equals(this.getStoriesEnabled(), other.getStoriesEnabled());
    }

    public static enum DataikuAWSAPIAccessMode {
        NONE,
        KEYPAIR;

    }

    public static enum DataikuAWSKeypairStorageMode {
        NONE,
        INLINE_ENCRYPTED,
        AWS_SECRETS_MANAGER;

    }

    public static enum CertificateContentType {
        PKCS12,
        PEM;

    }
}

