/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.accounts;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudAccountDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AccountsController
extends DIPInternalControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private CloudAccountsService cloudAccountsService;

    @RequestMapping(value={"/api/ui/accounts/list"})
    public void listAccounts(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        AccountsController.writeJSON((HttpServletResponse)resp, this.cloudAccountsService.list(tenant));
    }

    @RequestMapping(value={"/api/ui/accounts/get"})
    public void getAccount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String accountId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        AccountsController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.getAccountDTO(tenant, accountId));
    }

    @RequestMapping(value={"/api/ui/accounts/create"})
    public void createAccount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String account) throws Exception {
        CloudAccountDTO dto = (CloudAccountDTO)JSON.parse((String)account, CloudAccountDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccountDTO cloudAccountDTO = this.cloudAccountsService.create(tenant, dto);
        AccountsController.writeJSON((HttpServletResponse)resp, (Object)cloudAccountDTO);
    }

    @RequestMapping(value={"/api/ui/accounts/delete"})
    public void deleteAccount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String accountId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        AccountsController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.delete(tenant, accountId));
    }

    @RequestMapping(value={"/api/ui/accounts/save"})
    public void saveAccount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String account) throws Exception {
        CloudAccountDTO dto = (CloudAccountDTO)JSON.parse((String)account, CloudAccountDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccountDTO update = this.cloudAccountsService.save(tenant, dto);
        AccountsController.writeJSON((HttpServletResponse)resp, (Object)update);
    }

    @RequestMapping(value={"/api/ui/accounts/get-creation-data"})
    public void getCreationData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        AccountsController.writeJSON((HttpServletResponse)resp, (Object)CreationDataUtils.getNetworkCreationData(tenant));
    }
}

